/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.launch;

import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.ftt.core.language.manager.ILanguage;
import com.ibm.ftt.core.language.manager.ILanguageManager;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.debug.ui.IIDzInfoProvider;
import com.ibm.ftt.language.manager.LanguageManagerFactory;
import com.ibm.ftt.resources.core.physical.IAbstractResource;
import com.ibm.ftt.resources.core.physical.IMVSFileMapping;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.PBSystemIFileProperties;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import java.util.Locale;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class LaunchPropertyTester
extends PropertyTester {
    private static final String JCL = "jcl";
    public static final String EXE = "exe";
    private static final String IS_DEBUGGABLE = "isDebuggable";
    private static final String IS_LOAD_MODULE = "isLoadModule";
    private static final String IS_JCL = "isJCL";
    private static final String IS_STANDALONE = "isStandalone";
    private static final String HAS_PROFILES = "hasProfiles";
    private static final String HAS_CONNECTIONS = "hasConnections";
    private static final ILanguageManager fManager = LanguageManagerFactory.getSingleton();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.equals(IS_DEBUGGABLE)) {
            return this.isLoadModule(receiver, args, expectedValue) || this.isSourceMember(receiver, args, expectedValue);
        }
        if (property.equals(IS_LOAD_MODULE)) {
            return this.isLoadModule(receiver, args, expectedValue);
        }
        if (property.equals(IS_JCL)) {
            return this.isSourceMemberJCL(receiver, args, expectedValue);
        }
        if (property.equals(IS_STANDALONE)) {
            return expectedValue.equals(LaunchPropertyTester.isStandaloneDebug());
        }
        if (property.equals(HAS_PROFILES)) {
            return this.hasProfiles(receiver, args, expectedValue);
        }
        if (property.equals(HAS_CONNECTIONS)) {
            return this.hasConnections(receiver, args, expectedValue);
        }
        return true;
    }

    private boolean isLoadModule(Object receiver, Object[] args, Object expectedValue) {
        Object item;
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (receiver instanceof IStructuredSelection && expectedValue instanceof String) {
            IStructuredSelection sel = (IStructuredSelection)receiver;
            Object[] objectArray = sel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item2 = objectArray[n2];
                if (!this.isLoadModule(item2, args, expectedValue)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (receiver instanceof IZOSDataSetMember && ((IZOSDataSetMember)receiver).getFileExtension() != null) {
            return this.matchesResult(((IZOSDataSetMember)receiver).getFileExtension().equals(EXE), expectedValue);
        }
        if (receiver instanceof MVSFileResource) {
            return this.isLoadModule(((MVSFileResource)receiver).getZOSResource(), args, expectedValue);
        }
        if (provider != null && provider.handles(receiver) && (item = provider.getAdapter(receiver, IZOSDataSetMember.class)) != null) {
            return this.isLoadModule(item, args, expectedValue);
        }
        return this.matchesResult(false, expectedValue);
    }

    private boolean isSourceMember(Object receiver, Object[] args, Object expectedValue) {
        Object item;
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (receiver instanceof IStructuredSelection && expectedValue instanceof String) {
            IStructuredSelection sel = (IStructuredSelection)receiver;
            Object[] objectArray = sel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item2 = objectArray[n2];
                if (!this.isLoadModule(item2, args, expectedValue)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (receiver instanceof IZOSDataSetMember) {
            ILanguage lang = fManager.getLanguage((IPhysicalResource)((IZOSDataSetMember)receiver));
            return this.matchesResult(lang != null, expectedValue);
        }
        if (receiver instanceof MVSFileResource) {
            return this.isSourceMember(((MVSFileResource)receiver).getZOSResource(), args, expectedValue);
        }
        if (receiver instanceof IFileEditorInput) {
            ILanguage lang = fManager.getLanguage((IEditorInput)((IFileEditorInput)receiver));
            return this.matchesResult(lang != null, expectedValue);
        }
        if (provider != null && provider.handles(receiver) && (item = provider.getAdapter(receiver, IZOSDataSetMember.class)) != null) {
            return this.isSourceMember(item, args, expectedValue);
        }
        return this.matchesResult(false, expectedValue);
    }

    private boolean isSourceMemberJCL(Object receiver, Object[] args, Object expectedValue) {
        Object item;
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (receiver instanceof IStructuredSelection && expectedValue instanceof String) {
            IStructuredSelection sel = (IStructuredSelection)receiver;
            Object[] objectArray = sel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item2 = objectArray[n2];
                if (!this.isLoadModule(item2, args, expectedValue)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (receiver instanceof IZOSDataSetMember) {
            IMVSFileMapping.TransferMode mode = ((IZOSDataSetMember)receiver).getMVSFileMapping().getTransferMode2();
            String fileExtension = ((IZOSDataSetMember)receiver).getFileExtension();
            return this.matchesResult(mode.equals((Object)IMVSFileMapping.TransferMode.TEXT) && fileExtension != null && fileExtension.toLowerCase(Locale.getDefault()).equals(JCL), expectedValue);
        }
        if (receiver instanceof MVSFileResource) {
            return this.isSourceMemberJCL(((MVSFileResource)receiver).getZOSResource(), args, expectedValue);
        }
        if (receiver instanceof IFileEditorInput) {
            return this.isIFileJCL(((IFileEditorInput)receiver).getFile(), expectedValue);
        }
        if (receiver instanceof IFile) {
            return this.isIFileJCL((IFile)receiver, expectedValue);
        }
        if (receiver instanceof FileStoreEditorInput) {
            String name = ((FileStoreEditorInput)receiver).getName();
            int idx = name.lastIndexOf(46);
            if (idx > -1) {
                return this.isFileExtensionJCL(name.substring(idx + 1), expectedValue);
            }
            return this.matchesResult(false, expectedValue);
        }
        if (provider != null && provider.handles(receiver) && (item = provider.getAdapter(receiver, IZOSDataSetMember.class)) != null) {
            return this.isSourceMemberJCL(item, args, expectedValue);
        }
        return this.matchesResult(false, expectedValue);
    }

    private boolean isFileExtensionJCL(String fileExtension, Object expectedValue) {
        return this.matchesResult(fileExtension != null && fileExtension.toLowerCase(Locale.getDefault()).equals(JCL), expectedValue);
    }

    private boolean isIFileJCL(IFile file, Object expectedValue) {
        return this.isFileExtensionJCL(file == null ? null : file.getFileExtension(), expectedValue);
    }

    private boolean matchesResult(boolean value, Object expectedValue) {
        if (expectedValue instanceof Boolean) {
            return value == (Boolean)expectedValue;
        }
        if (expectedValue instanceof String) {
            return this.matchesResult(value, Boolean.valueOf((String)expectedValue));
        }
        return false;
    }

    static boolean isStandaloneDebug() {
        return DebugLaunchUtils.isStandaloneDebug();
    }

    private boolean hasProfiles(Object receiver, Object[] args, Object expectedValue) {
        Object item;
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (receiver instanceof IZOSDataSetMember) {
            IZOSSystemImage system = (IZOSSystemImage)((IZOSDataSetMember)receiver).getSystem();
            return this.matchesResult(this.hasProfile(system.getName()), expectedValue);
        }
        if (receiver instanceof MVSFileResource) {
            return this.hasProfiles(((MVSFileResource)receiver).getZOSResource(), args, expectedValue);
        }
        if (receiver instanceof IFile) {
            return this.matchesResult(this.profilesExist(), expectedValue);
        }
        if (receiver instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)receiver).getFile();
            if (file != null) {
                PBSystemIFileProperties props = new PBSystemIFileProperties((IResource)file);
                Object editObject = props.getRemoteEditObject();
                if (editObject instanceof IAbstractResource) {
                    return this.hasProfiles(editObject, args, expectedValue);
                }
                return this.hasProfiles(file, args, expectedValue);
            }
        } else if (provider != null && provider.handles(receiver) && (item = provider.getAdapter(receiver, IZOSDataSetMember.class)) != null) {
            return this.hasProfiles(item, args, expectedValue);
        }
        return this.matchesResult(false, expectedValue);
    }

    private boolean hasProfile(String name) {
        for (DebugProfile p : DebugProfileRoot.getInstance().getDebugProfiles()) {
            if (!(p instanceof DebugProfileDTSP) || p.getConnectionName() == null || !p.getConnectionName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean profilesExist() {
        for (DebugProfile p : DebugProfileRoot.getInstance().getDebugProfiles()) {
            if (!(p instanceof DebugProfileDTSP) || p.getConnectionName() == null) continue;
            return true;
        }
        return false;
    }

    private boolean hasConnections(Object receiver, Object[] args, Object expectedValue) {
        Object[] systems;
        Object[] objectArray = systems = PhysicalSystemRegistryFactory.getSingleton().getSystems(2);
        int n = systems.length;
        int n2 = 0;
        while (n2 < n) {
            Object system = objectArray[n2];
            if (system instanceof IZOSSystemImage) {
                return this.matchesResult(true, expectedValue);
            }
            ++n2;
        }
        return this.matchesResult(false, expectedValue);
    }
}

