/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.composites;

import com.ibm.debug.pdt.internal.ui.AbstractDebugComposite;
import com.ibm.ftt.debug.ui.Labels;
import com.ibm.ftt.debug.ui.composites.DebugOptionsComposite;
import com.ibm.ftt.debug.ui.composites.IConnectionProvider;
import com.ibm.ftt.debug.ui.composites.IConnectionSettingsCompositeListener;
import com.ibm.ftt.debug.ui.composites.ISourceLookupCompositeListener;
import com.ibm.ftt.debug.ui.tabs.HostFilter;
import com.ibm.ftt.debug.ui.util.DebugJCLGenerationUtils;
import com.ibm.ftt.debug.ui.util.DebugLaunchUIUtils;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.ui.rse.utils.RSESelectRemoteFolderDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SourceLookupComposite
extends AbstractDebugComposite
implements SelectionListener,
ModifyListener,
ISelectionChangedListener,
IConnectionSettingsCompositeListener {
    private static final String EMPTY = "";
    private Text fFileField;
    private Button fAddButton;
    private ISourceLookupCompositeListener fListener;
    private TableViewer fLookupTable;
    private Button fBrowseButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;
    private Combo fTypeCombo;
    private IHost fConnection;
    private ArrayList<DebugJCLGenerationUtils.SourceLookupItem> fListItems = new ArrayList();
    private Map<DebugJCLGenerationUtils.DD_TYPE, List<DebugJCLGenerationUtils.SourceLookupItem>> fListItemMap = new HashMap<DebugJCLGenerationUtils.DD_TYPE, List<DebugJCLGenerationUtils.SourceLookupItem>>();
    private int fSelectedType;
    private IConnectionProvider fProvider;
    private boolean fIsAlwaysAllowBrowse = false;

    public SourceLookupComposite(ISourceLookupCompositeListener listener, Composite parent, int style) {
        this(listener, parent, style, false);
    }

    public SourceLookupComposite(ISourceLookupCompositeListener listener, Composite parent, int style, boolean groupMode) {
        super(parent, style);
        int numCols = groupMode ? 4 : 5;
        GridDataFactory.fillDefaults().applyTo((Control)this);
        SourceLookupComposite newParent = this;
        if (groupMode) {
            Group group = new Group((Composite)this, 0);
            group.setText(Labels.SOURCE_LOOKUP_NOC);
            newParent = group;
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)this);
            GridLayoutFactory.swtDefaults().numColumns(numCols).applyTo((Composite)newParent);
        } else {
            GridLayoutFactory.fillDefaults().numColumns(numCols).applyTo((Composite)newParent);
        }
        this.fListener = listener;
        if (!groupMode) {
            Label sourceLookupLabel = new Label((Composite)newParent, 0);
            sourceLookupLabel.setText(Labels.SOURCE_LOOKUP);
            GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)sourceLookupLabel);
        }
        this.fFileField = new Text((Composite)newParent, 2048);
        this.fFileField.addModifyListener((ModifyListener)this);
        this.fFileField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                boolean isUssAllowed;
                boolean bl = isUssAllowed = SourceLookupComposite.this.fTypeCombo.getSelectionIndex() == 1;
                if (!SourceLookupComposite.this.fFileField.getText().isEmpty()) {
                    SourceLookupComposite.this.fListener.validate(SourceLookupComposite.this.fFileField, isUssAllowed);
                }
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fFileField);
        Label typeLabel = new Label((Composite)newParent, 0);
        typeLabel.setText(Labels.TYPE_C);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)typeLabel);
        this.fTypeCombo = new Combo((Composite)newParent, 12);
        SourceLookupComposite.loadType(this.fTypeCombo);
        this.fTypeCombo.select(0);
        this.fAddButton = new Button((Composite)newParent, 8);
        this.fAddButton.setText(Labels.ADD);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().applyTo((Control)this.fAddButton);
        if (!groupMode) {
            Label spacer = new Label((Composite)newParent, 0);
            GridDataFactory.fillDefaults().span(1, numCols).applyTo((Control)spacer);
        }
        this.fLookupTable = new TableViewer((Composite)newParent);
        this.fLookupTable.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fLookupTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fLookupTable.setInput(this.fListItems);
        this.fLookupTable.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new WorkbenchLabelProvider(), (ILabelDecorator)new LabelDecorator(){

            public void removeListener(ILabelProviderListener arg0) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public String decorateText(String arg0, Object arg1) {
                if (arg1 instanceof DebugJCLGenerationUtils.SourceLookupItem) {
                    return arg0 + "  [" + SourceLookupComposite.this.fTypeCombo.getItem(((DebugJCLGenerationUtils.SourceLookupItem)arg1).getComboIndex()) + "]";
                }
                return arg0;
            }

            public Image decorateImage(Image arg0, Object arg1) {
                return null;
            }

            public boolean prepareDecoration(Object arg0, String arg1, IDecorationContext arg2) {
                return false;
            }

            public String decorateText(String arg0, Object arg1, IDecorationContext arg2) {
                return this.decorateText(arg0, arg1);
            }

            public Image decorateImage(Image arg0, Object arg1, IDecorationContext arg2) {
                return null;
            }
        }, (IDecorationContext)new DecorationContext()));
        this.fLookupTable.getTable().setItemCount(5);
        int height = this.fLookupTable.getTable().computeSize((int)-1, (int)-1).y;
        this.fLookupTable.getTable().setItemCount(0);
        GridDataFactory.fillDefaults().span(3, 5).hint(-1, height).applyTo((Control)this.fLookupTable.getTable());
        this.fBrowseButton = new Button((Composite)newParent, 8);
        this.fBrowseButton.setText(Labels.BROWSE);
        this.fBrowseButton.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().applyTo((Control)this.fBrowseButton);
        this.fRemoveButton = new Button((Composite)newParent, 8);
        this.fRemoveButton.setText(Labels.REMOVE);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().applyTo((Control)this.fRemoveButton);
        new Label((Composite)newParent, 0);
        this.fUpButton = new Button((Composite)newParent, 8);
        this.fUpButton.setText(Labels.MOVE_UP);
        this.fUpButton.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().applyTo((Control)this.fUpButton);
        this.fDownButton = new Button((Composite)newParent, 8);
        this.fDownButton.setText(Labels.MOVE_DOWN);
        this.fDownButton.addSelectionListener((SelectionListener)this);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).applyTo((Control)this.fDownButton);
        this.updateFields();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.fAddButton) {
            this.doAdd();
        } else if (event.widget == this.fRemoveButton) {
            this.doRemove();
        } else if (event.widget == this.fUpButton) {
            this.doMove(true);
        } else if (event.widget == this.fDownButton) {
            this.doMove(false);
        } else if (event.widget == this.fBrowseButton) {
            this.doBrowse();
        } else if (this.fProvider != null) {
            String providerName = this.fProvider.getConnection() != null ? this.fProvider.getConnection().getName() : null;
            this.fConnection = DebugOptionsComposite.getHost(providerName);
            this.updateFields();
        }
    }

    private void doBrowse() {
        Object item;
        this.fSelectedType = 0;
        RSESelectRemoteFolderDialog d = new RSESelectRemoteFolderDialog(this.getShell(), true, false, true, false, false){

            protected Control createInner(Composite parent) {
                ScrolledComposite scrolled = new ScrolledComposite(parent, 768);
                scrolled.setShowFocusedControl(true);
                scrolled.setExpandHorizontal(true);
                scrolled.setExpandVertical(true);
                GridDataFactory.swtDefaults().grab(true, true).applyTo((Control)scrolled);
                Composite comp1 = new Composite((Composite)scrolled, 0);
                GridLayoutFactory.fillDefaults().applyTo(comp1);
                super.createInner(comp1);
                Composite comp = new Composite(comp1, 0);
                GridLayoutFactory.swtDefaults().numColumns(2).applyTo(comp);
                Label typeLabel = new Label(comp, 0);
                typeLabel.setText(Labels.TYPE_C);
                final Combo typeCombo = new Combo(comp, 12);
                SourceLookupComposite.loadType(typeCombo);
                typeCombo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        (this).SourceLookupComposite.this.fSelectedType = typeCombo.getSelectionIndex();
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                        (this).SourceLookupComposite.this.fSelectedType = typeCombo.getSelectionIndex();
                    }
                });
                scrolled.setContent((Control)comp1);
                scrolled.setMinSize(comp1.computeSize(-1, -1));
                return scrolled;
            }
        };
        if (this.fConnection != null) {
            d.addViewerFilter((ViewerFilter)new HostFilter(this.fConnection));
        }
        d.setAllowFolderSelection(true);
        d.setMultipleSelectionMode(false);
        if (d.open() == 0 && (item = d.getOutputObject()) instanceof MVSFileResource) {
            String pds = DebugLaunchUIUtils.convertToDatasetName(((MVSFileResource)item).getAbsolutePath());
            DebugJCLGenerationUtils.SourceLookupItem sItem = new DebugJCLGenerationUtils.SourceLookupItem(pds, Integer.toString(this.fSelectedType), true);
            this.addItem(sItem, true);
        }
    }

    protected static void loadType(Combo typeCombo) {
        typeCombo.add(Labels.LISTING);
        typeCombo.add(Labels.COBOL_SOURCE);
        typeCombo.add(Labels.OTHER_SOURCE);
        typeCombo.add("SYSADATA");
        typeCombo.add("EQALANGX");
        typeCombo.add(Labels.SIDE_FILE);
        typeCombo.add(Labels.CPP_SIDEFILE);
        typeCombo.add(Labels.MOD_MAP);
        typeCombo.select(0);
    }

    private void doMove(boolean up) {
        IStructuredSelection sel = (IStructuredSelection)this.fLookupTable.getSelection();
        Object[] sArray = sel.toArray();
        int start = up ? 0 : sel.size() - 1;
        int increment = up ? 1 : -1;
        int i = start;
        while (i > -1 && i < sel.size()) {
            DebugJCLGenerationUtils.SourceLookupItem item = (DebugJCLGenerationUtils.SourceLookupItem)sArray[i];
            int idx = this.fListItems.indexOf(item);
            int newIdx = up ? idx - 1 : idx + 1;
            this.fListItems.remove(idx);
            this.fListItems.add(newIdx, item);
            i += increment;
        }
        this.fLookupTable.refresh();
        if (this.fListener != null) {
            this.fListener.sourceLookupListChanged();
        }
        this.updateFields();
    }

    private void doRemove() {
        IStructuredSelection sel = (IStructuredSelection)this.fLookupTable.getSelection();
        this.fListItems.removeAll(sel.toList());
        for (Object item : sel.toList()) {
            DebugJCLGenerationUtils.updateItemSet(this.fListItemMap, (DebugJCLGenerationUtils.SourceLookupItem)item, false);
        }
        this.fLookupTable.refresh();
        if (this.fListener != null) {
            this.fListener.sourceLookupListChanged();
        }
        this.updateFields();
    }

    private void doAdd() {
        boolean isUssAllowed;
        boolean bl = isUssAllowed = this.fTypeCombo.getSelectionIndex() == 1;
        if (this.fListener != null && this.fListener.validate(this.fFileField, isUssAllowed)) {
            String pds = this.fFileField.getText().trim();
            int type = this.fTypeCombo.getSelectionIndex();
            this.fFileField.setText(EMPTY);
            DebugJCLGenerationUtils.SourceLookupItem sItem = new DebugJCLGenerationUtils.SourceLookupItem(pds, Integer.toString(type), true);
            this.addItem(sItem, true);
        }
    }

    private void addItem(DebugJCLGenerationUtils.SourceLookupItem sItem, boolean refresh) {
        DebugJCLGenerationUtils.updateItemSet(this.fListItemMap, sItem, true);
        this.fListItems.add(sItem);
        if (refresh) {
            this.fLookupTable.refresh();
            if (this.fListener != null) {
                this.fListener.sourceLookupListChanged();
            }
        }
    }

    private void updateFields() {
        IStructuredSelection sel = (IStructuredSelection)this.fLookupTable.getSelection();
        this.fUpButton.setEnabled(!sel.isEmpty() && this.fListItems.indexOf(sel.getFirstElement()) > 0);
        this.fDownButton.setEnabled(!this.fLookupTable.getSelection().isEmpty() && this.fListItems.indexOf(sel.toList().get(sel.size() - 1)) < this.fListItems.size() - 1);
        this.fRemoveButton.setEnabled(!this.fLookupTable.getSelection().isEmpty());
        this.fAddButton.setEnabled(!this.fFileField.getText().trim().isEmpty());
        this.fBrowseButton.setEnabled(this.fConnection != null || this.fIsAlwaysAllowBrowse);
    }

    public void modifyText(ModifyEvent event) {
        this.updateFields();
    }

    public void setConnection(String host) {
        this.fConnection = DebugOptionsComposite.getHost(host);
        this.updateFields();
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
        if (this.fProvider != null) {
            this.fConnection = DebugOptionsComposite.getHost(this.fProvider.getConnection().getName());
        }
        this.updateFields();
    }

    public String getDDString(boolean isDTCompat) {
        return DebugJCLGenerationUtils.getJCLString(true, isDTCompat, this.fListItemMap);
    }

    public String getCEEOPTSString(boolean isDTCompat) {
        return DebugJCLGenerationUtils.getJCLString(false, isDTCompat, this.fListItemMap);
    }

    public String getListString() {
        StringBuilder sb = new StringBuilder();
        for (DebugJCLGenerationUtils.SourceLookupItem item : this.fListItems) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(item.fPDS);
            sb.append(':');
            sb.append(item.getType());
        }
        return sb.toString();
    }

    public void setInitialValues(String listString) {
        String[] pairs;
        this.fListItemMap.clear();
        this.fListItems.clear();
        String[] stringArray = pairs = listString.split(",");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] pieces = pair.split(":");
            if (pieces.length == 2) {
                DebugJCLGenerationUtils.SourceLookupItem sItem = new DebugJCLGenerationUtils.SourceLookupItem(pieces[0], pieces[1]);
                this.addItem(sItem, false);
            }
            ++n2;
        }
        this.fLookupTable.refresh();
    }

    public void setConnectionProvider(IConnectionProvider provider) {
        this.fProvider = provider;
        if (this.fProvider != null) {
            this.fProvider.addConnectionsSettingCompositeListener(this);
            if (this.fProvider.getConnection() != null) {
                this.fConnection = DebugOptionsComposite.getHost(this.fProvider.getConnection().getName());
                this.updateFields();
            }
        }
    }

    public void setAlwaysAllowBrowse(boolean value) {
        this.fIsAlwaysAllowBrowse = value;
        this.updateFields();
    }
}

