/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.composites;

import com.ibm.etools.zos.system.ZOSSystemType;
import com.ibm.ftt.common.logging.LogUtil;
import com.ibm.ftt.debug.ui.Messages;
import com.ibm.ftt.debug.ui.composites.IConnectionProvider;
import com.ibm.ftt.debug.ui.composites.IConnectionSettingsCompositeListener;
import com.ibm.ftt.debug.ui.composites.IExtendedConnectionProvider;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class RseConnectionsComposite
implements SelectionListener,
IConnectionProvider {
    private int fConnectionIndex = -1;
    private Label fConnectionLabel;
    private Combo fConnectionCombo;
    private Button fConnectButton;
    private Button fNewConnectionButton;
    private List<IZOSSystemImage> fSystemList = new ArrayList<IZOSSystemImage>();
    private String fErrorText;
    private Combo fErrorControl;
    private Set<IConnectionSettingsCompositeListener> fListeners = new HashSet<IConnectionSettingsCompositeListener>();
    private IExtendedConnectionProvider fExtendedProvider;

    public RseConnectionsComposite(IConnectionSettingsCompositeListener listener, Composite parent, int style) {
        this(listener, parent, style, true, true);
    }

    public RseConnectionsComposite(IConnectionSettingsCompositeListener listener, Composite parent, int style, boolean showNew) {
        this(listener, parent, style, showNew, true);
    }

    public RseConnectionsComposite(IConnectionSettingsCompositeListener listener, Composite parent, int style, boolean showNew, boolean showConnect) {
        this.fListeners.add(listener);
        this.fConnectionLabel = new Label(parent, 0);
        this.fConnectionLabel.setText(Messages.MainTab_Connection);
        this.fConnectionCombo = new Combo(parent, 12);
        this.fConnectionCombo.addSelectionListener((SelectionListener)this);
        this.initConnectionCombo();
        int columns = ((GridLayout)parent.getLayout()).numColumns - 1 - (showNew ? 1 : 0) - (showConnect ? 1 : 0);
        GridDataFactory.fillDefaults().grab(true, false).span(columns, 1).applyTo((Control)this.fConnectionCombo);
        if (showConnect) {
            this.fConnectButton = new Button(parent, 8);
            this.fConnectButton.setText(Messages.MainTab_Connection_Connect);
            this.fConnectButton.addSelectionListener((SelectionListener)this);
            GridDataFactory.fillDefaults().applyTo((Control)this.fConnectButton);
        }
        if (showNew) {
            this.fNewConnectionButton = new Button(parent, 8);
            this.fNewConnectionButton.addSelectionListener((SelectionListener)this);
            this.fNewConnectionButton.setText(Messages.ConnectionSettingsComposite_0);
            GridDataFactory.fillDefaults().applyTo((Control)this.fNewConnectionButton);
        }
        this.refresh();
    }

    private void initConnectionCombo() {
        int idx;
        Object[] systems = PhysicalSystemRegistryFactory.getSingleton().getSystems(2);
        String initialSystemName = null;
        if (this.fConnectionCombo.getText() != null) {
            initialSystemName = this.fConnectionCombo.getText();
        }
        Object[] objectArray = systems;
        int n = systems.length;
        int n2 = 0;
        while (n2 < n) {
            Object system = objectArray[n2];
            if (system instanceof IZOSSystemImage) {
                this.fSystemList.add((IZOSSystemImage)system);
                this.fConnectionCombo.add(((IZOSSystemImage)system).getName());
            }
            ++n2;
        }
        if (initialSystemName != null && (idx = this.fConnectionCombo.indexOf(initialSystemName)) > -1) {
            this.fConnectionCombo.select(idx);
            this.fConnectionIndex = idx;
            return;
        }
        if (this.fConnectionCombo.getItemCount() > 0) {
            this.fConnectionCombo.select(0);
            this.fConnectionIndex = 0;
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.widgetSelected(arg0);
    }

    public void widgetSelected(SelectionEvent event) {
        this.fConnectionIndex = this.fConnectionCombo != null ? this.fConnectionCombo.getSelectionIndex() : -1;
        for (IConnectionSettingsCompositeListener l : this.fListeners) {
            l.widgetSelected(event);
        }
        this.validateConnection();
        if (event.widget == this.fConnectButton || event.widget == this.fConnectionCombo) {
            this.handleConnect(event);
        } else if (event.widget == this.fNewConnectionButton) {
            this.handleNewConnection(event);
        }
        this.refresh();
    }

    private void handleNewConnection(final SelectionEvent e) {
        final ArrayList<IHost> connections = new ArrayList<IHost>(Arrays.asList(SystemStartHere.getConnectionsBySystemType((String)"com.ibm.etools.zos.system")));
        SystemNewConnectionAction action = new SystemNewConnectionAction(this.fConnectionCombo.getShell(), true, null);
        action.restrictSystemTypes(new IRSESystemType[]{new ZOSSystemType()});
        action.run();
        this.fConnectionCombo.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArrayList<IHost> newconnections = new ArrayList<IHost>(Arrays.asList(SystemStartHere.getConnectionsBySystemType((String)"com.ibm.etools.zos.system")));
                RseConnectionsComposite.this.fConnectionCombo.removeAll();
                RseConnectionsComposite.this.fSystemList.clear();
                RseConnectionsComposite.this.initConnectionCombo();
                newconnections.removeAll(connections);
                if (newconnections.size() > 0) {
                    RseConnectionsComposite.this.setConnection(((IHost)newconnections.get(0)).getName(), true);
                } else if (RseConnectionsComposite.this.fConnectionCombo.getItemCount() > 0) {
                    RseConnectionsComposite.this.fConnectionCombo.select(0);
                }
                RseConnectionsComposite.this.refresh();
                RseConnectionsComposite.this.validateConnection();
                for (IConnectionSettingsCompositeListener l : RseConnectionsComposite.this.fListeners) {
                    l.widgetSelected(e);
                }
            }
        });
    }

    private void handleConnect(SelectionEvent event) {
        if (this.fExtendedProvider != null) {
            this.fExtendedProvider.notifyConnectionAttempt();
        }
        IZOSSystemImage connection = this.getConnection();
        boolean ok = true;
        Exception error = null;
        if (connection != null && !connection.isConnected()) {
            try {
                connection.connect();
            }
            catch (Exception e) {
                ok = false;
                error = e;
                LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.debug.pdt.idz.launches.common", (Throwable)e);
            }
        }
        if (this.fExtendedProvider != null) {
            if (ok) {
                this.fExtendedProvider.handleConnect(event);
            } else {
                this.fExtendedProvider.notifyConnectionError(error);
            }
        }
        this.refresh();
        for (IConnectionSettingsCompositeListener l : this.fListeners) {
            l.widgetDefaultSelected(event);
        }
    }

    public void setConnection(String name, boolean matchName) {
        if (this.fConnectionCombo != null) {
            if (name == null) {
                this.fConnectionCombo.select(0);
            } else {
                String ipAddress;
                String string = ipAddress = !matchName ? RseConnectionsComposite.getIpAddress(name) : null;
                if (matchName || ipAddress != null) {
                    int i = 0;
                    while (i < this.fSystemList.size()) {
                        IZOSSystemImage system = this.fSystemList.get(i);
                        if (matchName && system.getName().equals(name) || !matchName && system.getIpAddress().equals(ipAddress)) {
                            this.fConnectionCombo.select(i);
                            this.fConnectionIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    static String getIpAddress(String name) {
        try {
            return RseConnectionsComposite.convertIpAddress(InetAddress.getByName(name));
        }
        catch (UnknownHostException e) {
            LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.debug.pdt.idz.launches.common", (Throwable)e);
            return null;
        }
    }

    static String convertIpAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        byte[] addr = inetAddress.getAddress();
        StringBuilder ipAddr = new StringBuilder();
        int i = 0;
        while (i < addr.length) {
            if (i > 0) {
                ipAddr.append('.');
            }
            ipAddr.append(addr[i] & 0xFF);
            ++i;
        }
        String hostname = inetAddress.getHostName();
        return ipAddr.length() == 0 ? hostname : ipAddr.toString();
    }

    @Override
    public IZOSSystemImage getConnection() {
        return this.fConnectionIndex > -1 ? this.fSystemList.get(this.fConnectionIndex) : null;
    }

    public void refresh() {
        if (this.fConnectionCombo != null) {
            this.fConnectionIndex = this.fConnectionCombo.getText().trim().isEmpty() ? -1 : this.fConnectionCombo.getSelectionIndex();
            IZOSSystemImage connection = this.getConnection();
            if (this.fConnectButton != null) {
                this.fConnectButton.setEnabled(this.fConnectionIndex > -1 && (connection != null && !connection.isConnected() || this.fExtendedProvider != null && this.fExtendedProvider.isConnectEnabled()));
            }
        }
    }

    public boolean validateConnection() {
        boolean result;
        this.fErrorText = null;
        this.fErrorControl = null;
        boolean bl = this.fConnectionCombo == null ? true : (result = !this.fConnectionCombo.getText().trim().isEmpty());
        if (!result) {
            this.fErrorText = Messages.ConnectionSettingsComposite_11;
            this.fErrorControl = this.fConnectionCombo;
        }
        if (this.fExtendedProvider != null && result) {
            this.fErrorText = this.fExtendedProvider.validateConnection();
            result = this.fErrorText == null;
        }
        return result;
    }

    public boolean isValidationControl(Widget control) {
        return control == this.fConnectionCombo || control == this.fConnectButton;
    }

    public Control getErrorControl() {
        return this.fErrorControl;
    }

    public void clearErrors() {
        this.fErrorText = null;
        this.fErrorControl = null;
    }

    public String getErrorText() {
        return this.fErrorText;
    }

    @Override
    public void addConnectionsSettingCompositeListener(IConnectionSettingsCompositeListener listener) {
        this.fListeners.add(listener);
    }

    public void setExtendedConnectionProvider(IExtendedConnectionProvider provider) {
        this.fExtendedProvider = provider;
    }

    public Combo getConnectionCombo() {
        return this.fConnectionCombo;
    }

    public void setEnabled(boolean enabled) {
        if (this.fConnectionLabel != null) {
            this.fConnectionLabel.setEnabled(enabled);
        }
        if (this.fConnectionCombo != null) {
            this.fConnectionCombo.setEnabled(enabled);
        }
        if (this.fConnectButton != null) {
            this.fConnectButton.setEnabled(enabled);
        }
        this.refresh();
    }
}

