/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.composites;

import com.ibm.debug.pdt.internal.ui.AbstractDebugComposite;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.ftt.debug.ui.DebugMessages;
import com.ibm.ftt.debug.ui.Labels;
import com.ibm.ftt.debug.ui.composites.IConnectionProvider;
import com.ibm.ftt.debug.ui.composites.IConnectionSettingsCompositeListener;
import com.ibm.ftt.debug.ui.composites.IJCLCompositeListener;
import com.ibm.ftt.debug.ui.composites.IJCLLaunchConstants;
import com.ibm.ftt.debug.ui.composites.RseConnectionsComposite;
import com.ibm.ftt.debug.ui.tabs.HostFilter;
import com.ibm.ftt.debug.ui.util.DebugLaunchUIUtils;
import com.ibm.ftt.debug.ui.util.JCLUtils;
import com.ibm.ftt.debug.ui.util.RemoteUtil;
import com.ibm.ftt.properties.IPropertyGroup;
import com.ibm.ftt.properties.IPropertyGroupContainer;
import com.ibm.ftt.properties.zos.ZOSPropertyGroupContainer;
import com.ibm.ftt.properties.zos.ZOSPropertyGroupManager;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSCatalog;
import com.ibm.ftt.resources.zos.zosphysical.IZOSPartitionedDataSet;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSSequentialDataSet;
import com.ibm.ftt.ui.rse.utils.RSESelectRemoteFolderDialog;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JCLComposite
extends AbstractDebugComposite
implements IConnectionSettingsCompositeListener,
IJCLLaunchConstants,
IConnectionProvider,
ICheckStateListener {
    private static final String EMPTY = "";
    private static final String jclExtensionNoDot = "jcl";
    private RseConnectionsComposite fConnection;
    private Combo fCombo;
    private Button fGenPartialProgramLabel;
    private Text fGenPartialProgramText;
    private Button fGenPartialProgramBrowseButton;
    private Label fUseExistingLabel;
    private Text fUseExistingText;
    private Button fUseExistingBrowseButton;
    private Button fLocalBrowseButton;
    private Button fGenPartialSourceLabel;
    private Text fGenPartialSourceText;
    private Button fGenPartialSourceBrowseButton;
    private String fStepError;
    private IJCLCompositeListener fListener;
    private String fErrorMessage;
    private IZOSSystemImage fConnectionOverride;
    private boolean fIsExistingJCL = false;
    private Label fPLabel;
    private Group fModeGroup;
    private Label fProjLabel;
    private Text fProjText;
    private Label fSubProjLabel;
    private Text fSubProjText;
    private Composite fProjectComposite;
    private Group fStepGroup;
    private CheckboxTableViewer fStepTableViewer;
    private FocusListener fFocusListener = new FocusListener(){

        public void focusLost(FocusEvent arg0) {
            JCLComposite.this.loadStepTable(true, JCLComposite.this.getFile(JCLComposite.this.fUseExistingText.getText().trim()));
            JCLComposite.this.fUseExistingText.removeFocusListener((FocusListener)this);
            JCLComposite.this.fFocusListenerAdded = false;
            JCLComposite.this.doValidation();
            if (JCLComposite.this.fListener != null) {
                JCLComposite.this.fListener.handleStepError(JCLComposite.this.fStepError != null ? JCLComposite.this.fStepError : JCLComposite.this.getErrorMessage());
            }
        }

        public void focusGained(FocusEvent arg0) {
        }
    };
    private boolean fFocusListenerAdded;
    private Button fSubPgmCheckBox;
    private Combo fProfileCombo;
    private Collection<DebugProfile> fProfiles = new ArrayList<DebugProfile>();
    private Label fProfileLabel;
    private String fMode;

    public JCLComposite(IJCLCompositeListener listener, Composite parent, int style, boolean isConnectionNeeded, boolean isExistingJCL, String mode) {
        super(parent, style);
        int numCols = 4;
        GridLayoutFactory.swtDefaults().numColumns(numCols).applyTo((Composite)this);
        this.fListener = listener;
        this.fIsExistingJCL = isExistingJCL;
        this.fMode = mode;
        if (isConnectionNeeded) {
            this.fConnection = new RseConnectionsComposite(this, (Composite)this, 0, true, false);
        }
        if (!this.fIsExistingJCL) {
            this.fProjLabel = new Label((Composite)this, 0);
            this.fProjLabel.setText(Labels.PROJECT);
            this.fProjectComposite = new Composite((Composite)this, 0);
            GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.fProjectComposite);
            GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.fProjectComposite);
            this.fProjText = new Text(this.fProjectComposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fProjText);
            this.fSubProjLabel = new Label(this.fProjectComposite, 0);
            this.fSubProjLabel.setText(Labels.SUBPROJECT);
            this.fSubProjText = new Text(this.fProjectComposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fSubProjText);
            this.fPLabel = new Label((Composite)this, 0);
            this.fPLabel.setText(Labels.PROPERTY_GROUP);
            this.fCombo = new Combo((Composite)this, 8);
            this.loadPropertyGroups();
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.fCombo);
            new Label((Composite)this, 0);
            this.fModeGroup = new Group((Composite)this, 0);
            this.fModeGroup.setText(Labels.JCL_MODE);
            GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)this.fModeGroup);
            GridDataFactory.fillDefaults().grab(true, false).span(4, 1).applyTo((Control)this.fModeGroup);
            Composite subMode = new Composite((Composite)this.fModeGroup, 0);
            GridLayoutFactory.swtDefaults().numColumns(3).margins(0, 0).applyTo(subMode);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)subMode);
            this.fGenPartialProgramLabel = new Button(subMode, 16);
            this.fGenPartialProgramLabel.setText(Labels.LOAD_MODULE_NO_DLL);
            if (this.isUsePropertyGroup()) {
                this.fGenPartialProgramLabel.setSelection(true);
            }
            this.fGenPartialProgramLabel.addSelectionListener((SelectionListener)this);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.fGenPartialProgramLabel);
            this.fGenPartialProgramText = new Text(subMode, 2048);
            this.fGenPartialProgramText.addModifyListener((ModifyListener)this);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fGenPartialProgramText);
            this.fGenPartialProgramBrowseButton = new Button(subMode, 8);
            this.fGenPartialProgramBrowseButton.addSelectionListener((SelectionListener)this);
            this.fGenPartialProgramBrowseButton.setText(Labels.BROWSE);
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.fGenPartialProgramBrowseButton);
            this.fGenPartialSourceLabel = new Button(subMode, 16);
            this.fGenPartialSourceLabel.setText(Labels.SOURCE);
            this.fGenPartialSourceLabel.addSelectionListener((SelectionListener)this);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.fGenPartialSourceLabel);
            this.fGenPartialSourceText = new Text(subMode, 2048);
            this.fGenPartialSourceText.addModifyListener((ModifyListener)this);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fGenPartialSourceText);
            this.fGenPartialSourceBrowseButton = new Button(subMode, 8);
            this.fGenPartialSourceBrowseButton.addSelectionListener((SelectionListener)this);
            this.fGenPartialSourceBrowseButton.setText(Labels.BROWSE);
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.fGenPartialSourceBrowseButton);
        } else {
            this.fUseExistingLabel = new Label((Composite)this, 0);
            this.fUseExistingLabel.setText(Labels.BASE_JCL);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.fUseExistingLabel);
            this.fUseExistingText = new Text((Composite)this, 2048);
            this.fUseExistingText.addModifyListener((ModifyListener)this);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.fUseExistingText);
            Composite buttonComposite = new Composite((Composite)this, 0);
            GridLayoutFactory.swtDefaults().numColumns(6).margins(0, 0).applyTo(buttonComposite);
            GridDataFactory.fillDefaults().grab(true, false).span(6, 1).applyTo((Control)buttonComposite);
            new Label((Composite)this, 0);
            this.fLocalBrowseButton = new Button((Composite)this, 8);
            this.fLocalBrowseButton.addSelectionListener((SelectionListener)this);
            this.fLocalBrowseButton.setText(Labels.WORKSPACE_BROWSE);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(2, 1).applyTo((Control)this.fLocalBrowseButton);
            this.fUseExistingBrowseButton = new Button((Composite)this, 8);
            this.fUseExistingBrowseButton.addSelectionListener((SelectionListener)this);
            this.fUseExistingBrowseButton.setText(Labels.REMOTE_BROWSE);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(1, 1).applyTo((Control)this.fUseExistingBrowseButton);
            this.fStepGroup = new Group((Composite)this, 0);
            this.fStepGroup.setText(Labels.STEP_GROUP);
            GridLayoutFactory.swtDefaults().applyTo((Composite)this.fStepGroup);
            GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).span(3, 1).applyTo((Control)this.fStepGroup);
            this.fStepTableViewer = JCLUtils.createStepTable((Composite)this.fStepGroup);
            this.fStepTableViewer.addCheckStateListener((ICheckStateListener)this);
            this.fSubPgmCheckBox = new Button((Composite)this, 32);
            this.fSubPgmCheckBox.setText(Labels.SUBPGM);
            this.fSubPgmCheckBox.setToolTipText(Labels.SUBPGM_TOOLTIP);
            this.fSubPgmCheckBox.addSelectionListener((SelectionListener)this);
            GridDataFactory.fillDefaults().grab(true, false).span(numCols, 1).applyTo((Control)this.fSubPgmCheckBox);
            this.fProfileLabel = new Label((Composite)this, 0);
            this.fProfileLabel.setText(Labels.DBG_PROFILE);
            GridDataFactory.fillDefaults().indent(25, 0).align(1, 0x1000000).applyTo((Control)this.fProfileLabel);
            this.fProfileCombo = new Combo((Composite)this, 12);
            this.fProfileCombo.addSelectionListener((SelectionListener)this);
            this.fProfileCombo.addModifyListener((ModifyListener)this);
            GridDataFactory.fillDefaults().grab(true, false).span(numCols - 1, 1).applyTo((Control)this.fProfileCombo);
            this.loadProfileCombo();
        }
        if (this.fCombo != null) {
            this.fCombo.addSelectionListener((SelectionListener)this);
        }
        this.layout(true);
        this.doValidation();
        this.enableFields();
    }

    private void loadProfileCombo() {
        if (this.fProfileCombo != null) {
            int index;
            String selection = this.fProfileCombo.getText();
            this.fProfileCombo.removeAll();
            this.fProfiles = this.fConnection.getConnection() != null ? DebugProfileRoot.getInstance().getDebugProfiles(this.fConnection.getConnection().getName(), false, true) : new ArrayList<DebugProfile>();
            for (DebugProfile p : this.fProfiles) {
                this.fProfileCombo.add(p.getName());
            }
            if (selection != null && !selection.isEmpty() && (index = this.fProfileCombo.indexOf(selection)) > -1) {
                this.fProfileCombo.select(this.fProfileCombo.indexOf(selection));
                this.fProfileCombo.setText(selection);
            }
            this.enableFields();
        }
    }

    private void loadPropertyGroups() {
        if (this.fCombo == null) {
            return;
        }
        int oldSelection = this.fCombo.getSelectionIndex();
        this.fCombo.removeAll();
        if (this.getConnection() != null) {
            ZOSPropertyGroupManager mgr = ZOSPropertyGroupManager.getZOSPropertyGroupManager();
            for (IPropertyGroupContainer container : mgr.getPropertyGroupContainers()) {
                ZOSPropertyGroupContainer zContainer;
                if (!(container instanceof ZOSPropertyGroupContainer) || !(zContainer = (ZOSPropertyGroupContainer)container).getSystem().equals(this.getConnectionName())) continue;
                for (IPropertyGroup group : zContainer.getPropertyGroups()) {
                    this.fCombo.add(group.getName());
                }
                this.fCombo.select(oldSelection == 0 ? 0 : 1);
                break;
            }
        }
        if (this.fCombo.getSelectionIndex() < 1) {
            this.fCombo.select(0);
        }
    }

    private void enableFields() {
        boolean hideProjects = this.fProjText == null || this.fProjText.getText().trim().isEmpty();
        boolean connectionSpecified = this.fConnection.getConnection() != null && hideProjects;
        this.fConnection.setEnabled(hideProjects);
        if (this.fGenPartialProgramBrowseButton != null) {
            if (this.fCombo != null) {
                this.fCombo.setEnabled(connectionSpecified && hideProjects);
            }
            this.fPLabel.setEnabled(connectionSpecified && hideProjects);
            this.fGenPartialProgramLabel.setEnabled(!this.fIsExistingJCL && hideProjects);
            this.fGenPartialProgramText.setEnabled(!this.fIsExistingJCL && hideProjects && this.fGenPartialProgramLabel.getSelection());
            this.fGenPartialProgramBrowseButton.setEnabled(!this.fIsExistingJCL && hideProjects && connectionSpecified && this.fGenPartialProgramLabel.getSelection());
            this.fGenPartialSourceLabel.setEnabled(!this.fIsExistingJCL && hideProjects && connectionSpecified);
            this.fGenPartialSourceText.setEnabled(!this.fIsExistingJCL && hideProjects && connectionSpecified && this.fGenPartialSourceLabel.getSelection());
            this.fGenPartialSourceBrowseButton.setEnabled(!this.fIsExistingJCL && hideProjects && connectionSpecified && this.fGenPartialSourceLabel.getSelection());
        }
        boolean isNotRunMode = !"run".equals(this.fMode);
        IFile localFile = null;
        if (this.isUseLocalBrowse()) {
            localFile = this.getFile(this.fUseExistingText.getText());
        }
        if (this.fUseExistingLabel != null) {
            this.fUseExistingLabel.setEnabled(connectionSpecified);
            this.fUseExistingText.setEnabled(connectionSpecified);
            this.fUseExistingBrowseButton.setEnabled(connectionSpecified);
            this.fStepGroup.setEnabled(connectionSpecified && isNotRunMode);
            this.fStepTableViewer.getTable().setEnabled(connectionSpecified && isNotRunMode);
            if (this.fStepGroup.isEnabled()) {
                this.loadStepTable(false, localFile);
            }
        }
        if (this.fProjText != null) {
            this.fProjLabel.setEnabled(hideProjects);
            this.fProjText.setEnabled(hideProjects);
            this.fSubProjLabel.setEnabled(hideProjects);
            this.fSubProjText.setEnabled(hideProjects);
            GridDataFactory.fillDefaults().hint(-1, hideProjects ? 0 : -1).applyTo((Control)this.fProjLabel);
            GridDataFactory.fillDefaults().span(3, 1).hint(-1, hideProjects ? 0 : -1).applyTo((Control)this.fProjectComposite);
        }
        if (this.fProfileLabel != null) {
            this.fProfileLabel.setEnabled(this.fProfiles.size() > 0 && this.fSubPgmCheckBox.getSelection() && isNotRunMode);
            this.fProfileCombo.setEnabled(this.fProfiles.size() > 0 && this.fSubPgmCheckBox.getSelection() && isNotRunMode);
            this.fSubPgmCheckBox.setEnabled(this.fProfiles.size() > 0 && isNotRunMode);
        }
        this.layout(true);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        this.fStepError = null;
        if (event.widget == this.fUseExistingBrowseButton) {
            this.doRemoteBrowse(jclExtensionNoDot, event.widget);
        } else if (event.widget == this.fLocalBrowseButton) {
            this.doLocalBrowse(jclExtensionNoDot, event.widget);
        } else if (event.widget == this.fGenPartialProgramBrowseButton) {
            this.doRemoteBrowse("exe", event.widget);
        } else if (event.widget == this.fGenPartialSourceBrowseButton) {
            this.doRemoteBrowse(null, event.widget);
        } else if (event.widget != this.fCombo && event.widget == this.fConnection.getConnectionCombo()) {
            this.loadPropertyGroups();
            this.loadProfileCombo();
        }
        this.enableFields();
        this.doValidation();
        if (this.fListener != null) {
            this.fListener.widgetSelected(event);
        }
    }

    private void doValidation() {
        this.fConnection.validateConnection();
        this.doValidation(false);
    }

    private void doValidation(boolean validateDatasetExistance) {
        this.setErrorMessage(null);
        if (this.fConnection.getErrorText() != null) {
            this.setErrorMessage(this.fConnection.getErrorText());
            return;
        }
        if (!this.fConnection.getConnection().isConnected()) {
            this.setErrorMessage(NLS.bind((String)DebugMessages.CRRDG8019, (Object)this.getConnectionName()));
            return;
        }
        if (this.fCombo != null && this.fCombo.getText().isEmpty()) {
            this.setErrorMessage(DebugMessages.CRRDG8027);
            return;
        }
        String hostName = this.getConnectionName();
        if (!this.fIsExistingJCL) {
            if (this.fGenPartialProgramLabel.getSelection()) {
                String programName = this.fGenPartialProgramText.getText().trim();
                if (programName.isEmpty()) {
                    this.setErrorMessage(DebugMessages.CRRDG8025);
                    return;
                }
                String message = DebugLaunchUIUtils.validateDatasetOrMemberName(hostName, programName);
                if (validateDatasetExistance && message == null) {
                    message = JCLComposite.isDatasetOrMemberNameExist(hostName, programName);
                }
                if (message != null) {
                    this.setErrorMessage(message);
                    return;
                }
            } else {
                String sourceName = this.fGenPartialSourceText.getText().trim();
                if (sourceName.isEmpty()) {
                    this.setErrorMessage(DebugMessages.CRRDG8024);
                    return;
                }
                String message = DebugLaunchUIUtils.validateDatasetOrMemberName(hostName, sourceName);
                if (validateDatasetExistance && message == null) {
                    message = JCLComposite.isDatasetOrMemberNameExist(hostName, sourceName);
                }
                if (message != null) {
                    this.setErrorMessage(message);
                    return;
                }
            }
        } else {
            String jclName = this.fUseExistingText.getText().trim();
            if (jclName.isEmpty()) {
                this.setErrorMessage(DebugMessages.CRRDG8026);
                return;
            }
            String localFileMessage = DebugLaunchUIUtils.validateLocalFile(jclName);
            if (localFileMessage != null && JCLUtils.isLocalPath(jclName)) {
                this.setErrorMessage(localFileMessage);
                return;
            }
            String remoteFileMessage = DebugLaunchUIUtils.validateDatasetOrMemberName(hostName, jclName);
            if (remoteFileMessage != null && !JCLUtils.isLocalPath(jclName)) {
                this.setErrorMessage(remoteFileMessage);
                return;
            }
            boolean isConnected = this.fConnection.getConnection().isConnected();
            if (!"run".equals(this.fMode)) {
                Object[] checkedSteps = this.fStepTableViewer.getCheckedElements();
                if (this.fStepError != null) {
                    this.setErrorMessage(isConnected ? this.fStepError : DebugMessages.CRRDG8021);
                    return;
                }
                if (checkedSteps.length == 0) {
                    this.setErrorMessage(isConnected ? DebugMessages.CRRDG8023 : DebugMessages.CRRDG8021);
                    return;
                }
                if (this.getConnection() != null && !this.getConnection().isConnected()) {
                    this.setErrorMessage(DebugMessages.CRRDG8021);
                }
            }
        }
        if (this.getErrorMessage() == null && this.fSubPgmCheckBox != null && this.fSubPgmCheckBox.getSelection() && this.fProfileCombo.getText().trim().isEmpty()) {
            this.setErrorMessage(DebugMessages.CRRDG8031);
        }
    }

    private void setErrorMessage(String message) {
        this.fErrorMessage = message;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public static String isDatasetOrMemberNameExist(String hostName, String name) {
        IZOSSystemImage connection;
        IZOSCatalog root;
        if (hostName != null && !name.isEmpty() && (root = (IZOSCatalog)(connection = (IZOSSystemImage)PhysicalSystemRegistryFactory.getSingleton().find(hostName, 2)).getRoot()) != null) {
            IAdaptable dsm;
            int dsIndex = name.indexOf(40);
            IAdaptable iAdaptable = dsm = dsIndex == -1 ? root.findMember(name) : root.findMember(name.substring(0, dsIndex));
            if (dsIndex > -1 && dsm instanceof IZOSPartitionedDataSet) {
                dsm = ((IZOSPartitionedDataSet)dsm).findMember(name.substring(dsIndex + 1, name.length() - 1));
            }
            if (dsm == null || !(dsm instanceof ZOSDataSetMember) && !(dsm instanceof ZOSSequentialDataSet)) {
                return NLS.bind((String)DebugMessages.CRRDG8020, (Object)name);
            }
        }
        return null;
    }

    private void doLocalBrowse(String sourceType, Widget widget) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider()){

            protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                TreeViewer viewer = new TreeViewer(new Tree(parent, style));
                viewer.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IFile) {
                            String fileExtension = ((IFile)element).getFileExtension();
                            return fileExtension != null && JCLComposite.jclExtensionNoDot.equalsIgnoreCase(fileExtension);
                        }
                        return element instanceof IFolder || element instanceof IProject;
                    }
                });
                return viewer;
            }
        };
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length > 0 && selection[0] instanceof IFile) {
                    return new Status(0, this.getClass(), JCLComposite.EMPTY);
                }
                return new Status(4, this.getClass(), DebugMessages.CRRDG8026);
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setTitle(Labels.LOCAL_BROWSE_TITLE);
        dialog.setMessage(Labels.LOCAL_BROWSE_DIALOG);
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            String selectedFile = file.getFullPath().toString();
            selectedFile = JCLUtils.getFileWorkspacePath(selectedFile);
            this.fUseExistingText.setText(selectedFile);
            this.loadStepTable(true, file);
        }
    }

    private void doRemoteBrowse(String sourceType, Widget widget) {
        Object member;
        RSESelectRemoteFolderDialog d = new RSESelectRemoteFolderDialog(this.getShell(), true, false, true, false, false);
        IHost host = RemoteUtil.getHost(this.getConnection());
        if (host != null) {
            d.addViewerFilter((ViewerFilter)new HostFilter(host));
        }
        d.setAllowFolderSelection(false);
        if (sourceType != null) {
            d.setFileTypes(sourceType);
        }
        if (d.open() == 0 && (member = d.getOutputObject()) instanceof MVSFileResource) {
            String dsn = DebugLaunchUIUtils.convertToDatasetName(((MVSFileResource)member).getAbsolutePath());
            if (widget == this.fGenPartialProgramBrowseButton) {
                this.fGenPartialProgramText.setText(dsn);
            } else if (widget == this.fGenPartialSourceBrowseButton) {
                this.fGenPartialSourceText.setText(dsn);
            } else if (widget == this.fUseExistingBrowseButton) {
                this.fUseExistingText.setText(dsn);
                this.loadStepTable(true, null);
            }
        }
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget == this.fUseExistingText && !this.fFocusListenerAdded) {
            this.fFocusListenerAdded = true;
            this.fUseExistingText.addFocusListener(this.fFocusListener);
        }
        this.doValidation();
        if (this.fListener != null) {
            this.fListener.modifyText(event);
        }
    }

    public void initializeFields(String connection, String propertyGroup, boolean isUseProperty, boolean isUseExisting, boolean isUseProgram, String program, String source, String jcl, String step, boolean useLocal) {
        this.initializeFields(connection, propertyGroup, isUseProperty, isUseExisting, isUseProgram, program, source, jcl, step, null, null, false, null, useLocal);
    }

    public void initializeFields(String connection, String propertyGroup, boolean isUseProperty, boolean isUseExisting, boolean isUseProgram, String program, String source, String jcl, String step, String project, String subProject, boolean isUseProfile, String profileName, boolean useLocal) {
        JCLUtils.Step[] s;
        if (this.fConnection != null) {
            this.fConnection.setConnection(connection, true);
            this.loadPropertyGroups();
            if (this.fConnection.getConnection() != null && this.fCombo != null) {
                int idx = this.fCombo.indexOf(propertyGroup);
                if (!isUseProperty) {
                    this.fCombo.select(0);
                } else {
                    this.fCombo.select(idx > 0 ? idx : 0);
                }
            }
            this.fConnection.refresh();
            this.fConnection.validateConnection();
        }
        if (this.fGenPartialProgramLabel != null) {
            this.fGenPartialProgramLabel.setSelection(isUseProgram);
            this.fGenPartialProgramText.setText(program);
            this.fGenPartialSourceLabel.setSelection(!isUseProgram);
            this.fGenPartialSourceText.setText(source);
        }
        if (this.fUseExistingText != null) {
            this.fUseExistingText.setText(jcl);
        }
        if (project != null && this.fProjText != null) {
            this.fProjText.setText(project);
        }
        if (subProject != null && this.fSubProjText != null) {
            this.fSubProjText.setText(subProject);
        }
        this.loadStepTable(true, this.getFile(jcl));
        if (step != null && !step.isEmpty() && (s = JCLUtils.Step.createSteps(step)) != null) {
            this.selectSteps(s);
        }
        if (this.fSubPgmCheckBox != null) {
            this.loadProfileCombo();
            this.fSubPgmCheckBox.setSelection(isUseProfile);
            if (profileName != null) {
                this.fProfileCombo.setText(profileName);
            }
        }
        this.enableFields();
        this.doValidation();
    }

    private IFile getFile(String jclName) {
        try {
            jclName = JCLUtils.removeWorkspaceVariable(jclName);
            Path jclPath = new Path(jclName);
            IFile jclFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)jclPath);
            if (jclFile != null && jclFile.exists()) {
                return jclFile;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void loadStepTable(boolean force, IFile localFile) {
        if (this.fUseExistingText != null && !this.fUseExistingText.getText().isEmpty() && this.fStepTableViewer != null && (this.fStepTableViewer.getInput() == null || force)) {
            this.fStepError = JCLUtils.loadSteps(this.fStepTableViewer, this.getConnection(), this.fUseExistingText.getText(), null, localFile);
            if (this.fListener != null && !"run".equals(this.fMode)) {
                this.fListener.handleStepError(this.fStepError);
            }
            this.doValidation();
        }
    }

    @Override
    public IZOSSystemImage getConnection() {
        return this.fConnection == null ? this.fConnectionOverride : this.fConnection.getConnection();
    }

    public String getConnectionName() {
        if (this.getConnection() == null) {
            return EMPTY;
        }
        IHost host = RemoteUtil.getHost(this.getConnection());
        return host == null ? null : host.getName();
    }

    public String getPropertyGroup() {
        return this.fCombo == null ? EMPTY : (this.fCombo.getSelectionIndex() < 0 ? EMPTY : this.fCombo.getText().trim());
    }

    public boolean isUsePropertyGroup() {
        return this.fCombo != null && this.fCombo.getSelectionIndex() >= 0;
    }

    public boolean isUseExisting() {
        return this.fIsExistingJCL;
    }

    public boolean isUseProgram() {
        return this.fGenPartialProgramLabel == null ? false : this.fGenPartialProgramLabel.getSelection();
    }

    public String getProgram() {
        return this.fGenPartialProgramText == null ? EMPTY : this.fGenPartialProgramText.getText().trim();
    }

    public String getSource() {
        return this.fGenPartialSourceText == null ? EMPTY : this.fGenPartialSourceText.getText().trim();
    }

    public String getJCL() {
        return this.fUseExistingText == null ? EMPTY : this.fUseExistingText.getText().trim();
    }

    public JCLUtils.Step[] getSteps() {
        if (this.fStepTableViewer != null) {
            return JCLUtils.Step.getCheckedSteps(this.fStepTableViewer);
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!this.fIsExistingJCL) {
            this.fPLabel.setEnabled(enabled);
            this.fGenPartialProgramBrowseButton.setEnabled(enabled);
            this.fGenPartialProgramLabel.setEnabled(enabled);
            this.fGenPartialProgramText.setEnabled(enabled);
            this.fGenPartialSourceText.setEnabled(enabled);
            this.fGenPartialSourceLabel.setEnabled(enabled);
            this.fGenPartialSourceBrowseButton.setEnabled(enabled);
        }
        boolean isNotRunMode = !"run".equals(this.fMode);
        this.fUseExistingLabel.setEnabled(enabled);
        this.fStepGroup.setEnabled(enabled && isNotRunMode);
        this.fStepTableViewer.getTable().setEnabled(enabled && isNotRunMode);
        this.fUseExistingText.setEnabled(enabled);
        if (enabled) {
            this.enableFields();
        }
    }

    public void setConnection(IZOSSystemImage connection) {
        this.fConnectionOverride = connection;
        this.fStepError = null;
        this.doValidation();
    }

    @Override
    public void addConnectionsSettingCompositeListener(IConnectionSettingsCompositeListener listener) {
        if (this.fConnection != null) {
            this.fConnection.addConnectionsSettingCompositeListener(listener);
        }
    }

    public void addPropertyGroupListener(SelectionListener listener) {
        if (this.fCombo != null) {
            this.fCombo.addSelectionListener(listener);
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.doValidation();
        if (this.fListener != null) {
            this.fListener.selectionChanged(null);
        }
    }

    private void selectSteps(JCLUtils.Step[] steps) {
        if (this.fStepTableViewer != null) {
            JCLUtils.Step[] stepArray = steps;
            int n = steps.length;
            int n2 = 0;
            while (n2 < n) {
                JCLUtils.Step step = stepArray[n2];
                this.fStepTableViewer.setChecked((Object)step, true);
                ++n2;
            }
        }
    }

    public boolean isUseProfile() {
        return this.fSubPgmCheckBox != null && this.fSubPgmCheckBox.getSelection();
    }

    public String getProfile() {
        return this.isUseProfile() ? this.fProfileCombo.getText() : EMPTY;
    }

    public void addProfileListener(SelectionListener listener) {
        if (this.fSubPgmCheckBox != null) {
            this.fSubPgmCheckBox.addSelectionListener(listener);
        }
    }

    public boolean isUseLocalBrowse() {
        if (this.fUseExistingText != null) {
            String strippedJCL = this.getJCL().strip();
            return strippedJCL.startsWith(JCLUtils.getWorkspaceVariable()) || strippedJCL.matches(JCLUtils.getWorkspaceVariableRegex());
        }
        return false;
    }
}

