/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.composites;

import com.ibm.debug.pdt.internal.ui.AbstractDebugComposite;
import com.ibm.ftt.common.logging.LogUtil;
import com.ibm.ftt.debug.ui.DebugMessages;
import com.ibm.ftt.debug.ui.Messages;
import com.ibm.ftt.debug.ui.composites.IConnectionProvider;
import com.ibm.ftt.debug.ui.composites.IConnectionSettingsCompositeListener;
import com.ibm.ftt.debug.ui.composites.IProfileProvider;
import com.ibm.ftt.debug.ui.composites.RseConnectionsComposite;
import com.ibm.ftt.debug.ui.composites.dlydbg.IDelayDebugEventListener;
import com.ibm.ftt.debug.ui.composites.dlydbg.IDelayDebugProvider;
import com.ibm.ftt.debug.ui.util.DebugJCLGenerationUtils;
import com.ibm.ftt.debug.ui.util.RemoteUtil;
import com.ibm.ftt.resource.utils.PBResourceUtils;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConnectionSettingsComposite
extends AbstractDebugComposite
implements IConnectionSettingsCompositeListener,
IConnectionProvider,
IDelayDebugEventListener {
    private static final String EMPTY = "";
    private static final String AMPERSAND = "&";
    private static final String PERCENT = "%";
    private static final String DIRECT = "DIRECT";
    private static final String TCIPIP = "TCPIP";
    private static final String DBM_STRING = "DBM";
    private static final String DBMDT_STRING = "DBMDT";
    private static final String TCPIP = "TCPIP";
    private Composite fAdvancedComposite;
    protected Button fAdvancedConnection;
    private Label fUserIdLabel;
    private Text fUserText;
    private Label fIpLabel;
    protected Text fIpText;
    private Label fPortLabel;
    protected Text fPortText;
    private RseConnectionsComposite fConnectionComposite;
    private IConnectionSettingsCompositeListener fListener;
    private String fConnectionString;
    private String fErrorText;
    private Control fErrorControl;
    private IProfileProvider fProfileProvider;
    private static final VerifyListener fVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (String.valueOf(e.character).matches("[a-z]")) {
                e.text = e.text.toUpperCase(Locale.getDefault());
            }
        }
    };

    public ConnectionSettingsComposite(Composite parent, IConnectionSettingsCompositeListener listener, boolean showConnectionCombo) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this);
        this.fListener = listener;
        if (showConnectionCombo) {
            this.fConnectionComposite = new RseConnectionsComposite(this, (Composite)this, 0);
        }
        this.fAdvancedComposite = new Composite((Composite)this, 0);
        GridDataFactory.swtDefaults().span(4, 1).grab(true, false).applyTo((Control)this.fAdvancedComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.fAdvancedComposite);
        this.fAdvancedConnection = new Button(this.fAdvancedComposite, 32);
        this.fAdvancedConnection.setText(Messages.ConnectionSettingsComposite_2);
        this.fAdvancedConnection.addSelectionListener((SelectionListener)this);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.fAdvancedConnection);
        new Label(this.fAdvancedComposite, 0);
        this.fUserIdLabel = new Label(this.fAdvancedComposite, 0);
        this.fUserIdLabel.setText(Messages.ConnectionSettingsComposite_3);
        GridDataFactory.swtDefaults().indent(15, -1).applyTo((Control)this.fUserIdLabel);
        this.fUserText = new Text(this.fAdvancedComposite, 2048);
        this.fUserText.addModifyListener((ModifyListener)this);
        this.fUserText.addVerifyListener(fVerifyListener);
        this.fUserText.setTextLimit(7);
        GridDataFactory.swtDefaults().hint(200, -1).applyTo((Control)this.fUserText);
        new Label(this.fAdvancedComposite, 0);
        this.fIpLabel = new Label(this.fAdvancedComposite, 0);
        this.fIpLabel.setText(Messages.ConnectionSettingsComposite_4);
        GridDataFactory.swtDefaults().indent(15, -1).applyTo((Control)this.fIpLabel);
        this.fIpText = new Text(this.fAdvancedComposite, 2048);
        this.fIpText.addModifyListener((ModifyListener)this);
        this.fIpText.setTextLimit(100);
        GridDataFactory.swtDefaults().hint(200, -1).applyTo((Control)this.fIpText);
        new Label(this.fAdvancedComposite, 0);
        this.fPortLabel = new Label(this.fAdvancedComposite, 0);
        this.fPortLabel.setText(Messages.MainTab_7);
        GridDataFactory.swtDefaults().indent(15, -1).applyTo((Control)this.fPortLabel);
        this.fPortText = new Text(this.fAdvancedComposite, 2048);
        this.fPortText.addModifyListener((ModifyListener)this);
        this.fPortText.setTextLimit(5);
        GridDataFactory.swtDefaults().hint(200, -1).applyTo((Control)this.fPortText);
        new Label(this.fAdvancedComposite, 0);
        this.updateValuesAndEnableFields();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        this.updateValuesAndEnableFields();
        if (event == null || event.widget instanceof Control && !this.validateControls((Control)event.widget)) {
            this.validateControls(null);
        }
        if (!(this.fListener == null || event != null && this.fConnectionComposite != null && this.fConnectionComposite.isValidationControl(event.widget))) {
            this.fListener.widgetSelected(event);
        }
    }

    protected void updateValuesAndEnableFields() {
        Object[] systems;
        boolean isProfileSpecified = this.fProfileProvider != null && this.fProfileProvider.isUseProfile();
        this.fAdvancedConnection.setEnabled(!isProfileSpecified);
        if (this.fConnectionComposite != null) {
            this.fConnectionComposite.refresh();
        }
        boolean hasRSEconnection = false;
        Object[] objectArray = systems = PhysicalSystemRegistryFactory.getSingleton().getSystems(2);
        int n = systems.length;
        int n2 = 0;
        while (n2 < n) {
            Object system = objectArray[n2];
            if (system instanceof IZOSSystemImage) {
                hasRSEconnection = true;
            }
            ++n2;
        }
        this.fUserIdLabel.setEnabled(hasRSEconnection && this.fAdvancedConnection.getSelection() && this.fPortText.getText().trim().isEmpty() && this.fIpText.getText().trim().isEmpty() && !isProfileSpecified);
        this.fUserText.setEnabled(hasRSEconnection && this.fAdvancedConnection.getSelection() && this.fPortText.getText().trim().isEmpty() && this.fIpText.getText().trim().isEmpty() && !isProfileSpecified);
        boolean noUser = this.fUserText.getText().trim().isEmpty() || !this.fUserText.isEnabled();
        this.fIpLabel.setEnabled(this.fAdvancedConnection.getSelection() && noUser && !isProfileSpecified);
        this.fIpText.setEnabled(this.fAdvancedConnection.getSelection() && noUser && !isProfileSpecified);
        this.fPortLabel.setEnabled(this.fAdvancedConnection.getSelection() && noUser && !isProfileSpecified);
        this.fPortText.setEnabled(this.fAdvancedConnection.getSelection() && noUser && !isProfileSpecified);
        this.fConnectionString = this.computeConnectionString();
    }

    private String computeConnectionString() {
        boolean supportsUserID = true;
        String dbmString = DBMDT_STRING;
        String ipString = "TCPIP";
        if (supportsUserID) {
            if (this.fAdvancedConnection.getSelection()) {
                if (this.fUserText.getText().trim().isEmpty()) {
                    boolean hasText = !this.fIpText.getText().trim().isEmpty() && !this.fPortText.getText().trim().isEmpty();
                    return ipString + (String)(hasText ? AMPERSAND + this.fIpText.getText().trim() + PERCENT + this.fPortText.getText().trim() : EMPTY);
                }
                boolean hasText = !this.fUserText.getText().trim().isEmpty();
                return dbmString + (String)(hasText ? PERCENT + this.fUserText.getText().trim() : EMPTY);
            }
            return dbmString;
        }
        String ip = EMPTY;
        String port = EMPTY;
        if (!this.fAdvancedConnection.getSelection()) {
            if (this.getConnection() != null && this.getConnection().isConnected()) {
                ip = PBResourceUtils.getClientIPAddress((IOSImage)this.getConnection());
                port = RemoteUtil.getLocalClientPort();
            }
        } else {
            ip = this.fIpText.getText().trim();
            port = this.fPortText.getText().trim();
        }
        boolean hasText = !ip.isEmpty() && !port.isEmpty();
        return "TCPIP" + (String)(hasText ? AMPERSAND + ip + PERCENT + port : EMPTY);
    }

    @Override
    public IZOSSystemImage getConnection() {
        return this.fConnectionComposite == null ? null : this.fConnectionComposite.getConnection();
    }

    public void modifyText(ModifyEvent event) {
        this.updateValuesAndEnableFields();
        if (event.widget instanceof Control && this.validateControls((Control)event.widget)) {
            this.validateControls(null);
        }
        if (this.fListener != null) {
            this.fListener.modifyText(event);
        }
    }

    public String getConnectionString() {
        return this.fConnectionString;
    }

    public String getPort() {
        return this.fAdvancedConnection.getSelection() ? this.fPortText.getText().trim() : EMPTY;
    }

    public String getUserID() {
        return this.fAdvancedConnection.getSelection() ? this.fUserText.getText().trim() : EMPTY;
    }

    public String getIP() {
        return this.fAdvancedConnection.getSelection() ? this.fIpText.getText().trim() : EMPTY;
    }

    public void setInitialValues(boolean isIntegratedDebugger, String systemName, String connectionString) {
        this.setConnection(systemName, true);
        this.setConnectionString(connectionString);
        this.updateValuesAndEnableFields();
    }

    public void setInitialValuesForIntegratedDebugger(String systemName) {
        this.setConnection(systemName, true);
        this.updateValuesAndEnableFields();
    }

    public void setInitialValuesForDebugTool(String systemName, String ip, String port) {
        if (systemName != null) {
            int idx = systemName.indexOf(58);
            if (idx > -1) {
                systemName = systemName.substring(0, idx);
            }
            this.setConnection(systemName, false);
        }
        if (!ip.isEmpty() || !port.isEmpty()) {
            try {
                String local = RseConnectionsComposite.getIpAddress(InetAddress.getLocalHost().getHostName());
                String savedIp = RseConnectionsComposite.getIpAddress(InetAddress.getByName(ip).getHostName());
                if (local.equals(savedIp)) {
                    this.fAdvancedConnection.setSelection(false);
                } else {
                    this.setAdvanced(ip, port);
                }
            }
            catch (UnknownHostException e) {
                LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.debug.pdt.idz.launches.common", (Throwable)e);
                this.setAdvanced(ip, port);
            }
        }
        this.updateValuesAndEnableFields();
    }

    private void setAdvanced(String ip, String port) {
        this.fAdvancedConnection.setSelection(true);
        this.fIpText.setText(ip);
        this.fPortText.setText(port);
    }

    public void setConnection(String name, boolean matchName) {
        if (this.fConnectionComposite != null) {
            this.fConnectionComposite.setConnection(name, matchName);
        }
    }

    private void setConnectionString(String connectionString) {
        if (connectionString == null) {
            return;
        }
        if (connectionString.startsWith(DBM_STRING)) {
            if ((connectionString = connectionString.startsWith(DBMDT_STRING) ? connectionString.substring(DBMDT_STRING.length()) : connectionString.substring(DBM_STRING.length())).startsWith(PERCENT) && !connectionString.substring(1).trim().isEmpty()) {
                this.fAdvancedConnection.setSelection(true);
                this.fUserText.setText(connectionString.substring(1).trim());
            }
        } else if ((connectionString.startsWith("TCPIP") || connectionString.startsWith(DIRECT)) && (connectionString = connectionString.substring(connectionString.startsWith("TCPIP") ? "TCPIP".length() : DIRECT.length())).startsWith(AMPERSAND) && !connectionString.substring(1).trim().isEmpty()) {
            int idx = (connectionString = connectionString.substring(1)).indexOf(PERCENT);
            if (idx > -1) {
                this.fIpText.setText(connectionString.substring(0, idx));
                this.fPortText.setText(connectionString.substring(idx + 1));
            } else {
                this.fIpText.setText(connectionString);
            }
            this.fAdvancedConnection.setSelection(!this.fIpText.getText().trim().isEmpty() && !this.fIpText.getText().trim().isEmpty());
        }
    }

    public boolean validateControls(Control control) {
        if (control == null) {
            this.clearErrors();
            return this.fConnectionComposite != null && this.fConnectionComposite.validateConnection() && this.validateAdvancedOptions(null);
        }
        if (this.fConnectionComposite != null && this.fConnectionComposite.isValidationControl((Widget)control)) {
            if (this.fErrorControl == this.fConnectionComposite.getErrorControl()) {
                this.clearErrors();
            }
            return this.fConnectionComposite.validateConnection();
        }
        if (control == this.fAdvancedConnection || control == this.fUserText || control == this.fIpText || control == this.fPortText) {
            if (this.fErrorControl == this.fUserText || this.fErrorControl == this.fIpText || this.fErrorControl == this.fPortText) {
                this.clearErrors();
            }
            return this.validateAdvancedOptions(control);
        }
        return true;
    }

    private void clearErrors() {
        this.fErrorText = null;
        this.fErrorControl = null;
        if (this.fConnectionComposite != null) {
            this.fConnectionComposite.clearErrors();
        }
    }

    private boolean validateAdvancedOptions(Control control) {
        boolean result = true;
        if (this.fAdvancedConnection.getSelection()) {
            boolean noDTDBM;
            String user = this.fUserText.getText().trim();
            String ip = this.fIpText.getText().trim();
            String port = this.fPortText.getText().trim();
            boolean bl = noDTDBM = this.fConnectionComposite != null && DebugJCLGenerationUtils.isDBMVersionGreaterThan111(RemoteUtil.getHost(this.fConnectionComposite.getConnection()));
            if (user.isEmpty()) {
                if (ip.isEmpty()) {
                    if (port.isEmpty()) {
                        result = false;
                        this.fErrorText = Messages.ConnectionSettingsComposite_8;
                        this.fErrorControl = this.fUserText;
                    } else {
                        result = false;
                        this.fErrorText = Messages.ConnectionSettingsComposite_9;
                        this.fErrorControl = this.fIpText;
                    }
                } else if (port.isEmpty()) {
                    result = false;
                    this.fErrorText = Messages.ConnectionSettingsComposite_10;
                    this.fErrorControl = this.fPortText;
                }
            }
            if (this.fErrorText == null && !port.isEmpty()) {
                try {
                    Integer.parseInt(port);
                }
                catch (NumberFormatException e) {
                    result = false;
                    this.fErrorControl = this.fPortText;
                    this.fErrorText = NLS.bind((String)DebugMessages.CRRDG8028, (Object)port);
                }
            }
        }
        return result;
    }

    public String getErrorText() {
        if (this.fErrorText == null) {
            return this.fConnectionComposite != null ? this.fConnectionComposite.getErrorText() : null;
        }
        return this.fErrorText;
    }

    public Control getErrorControl() {
        return this.fErrorControl;
    }

    @Override
    public void addConnectionsSettingCompositeListener(IConnectionSettingsCompositeListener listener) {
        if (this.fConnectionComposite != null) {
            this.fConnectionComposite.addConnectionsSettingCompositeListener(listener);
        }
    }

    @Override
    public void delayDebugValuesUpdated() {
    }

    public void setDelayDebugProvider(IDelayDebugProvider provider) {
        provider.addDelayDebugListener(this);
    }

    public void setProfileProvider(IProfileProvider provider) {
        this.fProfileProvider = provider;
        this.fProfileProvider.addProfileListener(this);
    }
}

