/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.engine.internal.dt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class PortForwarderThread
extends Thread {
    private boolean fContinue = true;
    private DataInputStream fReadStream;
    private DataOutputStream fWriteStream;
    private PortForwarderThread fComplementThread;

    public PortForwarderThread(String name, DataInputStream readStream, DataOutputStream writeStream) {
        super(name);
        this.fReadStream = readStream;
        this.fWriteStream = writeStream;
    }

    public void setComplementThread(PortForwarderThread complementThread) {
        this.fComplementThread = complementThread;
    }

    @Override
    public void run() {
        byte[] readBuffer = new byte[2304];
        int numberOfBytesRead = 0;
        while (this.fContinue) {
            try {
                numberOfBytesRead = this.fReadStream.read(readBuffer);
                if (numberOfBytesRead > 0) {
                    this.fWriteStream.write(readBuffer, 0, numberOfBytesRead);
                    continue;
                }
                this.stopForwarding();
            }
            catch (IOException ioe) {
                this.stopForwarding();
                this.fComplementThread.stopForwarding();
            }
        }
        this.fComplementThread = null;
    }

    public void stopForwarding() {
        this.fContinue = false;
        try {
            this.fReadStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.fWriteStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

