/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.engine.internal.dt;

import com.ibm.debug.pdt.engine.internal.dt.DTPortForwarderLog;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.eclipse.dstore.core.util.ssl.DStoreKeyStore;
import org.eclipse.dstore.core.util.ssl.IDataStoreTrustManager;

public class DebugTrustManager
extends X509ExtendedTrustManager
implements IDataStoreTrustManager {
    private X509ExtendedTrustManager fPKIXTrustManager;
    private KeyStore fKeyStore;
    private List<Certificate> fUntrustedCertificates = new ArrayList<Certificate>();

    public void setKeystore(String filePath, String password) {
        try {
            this.fKeyStore = DStoreKeyStore.getKeyStore((String)filePath, (String)password);
            if (this.fKeyStore != null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                tmf.init(this.fKeyStore);
                TrustManager[] tms = tmf.getTrustManagers();
                int i = 0;
                while (i < tms.length) {
                    if (tms[i] instanceof X509ExtendedTrustManager) {
                        this.fPKIXTrustManager = (X509ExtendedTrustManager)tms[i];
                        break;
                    }
                    ++i;
                }
            }
            if (this.fPKIXTrustManager == null) {
                DTPortForwarderLog.log(4, "Cannot find a PKIX trust manager");
            }
        }
        catch (Exception ex) {
            PICLUtils.logError((Exception)ex);
        }
    }

    public List<Certificate> getUntrustedCerts() {
        return this.fUntrustedCertificates;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.fPKIXTrustManager != null) {
            try {
                this.fPKIXTrustManager.checkClientTrusted(chain, authType);
            }
            catch (Exception ex) {
                this.computeUntrustedCertificates(chain);
                throw ex;
            }
        } else {
            throw new CertificateException();
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.fPKIXTrustManager != null) {
            try {
                this.fPKIXTrustManager.checkServerTrusted(chain, authType);
            }
            catch (Exception ex) {
                this.computeUntrustedCertificates(chain);
                throw ex;
            }
        } else {
            throw new CertificateException();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (this.fPKIXTrustManager != null) {
            try {
                this.fPKIXTrustManager.checkClientTrusted(chain, authType, socket);
            }
            catch (Exception ex) {
                this.computeUntrustedCertificates(chain);
                throw ex;
            }
        } else {
            throw new CertificateException();
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        if (this.fPKIXTrustManager != null) {
            try {
                this.fPKIXTrustManager.checkClientTrusted(chain, authType, engine);
            }
            catch (Exception ex) {
                this.computeUntrustedCertificates(chain);
                throw ex;
            }
        } else {
            throw new CertificateException();
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (this.fPKIXTrustManager != null) {
            try {
                this.fPKIXTrustManager.checkServerTrusted(chain, authType, socket);
            }
            catch (Exception ex) {
                this.computeUntrustedCertificates(chain);
                throw ex;
            }
        } else {
            throw new CertificateException();
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        if (this.fPKIXTrustManager != null) {
            try {
                this.fPKIXTrustManager.checkServerTrusted(chain, authType, engine);
            }
            catch (Exception ex) {
                this.computeUntrustedCertificates(chain);
                throw ex;
            }
        } else {
            throw new CertificateException();
        }
    }

    private void computeUntrustedCertificates(X509Certificate[] certs) {
        this.fUntrustedCertificates.clear();
        ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> aliases = this.fKeyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate aCert = this.fKeyStore.getCertificate(alias);
                if (!(aCert instanceof X509Certificate)) continue;
                trustedCerts.add((X509Certificate)aCert);
            }
        }
        catch (KeyStoreException ex) {
            PICLUtils.logError((Exception)ex);
        }
        int i = 0;
        while (i < certs.length) {
            boolean foundMatch = false;
            X509Certificate cert = certs[i];
            int j = 0;
            while (j < trustedCerts.size() && !foundMatch) {
                X509Certificate tCert = (X509Certificate)trustedCerts.get(j);
                if (cert == tCert) {
                    foundMatch = true;
                } else {
                    try {
                        PublicKey pk = tCert.getPublicKey();
                        cert.verify(pk);
                        int inLength = cert.getEncoded().length;
                        int exLength = tCert.getEncoded().length;
                        foundMatch = inLength == exLength;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++j;
            }
            if (!foundMatch) {
                this.fUntrustedCertificates.add(cert);
            }
            ++i;
        }
    }
}

