/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.engine.internal.dt;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.pdt.engine.internal.dt.DBMConnectionRegistry;
import com.ibm.debug.pdt.engine.internal.dt.DTPortForwarderLog;
import com.ibm.debug.pdt.engine.internal.dt.DebugTrustManager;
import com.ibm.debug.pdt.engine.internal.dt.Messages;
import com.ibm.debug.pdt.engine.internal.dt.PortForwarderThread;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.dstore.core.util.ssl.IDataStoreTrustManager;
import org.eclipse.dstore.internal.core.util.ssl.DStoreSSLContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.comm.ISystemKeystoreProvider;
import org.eclipse.rse.core.comm.SystemKeystoreProviderManager;
import org.eclipse.swt.widgets.Display;

public class DBMConnectionThread
extends Thread {
    private static final String IBM_1047 = "IBM-1047";
    private DataInputStream fReadStream;
    private DataOutputStream fWriteStream;
    private static final int DBMHEADER = 135;
    private static final int MAX_DBM_KEY_LENGTH = 128;
    private final String fDBMkey;
    private static final short MESSAGETYPE = 1285;
    private static final boolean DEBUGTYPE = true;
    private Socket fSocket;
    private static final int TIMEOUT = 180000;
    private boolean fUsingSSL;
    private String hostName;

    DBMConnectionThread(String _host, int port, String key, String probeVersion, boolean usingSSL, String keystoreLocation, char[] keystorePassword) throws Exception {
        block6: {
            this.hostName = _host;
            this.fDBMkey = key;
            this.fUsingSSL = usingSSL;
            if (usingSSL) {
                try {
                    this.fSocket = this.createSecureConnection(_host, port, key, usingSSL, keystoreLocation, keystorePassword);
                }
                catch (DBMUnsecureException dbe) {
                    if (PICLDebugPlugin.showQuestionDialog((String)Messages.WARNING, (String)Messages.UNSECUREDDBMWARNING)) {
                        this.fSocket = this.createUnsecuredConnection(_host, port, 180000);
                    }
                    break block6;
                }
            }
            try {
                this.fSocket = this.createUnsecuredConnection(_host, port, 180000);
            }
            catch (Exception e) {
                DTPortForwarderLog.log(4, "Unsecured Miner but Secured DBM error");
                throw e;
            }
        }
    }

    private Socket createSecureSocket(String host, int port, IDataStoreTrustManager mgr, String keystoreLocation, char[] keystorePassword) throws Exception {
        Socket socket;
        block6: {
            SSLContext context = DStoreSSLContext.getClientSSLContext((String)keystoreLocation, (String)String.valueOf(keystorePassword), (IDataStoreTrustManager)mgr);
            SSLSocketFactory factory = context.getSocketFactory();
            socket = null;
            try {
                socket = factory.createSocket(host, port);
                if (socket != null) break block6;
                DTPortForwarderLog.log(4, "Create socket failed to return a socket");
                return null;
            }
            catch (Exception ex) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw ex;
            }
        }
        socket.setSoTimeout(180000);
        ((SSLSocket)socket).startHandshake();
        ((SSLSocket)socket).getSession();
        return socket;
    }

    private Socket createSecureConnection(String _host, int port, String key, boolean usingSSL, String keystoreLocation, char[] keystorePassword) throws Exception {
        DebugTrustManager mgr = new DebugTrustManager();
        Socket socket = null;
        try {
            socket = this.createSecureSocket(_host, port, mgr, keystoreLocation, keystorePassword);
            return socket;
        }
        catch (SSLHandshakeException hse) {
            ISystemKeystoreProvider provider;
            List certs = mgr.getUntrustedCerts();
            if (certs != null && certs.size() > 0 && (provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider()) != null) {
                if (provider.importCertificates(certs, _host)) {
                    try {
                        socket = this.createSecureSocket(_host, port, mgr, keystoreLocation, keystorePassword);
                        return socket;
                    }
                    catch (SSLHandshakeException hse2) {
                        DTPortForwarderLog.log(4, hse2.getMessage(), null);
                        throw new DBMUnsecureException();
                    }
                    catch (SocketException e) {
                        DTPortForwarderLog.log(4, e.getMessage(), null);
                        throw new DBMUnsecureException();
                    }
                }
                return null;
            }
            throw new DBMUnsecureException();
        }
        catch (SocketException e) {
            DTPortForwarderLog.log(4, e.getMessage(), null);
            throw new DBMUnsecureException();
        }
        catch (Exception e) {
            throw e;
        }
    }

    private Socket createUnsecuredConnection(String _host, int port, int timeout) throws Exception {
        boolean validSocket = false;
        Socket socket = null;
        try {
            socket = new Socket(_host, port);
            socket.setSoTimeout(timeout);
            validSocket = true;
            Socket socket2 = socket;
            return socket2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (!validSocket && socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static int getCurrentPort() {
        int portNum;
        if (!CoreDaemon.isListening()) {
            CoreDaemon.startListening();
        }
        if ((portNum = CoreDaemon.getCurrentPort()) == -1) {
            portNum = 8001;
        }
        return portNum;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block40: {
            if (this.fSocket == null) {
                return;
            }
            error = false;
            try {
                block39: {
                    this.fReadStream = new DataInputStream(this.fSocket.getInputStream());
                    this.fWriteStream = new DataOutputStream(this.fSocket.getOutputStream());
                    b = this.fDBMkey.getBytes("IBM-1047");
                    this.fWriteStream.writeInt(b.length < 128 ? 7 + b.length : 135);
                    this.fWriteStream.writeShort(1285);
                    this.fWriteStream.write(b);
                    this.fWriteStream.writeBoolean(true);
                    token = new byte[this.fReadStream.readInt() - 4];
                    DTPortForwarderReply = this.fReadStream.read(token);
                    this.fWriteStream.flush();
                    this.fSocket.setSoTimeout(0);
                    if (token[2] != 1) ** GOTO lbl74
                    enginePort = DBMConnectionThread.getCurrentPort();
                    if (enginePort <= 0) {
                        checkForFreeEngineSocket = null;
                        try {
                            checkForFreeEngineSocket = new ServerSocket(0);
                            enginePort = checkForFreeEngineSocket.getLocalPort();
                        }
                        catch (IOException ioe) {
                            DTPortForwarderLog.log(4, ioe.getMessage(), ioe);
                        }
                        try {
                            if (checkForFreeEngineSocket != null) {
                                checkForFreeEngineSocket.close();
                            }
                        }
                        catch (Exception e) {
                            DTPortForwarderLog.log(4, e.getMessage(), e);
                        }
                    }
                    probeSocket = this.fSocket;
                    probeSocket.setTcpNoDelay(true);
                    streamFromProbe = new DataInputStream(probeSocket.getInputStream());
                    streamToProbe = new DataOutputStream(probeSocket.getOutputStream());
                    patience = 100;
                    engineSocket = null;
                    while (engineSocket == null && patience > 0) {
                        try {
                            engineSocket = new Socket("localhost", enginePort);
                        }
                        catch (ConnectException ce) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException var12_20) {
                                // empty catch block
                            }
                        }
                        --patience;
                    }
                    if (engineSocket != null) break block39;
                    DTPortForwarderLog.log(4, "failed to contact Daemon on port " + enginePort);
                    error = true;
                    return;
                }
                try {
                    try {
                        hostConnReg = DBMConnectionRegistry.getInstance();
                        hostConnReg.setDBMRegistry(engineSocket.getLocalPort(), this.hostName);
                        engineSocket.setTcpNoDelay(true);
                        streamFromEngine = new DataInputStream(engineSocket.getInputStream());
                        streamToEngine = new DataOutputStream(engineSocket.getOutputStream());
                        probeReadThread = new PortForwarderThread("zPICL_probeReadThread", streamFromProbe, streamToEngine);
                        engineReadThread = new PortForwarderThread("zPICL_engineReadThread", streamFromEngine, streamToProbe);
                        probeReadThread.setComplementThread(engineReadThread);
                        engineReadThread.setComplementThread(probeReadThread);
                        probeReadThread.start();
                        engineReadThread.start();
                    }
                    catch (Exception e) {
                        DTPortForwarderLog.log(4, e.getMessage(), e);
                        error = true;
                    }
                    break block40;
lbl74:
                    // 1 sources

                    errorMessage = new String(token, 3, DTPortForwarderReply - 4, "IBM-1047");
                    DTPortForwarderLog.log(4, errorMessage);
                    error = true;
                }
                catch (RuntimeException e) {
                    error = true;
                    DTPortForwarderLog.log(4, e.getMessage(), e);
                }
                catch (EOFException | SocketException e) {
                    error = true;
                    if (!this.fUsingSSL) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog dialog = new MessageDialog(null, Messages.SECURED_ERROR_TITLE, null, NLS.bind((String)Messages.SECURED_ERROR_MSG, (Object)DBMConnectionThread.this.fSocket.getRemoteSocketAddress()), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                                dialog.open();
                            }
                        });
                    }
                    DTPortForwarderLog.log(4, e.getMessage(), e);
                }
                catch (Exception e) {
                    error = true;
                    DTPortForwarderLog.log(4, e.getMessage(), e);
                }
            }
            finally {
                if (error) {
                    try {
                        this.fSocket.close();
                    }
                    catch (IOException var17_24) {}
                }
                this.fSocket = null;
            }
        }
    }

    private static class DBMUnsecureException
    extends Exception {
        private static final long serialVersionUID = 20151118L;

        public DBMUnsecureException() {
            DTPortForwarderLog.log(4, "Failed secured socket connection with DBM");
        }
    }
}

