/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZip;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZipException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class ZipResultAdapter
extends ResultAdapter {
    protected File fTempDataFile = null;

    public ZipResultAdapter(String resultPath) {
        super(resultPath);
    }

    @Override
    public boolean exists() {
        String resultPath = this.getResultPath();
        File resultFile = new File(resultPath);
        return resultFile.exists();
    }

    @Override
    public boolean isAnalyzed() {
        return this.fTempDataFile != null;
    }

    protected String getLocalZipPath() {
        return this.getResultPath();
    }

    @Override
    protected void doAnalysis(boolean useResultAPI) {
        try {
            if (this.fTempDataFile == null || this.isResultAvailable()) {
                CLCoverageZip ccZip = new CLCoverageZip(new File(this.getLocalZipPath()));
                this.fTempDataFile = ccZip.unzip(null);
                this.fIsCCResult = false;
            }
        }
        catch (CLCoverageZipException ex) {
            this.fTempDataFile = new File(this.getLocalZipPath());
            this.setResult(this.fTempDataFile.getAbsolutePath());
            this.fIsCCResult = true;
            return;
        }
        super.doAnalysis(useResultAPI);
    }

    @Override
    public String getLocalPath() {
        if (this.fTempDataFile != null) {
            if (this.isCCResult()) {
                return this.fTempDataFile.getAbsolutePath();
            }
            return this.fTempDataFile.getParentFile().getAbsolutePath();
        }
        return this.getLocalZipPath();
    }

    @Override
    public String getDataFileName() {
        if (this.fTempDataFile != null) {
            return this.fTempDataFile.getAbsolutePath();
        }
        return super.getDataFileName();
    }

    @Override
    public String getName() {
        Path path = new Path(this.getResultPath());
        return path.removeFileExtension().lastSegment();
    }

    @Override
    public void cleanup(boolean deleteDataFiles) {
        File localZip;
        super.cleanup(deleteDataFiles);
        String localZipPath = this.getLocalZipPath();
        if (localZipPath != null && deleteDataFiles && (localZip = new File(localZipPath)).exists() && !localZip.delete()) {
            ResultsViewPlugin.log("Unable to delete:" + String.valueOf(localZip));
        }
    }

    @Override
    public String rename(String newResultName) {
        File oldZipFile = new File(this.getLocalZipPath());
        String extension = "." + new Path(oldZipFile.getAbsolutePath()).getFileExtension();
        File newZipFile = ZipResultAdapter.renameFile(oldZipFile, newResultName, extension);
        File oldPropFile = this.getPropFilePath().toFile();
        File newPropFile = ZipResultAdapter.renameFile(oldPropFile, newResultName, ".properties");
        if (newZipFile != null && newPropFile != null) {
            this.setResultPath(newZipFile.getAbsolutePath());
            this.fTempDataFile = null;
            java.nio.file.Path propFileDir = this.getResultLocation().getPropFileDir();
            if (propFileDir != null) {
                this.setPropFilePath(propFileDir.resolve(newResultName + ".properties"));
            }
            this.setResult((ICCResult)null);
            return null;
        }
        if (!oldZipFile.exists()) {
            return NLS.bind((String)CCResultViewMessages.CRRDG9311, (Object)this.getName());
        }
        return NLS.bind((String)CCResultViewMessages.CRRDG9312, (Object)this.getName());
    }

    @Override
    public Image getImage() {
        return ResultsViewPlugin.getDefault().getImageRegistry().get("icons/obj16/cc_zip_obj.png");
    }

    @Override
    public boolean copyTo(File directory, boolean unpack) {
        if (unpack) {
            if (this.fTempDataFile == null) {
                this.doAnalysis(true);
            }
            if (this.fTempDataFile != null) {
                return ResultsViewUtilities.copyFiles(this.fTempDataFile.getParentFile(), directory);
            }
            return false;
        }
        return super.copyTo(directory, unpack);
    }
}

