/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.core.results.ICCTestcase;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.AbstractResultAdapter;
import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class CCZipResultAdapter
extends AbstractResultAdapter {
    protected Properties fProperties = new Properties();

    public CCZipResultAdapter(String resultPath) {
        super(resultPath);
        this.analyze(true);
        this.fLocalInitTime = System.currentTimeMillis();
    }

    @Override
    public boolean exists() {
        String resultPath = this.getResultPath();
        File resultFile = new File(resultPath);
        return resultFile.exists();
    }

    @Override
    protected void doAnalysis(boolean useResultAPI) {
        this.setResult(this.getResultPath());
    }

    @Override
    public String getName() {
        Path path = new Path(this.getResultPath());
        return path.removeFileExtension().lastSegment();
    }

    @Override
    public Image getImage() {
        return ResultsViewPlugin.getDefault().getImageRegistry().get("icons/obj16/cc_zip_obj.png");
    }

    @Override
    public boolean copyTo(File directory, boolean unpack) {
        return false;
    }

    @Override
    public String getTestcaseID() {
        if (this.fProperties.containsKey("testcase")) {
            return this.fProperties.getProperty("testcase");
        }
        if (!this.isAnalyzed()) {
            this.analyze(true);
        }
        StringBuilder testIds = new StringBuilder();
        if (this.isResultAvailable()) {
            ICCTestcase[] iCCTestcaseArray = this.getResult().getTestcases();
            int n = iCCTestcaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICCTestcase t = iCCTestcaseArray[n2];
                if (testIds.length() > 0) {
                    testIds.append(',');
                }
                testIds.append(t.getName());
                ++n2;
            }
        }
        this.fProperties.setProperty("testcase", testIds.toString());
        return this.getTestcaseID();
    }

    @Override
    public long getElapsedTime() {
        if (this.fProperties.containsKey("elapsedTime")) {
            return Long.parseLong(this.fProperties.getProperty("elapsedTime"));
        }
        if (!this.isAnalyzed()) {
            this.analyze(true);
        }
        long elapsedTime = 0L;
        if (this.isResultAvailable()) {
            ICCTestcase[] iCCTestcaseArray = this.getResult().getTestcases();
            int n = iCCTestcaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICCTestcase t = iCCTestcaseArray[n2];
                elapsedTime += t.getElapsedTime();
                ++n2;
            }
        }
        this.fProperties.setProperty("elapsedTime", Long.toString(elapsedTime));
        return this.getElapsedTime();
    }

    @Override
    public String getBaselineFileName() {
        return null;
    }

    @Override
    public void open(String mode, Shell activeShell) {
    }
}

