/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler.CumulativeAnnotation;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler.HoverInformationControl;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.RulerAnnotationUtilities;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.widgets.Shell;

public class CCRulerHover
implements IAnnotationHover,
IAnnotationHoverExtension,
IInformationProviderExtension2 {
    private IInformationControlCreator fInformationControlCreator;
    private IInformationControlCreator fInformationPresenterControlCreator;

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        return "";
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fInformationControlCreator == null) {
            this.fInformationControlCreator = new AbstractReusableInformationControlCreator(){

                protected IInformationControl doCreateInformationControl(Shell parent) {
                    return new HoverInformationControl(parent, false);
                }
            };
        }
        return this.fInformationControlCreator;
    }

    public boolean canHandleMouseCursor() {
        return false;
    }

    public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleNumberOfLines) {
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        CumulativeAnnotation a = RulerAnnotationUtilities.getCumulativeAnnotation(model, RulerAnnotationUtilities.getOffsetOfLine(sourceViewer, lineRange.getStartLine()), RulerAnnotationUtilities.getLengthOfLine(sourceViewer, lineRange.getStartLine()));
        StringBuilder sb = new StringBuilder();
        if (a != null) {
            return new Object[]{a, lineRange};
        }
        return sb.toString();
    }

    public ILineRange getHoverLineRange(ISourceViewer sourceViewer, int lineNumber) {
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        CumulativeAnnotation annotation = RulerAnnotationUtilities.getCumulativeAnnotation(model, RulerAnnotationUtilities.getOffsetOfLine(sourceViewer, lineNumber), RulerAnnotationUtilities.getLengthOfLine(sourceViewer, lineNumber));
        if (annotation != null) {
            Position p = model.getPosition((Annotation)annotation);
            int endLine = lineNumber;
            int startLine = lineNumber;
            IDocument document = sourceViewer.getDocument();
            try {
                startLine = document.getLineOfOffset(p.getOffset());
                endLine = document.getLineOfOffset(p.getOffset() + p.getLength() - 1);
            }
            catch (BadLocationException e) {
                ResultsViewPlugin.log(e);
            }
            startLine = annotation.getStartLine(lineNumber + 1, startLine + 1) - 1;
            endLine = annotation.getEndLine(lineNumber + 1, endLine + 1) - 1;
            return new LineRange(startLine, endLine - startLine + 1);
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fInformationPresenterControlCreator == null) {
            this.fInformationPresenterControlCreator = new AbstractReusableInformationControlCreator(){

                protected IInformationControl doCreateInformationControl(Shell parent) {
                    return new HoverInformationControl(parent, true);
                }
            };
        }
        return this.fInformationPresenterControlCreator;
    }
}

