/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler.CCAnnotationModel;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler.CCRulerHover;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler.CumulativeAnnotation;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.RulerAnnotationUtilities;
import com.ibm.debug.pdt.codecoverage.ui.percentPainter.AbstractTattColorFontItem;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;

public class CCRuler
extends AbstractRulerColumn
implements IContributedRulerColumn,
IAnnotationModelListener,
IAnnotationModelListenerExtension,
IMenuListener,
IStateListener {
    private static final String UNCOVERED_TEXT = "\u2718";
    private static final String COVERED_TEXT = "\u2714";
    private boolean fShowText = false;
    private boolean fSizeCalcNeeded = true;
    private RulerColumnDescriptor fDescriptor;
    private ITextEditor fEditor;
    private AbstractTattColorFontItem fColorFontItem = new AbstractTattColorFontItem(){

        @Override
        protected void doRedraw() {
            CCRuler.this.fSizeCalcNeeded = true;
            CCRuler.this.redraw();
        }
    };
    private static final int RULER_GAP_HEIGHT = 5;
    private Map<Integer, Boolean> fLineTable = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> fGapTable = new HashMap<Integer, Boolean>();

    public void columnCreated() {
        this.setHover(new CCRulerHover());
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("com.ibm.debug.pdt.codecoverage.ui.command.showRulerText");
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        if (state != null && state.getValue() instanceof Boolean) {
            this.fShowText = (Boolean)state.getValue();
        }
        if (state != null) {
            state.addListener((IStateListener)this);
        }
    }

    public void columnRemoved() {
        this.setHover(null);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("com.ibm.debug.pdt.codecoverage.ui.command.showRulerText");
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        state.removeListener((IStateListener)this);
        if (this.getModel() != null) {
            this.getModel().removeAnnotationModelListener((IAnnotationModelListener)this);
        }
        this.fColorFontItem.dispose();
        if (this.fEditor instanceof ITextEditorExtension) {
            ((ITextEditorExtension)this.fEditor).removeRulerContextMenuListener((IMenuListener)this);
        }
        this.fDescriptor = null;
        this.fEditor = null;
    }

    protected Color computeBackground(int line) {
        Color color;
        if (!this.fShowText && (color = this.getColor(line)) != null) {
            return color;
        }
        return super.computeBackground(line);
    }

    protected Color computeForeground(int line) {
        Color color;
        if (this.fShowText && (color = this.getColor(line)) != null) {
            return color;
        }
        return super.computeForeground(line);
    }

    protected String computeText(int line) {
        Boolean covered;
        if (this.fShowText && (covered = this.fLineTable.get(line)) != null) {
            return covered != false ? COVERED_TEXT : UNCOVERED_TEXT;
        }
        return null;
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.setWidth(0);
        return super.createControl(parentRuler, parentControl);
    }

    public void dispose() {
        super.dispose();
        this.columnRemoved();
    }

    private void doSetWidth(int width) {
        if (this.getControl() != null) {
            boolean needsLayout;
            boolean bl = needsLayout = width != this.getWidth();
            if (needsLayout) {
                this.hideJavaCCRuler();
                this.fSizeCalcNeeded = false;
                this.setWidth(width);
                this.getControl().getParent().layout();
            }
        }
    }

    private Color getColor(int line) {
        if (line < 0) {
            return null;
        }
        Boolean covered = this.fLineTable.get(line);
        if (covered == null) {
            return null;
        }
        if (!this.fShowText && this.fSizeCalcNeeded) {
            this.doSetWidth(5);
        }
        return covered != false ? this.fColorFontItem.getCoveredBackgroundColor() : this.fColorFontItem.getUncoveredBackgroundColor();
    }

    public RulerColumnDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public ITextEditor getEditor() {
        return this.fEditor;
    }

    public void handleStateChange(State state, Object oldValue) {
        if (state.getValue() instanceof Boolean && !state.getValue().equals(oldValue)) {
            this.fShowText = (Boolean)state.getValue();
            this.fSizeCalcNeeded = true;
            this.redraw();
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
    }

    public void modelChanged(AnnotationModelEvent event) {
        if (event.getAnnotationModel() instanceof CCAnnotationModel) {
            if (event.getAddedAnnotations().length > 0) {
                if (event.getRemovedAnnotations().length > 0) {
                    this.fLineTable.clear();
                    this.fGapTable.clear();
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CCRuler.this.doSetWidth(5);
                        CCRuler.this.fSizeCalcNeeded = true;
                        CCRuler.this.redraw();
                    }
                });
            } else if (event.isWorldChange()) {
                this.fLineTable.clear();
                this.fGapTable.clear();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CCRuler.this.doSetWidth(5);
                        CCRuler.this.fSizeCalcNeeded = true;
                        CCRuler.this.redraw();
                    }
                });
            }
        }
    }

    public void modelChanged(IAnnotationModel model) {
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        if (!this.fShowText && this.fGapTable.get(modelLine) != null) {
            gc.setBackground(this.getDefaultBackground());
            gc.fillRectangle(0, linePixel, this.getWidth(), 5);
            linePixel += 5;
            lineHeight -= 5;
        }
        if (!(this.getEditor() instanceof AbstractTextEditor)) {
            this.computeLineInformation(modelLine);
            this.resetFont(gc);
        }
        super.paintLine(gc, modelLine, widgetLine, linePixel, lineHeight);
    }

    private void computeLineInformation(int line) {
        if (!this.fLineTable.containsKey(line)) {
            try {
                Boolean covered = this.isCovered(line);
                this.fLineTable.put(line, covered);
                Boolean prevLine = this.fLineTable.get(line - 1);
                if (prevLine != null && !prevLine.equals(covered)) {
                    this.fGapTable.put(line, covered);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void paint(GC gc, ILineRange lines) {
        ITextViewer viewer = this.getParentRuler().getTextViewer();
        if (viewer != null) {
            int firstLine = lines.getStartLine();
            int lastLine = firstLine + lines.getNumberOfLines();
            int line = firstLine;
            while (line < lastLine) {
                int modelLine = JFaceTextUtil.widgetLine2ModelLine((ITextViewer)viewer, (int)line);
                if (modelLine != -1) {
                    this.computeLineInformation(modelLine);
                }
                ++line;
            }
        }
        this.resetFont(gc);
        super.paint(gc, lines);
    }

    private void resetFont(GC gc) {
        if (this.fShowText) {
            ITextEditor activeEditor = this.getEditor();
            Font editorFont = null;
            if (activeEditor != null) {
                editorFont = ((Control)activeEditor.getAdapter(Control.class)).getFont();
            }
            if (editorFont != null) {
                if (!gc.getFont().equals((Object)editorFont)) {
                    gc.setFont(editorFont);
                }
                int width = Math.max(gc.textExtent((String)COVERED_TEXT).x, gc.textExtent((String)UNCOVERED_TEXT).x);
                if (this.getWidth() != width + 2) {
                    this.doSetWidth(width + 2);
                }
            }
        }
    }

    private Boolean isCovered(int line) throws Exception {
        CumulativeAnnotation annotation;
        IAnnotationModel model = this.getModel();
        int offset = RulerAnnotationUtilities.getOffsetOfLine(this.fEditor, line);
        int length = RulerAnnotationUtilities.getLengthOfLine(this.fEditor, line);
        if (offset > -1 && length > -1 && (annotation = RulerAnnotationUtilities.getCumulativeAnnotation(model, offset, length)) != null) {
            return annotation.isCovered(line);
        }
        throw new Exception("Not executable");
    }

    public void setDescriptor(RulerColumnDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public void setEditor(ITextEditor editor) {
        this.fEditor = editor;
        if (this.fEditor instanceof ITextEditorExtension) {
            ((ITextEditorExtension)this.fEditor).addRulerContextMenuListener((IMenuListener)this);
        }
    }

    private void hideJavaCCRuler() {
        IColumnSupport colsup;
        RulerColumnDescriptor desc = RulerColumnRegistry.getDefault().getColumnDescriptor("com.ibm.rational.llc.ui.ruler");
        if (desc != null && (colsup = (IColumnSupport)this.fEditor.getAdapter(IColumnSupport.class)) != null) {
            colsup.setColumnVisible(desc, false);
        }
    }

    public void setModel(IAnnotationModel model) {
        super.setModel(model);
        if (model != null) {
            model.addAnnotationModelListener((IAnnotationModelListener)this);
        }
    }
}

