/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.handlers;

import com.ibm.debug.pdt.codecoverage.core.results.ICCFile;
import com.ibm.debug.pdt.codecoverage.core.results.ICCSource;
import com.ibm.debug.pdt.codecoverage.core.results.ICCTestcase;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.RulerAnnotationUtilities;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.io.File;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class OpenCCFileHandler
extends AbstractHandler
implements IElementUpdater {
    private static final ICCTestcase[] EMPTY_TEST = new ICCTestcase[0];

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection == null) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        if (selection instanceof IStructuredSelection) {
            for (Object item : ((IStructuredSelection)selection).toList()) {
                if (!(item instanceof ICCSource) || !((ICCSource)item).isSourceAvailable()) continue;
                this.openEditor((ICCSource)item, ((ICCSource)item).getLine());
            }
        }
        return null;
    }

    public void openEditor(final ICCSource srcItem, int lineNumber) {
        IEditorPart editorPart = null;
        if (srcItem.isSourceAvailable()) {
            File srcFile = srcItem.getFile(true);
            IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(srcFile);
            IFile projectFile = null;
            IFile[] foundFiles = ResultsViewUtilities.findFileInProject(fileStore);
            if (foundFiles.length > 0) {
                projectFile = foundFiles[0];
            } else {
                try {
                    projectFile = ResultsViewUtilities.getProjectLinkedFile(srcItem.getResult().getName(), srcFile.getName(), (IPath)new Path(srcFile.getPath()));
                    String encoding = srcItem.getEncoding();
                    if (!projectFile.getCharset().equals(encoding)) {
                        projectFile.setCharset(encoding, null);
                    }
                }
                catch (CoreException e) {
                    ResultsViewPlugin.log(e);
                }
            }
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                if (projectFile != null) {
                    String editor = this.mapEditor(IDE.getDefaultEditor((IFile)projectFile));
                    editorPart = IDE.openEditor((IWorkbenchPage)activePage, (IFile)projectFile, (String)editor);
                }
                editorPart = IDE.openInternalEditorOnFileStore((IWorkbenchPage)activePage, (IFileStore)fileStore);
            }
            catch (PartInitException e) {
                ResultsViewPlugin.log(e);
                return;
            }
        } else {
            IProject project;
            String projectName = (String)srcItem.getProperty("project");
            if (projectName != null && !projectName.isEmpty() && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.exists()) {
                String srcFolder = (String)srcItem.getProperty("srcfolder");
                Object fileName = srcFolder == null ? srcItem.getFileName() : srcFolder + File.separatorChar + srcItem.getFileName();
                IFile file = project.getFile((String)fileName);
                if (file == null) {
                    return;
                }
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    String editor = this.mapEditor(IDE.getDefaultEditor((IFile)file));
                    editorPart = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (String)editor);
                }
                catch (PartInitException e) {
                    ResultsViewPlugin.log(e);
                    return;
                }
            }
        }
        final ITextEditor editor = (ITextEditor)editorPart;
        this.gotoLineNumber(editor, lineNumber);
        Job annotationJob = new Job("Adding Code Coverage annotations"){

            protected IStatus run(IProgressMonitor monitor) {
                ICCFile tFile = srcItem.getResult().getFile(srcItem.getFileName());
                Integer[] cumulativeCoveredLines = tFile.getLines(true);
                Integer[] executableLines = tFile.getLines(false);
                RulerAnnotationUtilities.generateAnnotations(cumulativeCoveredLines, executableLines, EMPTY_TEST, tFile, editor);
                return Status.OK_STATUS;
            }
        };
        annotationJob.setSystem(true);
        annotationJob.schedule();
    }

    private void gotoLineNumber(ITextEditor editor, int lineNumber) {
        if (editor == null) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)input);
        try {
            int offset = doc.getLineOffset(Math.max(lineNumber - 1, 0));
            editor.selectAndReveal(offset, 0);
        }
        catch (BadLocationException e) {
            ResultsViewPlugin.log(4, String.format("Line %d not found in file %s", lineNumber, input.getName()), e);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        IServiceLocator locator = element.getServiceLocator();
        ISelectionService service = (ISelectionService)locator.getService(ISelectionService.class);
        if (service != null) {
            ISelection selection = service.getSelection();
            if (locator instanceof IWorkbenchWindow) {
                IWorkbenchPart part = ((IWorkbenchWindow)locator).getActivePage().getActivePart();
                if (part instanceof ContentOutline) {
                    selection = service.getSelection("org.eclipse.ui.views.ContentOutline");
                }
                if (selection == null) {
                    return;
                }
            }
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection sSelection = (IStructuredSelection)selection;
                Object item = null;
                Object[] objectArray = sSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object sItem = objectArray[n2];
                    if (item == null) {
                        item = sItem;
                    } else if (!item.getClass().equals(sItem.getClass())) {
                        item = null;
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    private String mapEditor(IEditorDescriptor ed) {
        String mapped = this.getMappedEditorID(ed);
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = editorReg.findEditor(mapped);
        if (editorDesc == null) {
            return ed == null ? "org.eclipse.ui.DefaultTextEditor" : ed.getId();
        }
        return mapped;
    }

    private String getMappedEditorID(IEditorDescriptor ed) {
        String id;
        if (ed == null) {
            return "org.eclipse.ui.DefaultTextEditor";
        }
        switch (id = ed.getId()) {
            case "com.ibm.systemz.cobol.editor.jface.editor.CobolEditorID": {
                return "com.ibm.debug.pdt.editors.CobolEditor";
            }
            case "com.ibm.systemz.pl1.editor.jface.editor.Pl1EditorID": {
                return "com.ibm.debug.pdt.editors.PL1Editor";
            }
            case "org.eclipse.ptp.rdt.ui.editor.CEditor": {
                return "com.ibm.debug.pdt.internal.editors.rdz.RemoteCEditor";
            }
            case "com.ibm.ftt.lpex.systemz.SystemzLpex2": 
            case "com.ibm.ftt.ui.os390editors.Os390SolutionsEditor": 
            case "com.ibm.ftt.lpex.systemz.SystemzLpex": {
                return "com.ibm.debug.pdt.editors.SystemzLpex";
            }
        }
        if (id.startsWith("org.") || id.startsWith("com.")) {
            return id;
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }
}

