/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.handlers;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.AbstractResultHandler;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultsView;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteResultHandler
extends AbstractResultHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IResultAdapter[] adapters = this.getSelectedResults(event);
        String title = Labels.DELETE_CC_RESULT_TITLE;
        String msg = NLS.bind((String)Labels.DELETE_CC_RESULT_QUESTION, (Object)adapters.length);
        final ICCResultsView view = this.getCCResultsView(event);
        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg)) {
            WorkspaceJob removeLaunchJob = new WorkspaceJob("Remove coverage launch"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    HashSet<IResultLocation> locations = new HashSet<IResultLocation>();
                    IResultAdapter[] iResultAdapterArray = adapters;
                    int n = adapters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResultAdapter adapter = iResultAdapterArray[n2];
                        adapter.closeOpenedReportViewer();
                        adapter.getResultLocation().removeResult(adapter);
                        if (view != null) {
                            DeleteResultHandler.this.removeResult(view, adapter);
                        }
                        locations.add(adapter.getResultLocation());
                        ++n2;
                    }
                    for (IResultLocation location : locations) {
                        CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent(location, 3));
                    }
                    return Status.OK_STATUS;
                }
            };
            removeLaunchJob.setSystem(true);
            removeLaunchJob.schedule();
        }
        return null;
    }

    private void removeResult(ICCResultsView view, final IResultAdapter adapter) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                CCResultEventManager.getDefault().fireResultEvent(new CCResultEvent(adapter, 6));
            }
        });
    }
}

