/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.debug.pdt.codecoverage.core.results.CCMessageUtilities;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.results.exporters.sonar.CCSonarQubeExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.results.exporters.sonar.CCSonarQubeExporterSettings;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.CCTitleAreaDialog;
import java.nio.charset.Charset;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportEncodingDialog
extends CCTitleAreaDialog
implements IResultViewConstants {
    private static final int COL_COUNT = 2;
    private Text fEncodingText;
    private IDialogSettings fDSettings;

    public ExportEncodingDialog(Shell shell, IDialogSettings setting) {
        super(shell);
        this.fDSettings = setting;
    }

    public void create() {
        super.create();
        this.setTitle(Labels.ENCODING_DIALOG_TITLE);
        this.setMessage(Labels.ENCODING_DIALOG_INFO);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Labels.ENCODING_DIALOG_TITLE);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        this.createEncodingArea(container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.debug.pdt.codecoverage.ui.view.export_encoding_dialog");
        return composite;
    }

    private void createEncodingArea(Composite container) {
        Composite Composite2 = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(Composite2);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 0).applyTo((Control)Composite2);
        Label label = new Label(Composite2, 0);
        label.setText(Labels.ENCODING);
        this.fEncodingText = new Text(Composite2, 2048);
        this.fEncodingText.setToolTipText(Labels.ENCODING_TOOLTIP);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fEncodingText);
        String encoding = this.fDSettings.get("exportencoding");
        if (encoding == null || encoding.isEmpty()) {
            this.fEncodingText.setText("UTF-8");
        } else {
            this.fEncodingText.setText(encoding);
        }
        this.fEncodingText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportEncodingDialog.this.validateExportEncoding(ExportEncodingDialog.this.fEncodingText.getText());
            }
        });
    }

    protected void okPressed() {
        String encoding = this.fEncodingText.getText();
        if (!this.validateExportEncoding(encoding)) {
            return;
        }
        CCExporterFactory.getInstance().registerExporter((ICCExporter)new CCSonarQubeExporter(), "CCSONARQUBE");
        CCSonarQubeExporterSettings settings = new CCSonarQubeExporterSettings();
        settings.setExportEncoding(encoding);
        this.fDSettings.put("exportencoding", encoding);
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    private void clearErrorMessage() {
        this.setErrorMessage(null);
        this.setMessage(Labels.ENCODING_DIALOG_INFO);
        this.enableButtons(true);
    }

    private void enableButtons(boolean enabled) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
    }

    private boolean validateExportEncoding(String encoding) {
        this.clearErrorMessage();
        if (encoding == null || encoding.isEmpty()) {
            this.enableButtons(false);
            return false;
        }
        if (!Charset.isSupported(encoding)) {
            this.setErrorMessage(NLS.bind((String)CCMessageUtilities.getMessage((String)"ACRRDG7280E"), (Object)encoding));
            this.enableButtons(false);
            return false;
        }
        return true;
    }
}

