/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CLRenameResultDialog
extends InputDialog {
    public CLRenameResultDialog(Shell shell, final IResultAdapter result) {
        super(shell, Labels.Coverage_rename_result_dialog_title, Labels.Coverage_rename_result_dialog_text_label, result.getName(), new IInputValidator(){

            public String isValid(String newName) {
                IStatus status = CLRenameResultDialog.validateResultName(newName);
                if (status.getSeverity() != 0) {
                    return status.getMessage();
                }
                if (CLRenameResultDialog.isExistingResultName(newName, result)) {
                    return NLS.bind((String)CCResultViewMessages.CRRDG9307, (Object)newName);
                }
                return null;
            }
        });
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(768));
        Text inputNameText = this.getText();
        inputNameText.setToolTipText(Labels.RENAME_RESULT_TOOLTIP);
        return composite;
    }

    private static IStatus validateResultName(String resultName) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IStatus status = ws.validateName(resultName, 1);
        return status;
    }

    private static boolean isExistingResultName(String resultName, IResultAdapter result) {
        return result.getResultLocation().findResultWithName(resultName) != null;
    }
}

