/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas;

import com.ibm.commoncomponents.ccaas.core.http.request.HttpClient;
import com.ibm.commoncomponents.ccaas.core.json.CCResultEntrySerializable;
import com.ibm.commoncomponents.ccaas.core.json.UpdateSerializable;
import com.ibm.commoncomponents.ccaas.core.repo.ICCResultEntry;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZipException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.CCaasResultAdapter;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.ICCaasResultLocation;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.CcsNetAuthenticator;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.AbstractRemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

public class CCaasResultLocation
extends AbstractRemoteResultLocation
implements ICCaasResultLocation {
    private static final String MEMENTO_KEY_LOCATION_IS_CCAAS = "isCCaaS";
    private static final String MEMENTO_KEY_LOCATION_CCAAS_HOST = "host";
    private static final String MEMENTO_KEY_LOCATION_CCAAS_PORT = "port";
    private static final String MEMENTO_KEY_LOCATION_CCAAS_SECURE = "secure";
    private HttpClient fHttpClient;
    private long fUpdateTimeStamp = 0L;
    private boolean fPingCheck = false;

    public CCaasResultLocation(String name, HttpClient client) {
        super(CCaasResultLocation.getDownloadPath(client.getHost(), client.getPort()), name, false, null);
        this.fHttpClient = client;
        this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.CONNECTED);
    }

    @Override
    public void refreshResults() {
        if (!this.fPingCheck) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ResultViewImportExportUtils.pingCCaaSOK(CCaasResultLocation.this.fHttpClient, Display.getCurrent().getActiveShell())) {
                        CCaasResultLocation.this.fPingCheck = true;
                        CCaasResultLocation.this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.CONNECTED);
                    }
                }
            });
            if (this.getConnectionStatus() != AbstractRemoteResultLocation.CONNECTION.CONNECTED) {
                return;
            }
        }
        this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.CONNECTED);
        this.setErrorMessage(null);
        try {
            if (!this.isUpdated()) {
                return;
            }
        }
        catch (ConnectException ce) {
            this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.DISCONNECTED);
            return;
        }
        catch (IOException e) {
            this.setConnectionStatus(AbstractRemoteResultLocation.CONNECTION.CONNECTION_ERROR);
            this.setErrorMessage(e.getMessage());
            return;
        }
        ArrayList<IResultAdapter> currentList = new ArrayList<IResultAdapter>();
        currentList.addAll(this.getResults());
        for (CCResultEntrySerializable entry : this.getCCaaSResults()) {
            CCaasResultAdapter adapter = new CCaasResultAdapter((ICCResultEntry)entry, this.getPath());
            this.addResult(adapter);
            currentList.remove(adapter);
        }
        for (IResultAdapter adapter : currentList) {
            super.removeResult(adapter);
        }
    }

    @Override
    public List<IResultAdapter> getResults() {
        if (this.isConnected()) {
            return super.getResults();
        }
        return Collections.emptyList();
    }

    private boolean isUpdated() throws IOException {
        UpdateSerializable updateData = this.getHttpClient().update();
        if (updateData.getUpdateTimeStamp() != this.fUpdateTimeStamp) {
            this.fUpdateTimeStamp = updateData.getUpdateTimeStamp();
            return true;
        }
        return false;
    }

    @Override
    public Image getImage() {
        return ResultsViewPlugin.getDefault().getImageRegistry().get("icons/obj16/local_location_obj.png");
    }

    @Override
    public boolean expandLocationOnRestart() {
        return false;
    }

    @Override
    public boolean isSaveRestoreable() {
        return true;
    }

    @Override
    public HttpClient getHttpClient() {
        Authenticator.setDefault(new CcsNetAuthenticator(this.fHttpClient));
        return this.fHttpClient;
    }

    @Override
    public void importResultToLocation(File dataFile) throws CLCoverageZipException {
        try {
            this.getHttpClient().uploadResult(dataFile);
        }
        catch (IOException e) {
            throw new CLCoverageZipException(e);
        }
    }

    private static String getDownloadPath(String host, String port) {
        IPath path = ResultsViewPlugin.getDefault().getStateLocation();
        IPath downloadPath = path.append("ccaas").append(host + "_" + port);
        File directory = downloadPath.toFile();
        if (!directory.mkdirs()) {
            ResultsViewPlugin.log("CCaasResultLocation: Unable to create dir: " + String.valueOf(directory));
        }
        return directory.getPath();
    }

    private List<CCResultEntrySerializable> getCCaaSResults() {
        try {
            return this.getHttpClient().getResults();
        }
        catch (IOException e) {
            ResultsViewPlugin.log(e);
            return Collections.emptyList();
        }
    }

    @Override
    public void removeResult(IResultAdapter adapter) {
        if (adapter instanceof CCaasResultAdapter) {
            String id = ((CCaasResultAdapter)adapter).getId();
            try {
                this.getHttpClient().deleteResult(id);
                super.removeResult(adapter);
            }
            catch (IOException e) {
                ResultsViewPlugin.log(e);
            }
        }
    }

    @Override
    protected void addSaveProperties(IMemento child) {
        child.putBoolean(MEMENTO_KEY_LOCATION_IS_CCAAS, true);
        child.putString(MEMENTO_KEY_LOCATION_CCAAS_HOST, this.getHttpClient().getHost());
        child.putString(MEMENTO_KEY_LOCATION_CCAAS_PORT, this.getHttpClient().getPort());
        child.putBoolean(MEMENTO_KEY_LOCATION_CCAAS_SECURE, this.getHttpClient().isSecured());
    }

    @Override
    public void cleanup() {
        try {
            ResultViewImportExportUtils.deleteDir(this.getPath());
            super.cleanup();
        }
        catch (IOException e) {
            ResultsViewPlugin.log(e.getMessage());
        }
    }
}

