/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ResultsViewPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.debug.pdt.codecoverage.ui.view";
    private static ResultsViewPlugin plugin;
    private static ILog fLog;

    static {
        fLog = Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID));
    }

    public static ResultsViewPlugin getDefault() {
        return plugin;
    }

    public static final void log(int severity, String message) {
        fLog.log((IStatus)new Status(severity, PLUGIN_ID, message));
    }

    public static final void log(int severity, String message, Throwable e) {
        fLog.log((IStatus)new Status(severity, PLUGIN_ID, message, e));
    }

    public static final void log(String message) {
        fLog.log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static final void log(Throwable e) {
        fLog.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private void addImage(ImageRegistry reg, String iconPath) {
        reg.put(iconPath, ResultsViewPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)iconPath));
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.addImage(reg, "icons/obj16/state_passed.png");
        this.addImage(reg, "icons/obj16/state_failed.png");
        this.addImage(reg, "icons/obj16/state_warning.png");
        this.addImage(reg, "icons/obj16/state_unknown.png");
        this.addImage(reg, "icons/obj16/error_obj.png");
        this.addImage(reg, "icons/obj16/local_location_obj.png");
        this.addImage(reg, "icons/obj16/info_obj.png");
        this.addImage(reg, "icons/elcl16/html_pal.png");
        this.addImage(reg, "icons/view16/report_viewer.png");
        this.addImage(reg, "icons/elcl16/threshold_filter.png");
        this.addImage(reg, "icons/obj16/cc_zip_obj.png");
        this.addImage(reg, "icons/obj16/targets_dgm16.png");
        this.addImage(reg, "icons/view16/coverage_history.png");
        this.addImage(reg, "icons/elcl16/add.png");
        this.addImage(reg, "icons/elcl16/remove_16.png");
        this.addImage(reg, "icons/obj16/workspace.png");
        this.addImage(reg, "icons/obj16/javaexp_ovr.png");
        Image image = reg.get("icons/obj16/workspace.png");
        ImageDescriptor overlayDescriptor = reg.getDescriptor("icons/obj16/javaexp_ovr.png");
        DecorationOverlayIcon overlayImage = new DecorationOverlayIcon(image, overlayDescriptor, 2);
        Image decorated = overlayImage.createImage(false);
        if (decorated != null) {
            reg.put("java_workspace_key", decorated);
        }
    }
}

