/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZipException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CLCoverageZip {
    private final File fFile;
    private String fName = null;
    private File fDataFile = null;
    private boolean fLinkToDefaultLocation = false;
    private COVERAGE_TYPE fCoverageType;

    public CLCoverageZip(File file) throws CLCoverageZipException {
        this(file, false);
    }

    public CLCoverageZip(File file, boolean linkToDefaultLocation) throws CLCoverageZipException {
        this.fFile = file;
        this.fLinkToDefaultLocation = linkToDefaultLocation;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(this.fFile);){
                this.fCoverageType = CLCoverageZip.getCoverageType(zipFile);
                if (this.fCoverageType == COVERAGE_TYPE.INVALID) {
                    throw new CLCoverageZipException(Labels.bind((String)Labels.COVERAGEIMPORTWIZARDPAGE_ZIP_IMPORT_ERROR_NO_DATAFILE, (Object)this.fFile.getAbsolutePath()), null);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new CLCoverageZipException(ioe);
        }
    }

    private static COVERAGE_TYPE getCoverageType(ZipFile zipFile) {
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().toLowerCase().endsWith(".clcoveragedata")) {
                    return COVERAGE_TYPE.CCRAW;
                }
                if (!entry.getName().toLowerCase().endsWith("ccdata")) continue;
                return COVERAGE_TYPE.CCDATA;
            }
        }
        return COVERAGE_TYPE.INVALID;
    }

    public static boolean isValidCoverageZip(ZipFile file) {
        return CLCoverageZip.getCoverageType(file) != COVERAGE_TYPE.INVALID;
    }

    public File unzip(IProgressMonitor monitor) throws CLCoverageZipException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Unzip cc results", -1);
        try {
            IFolder rootPath = this.getUnzipRootPath(this.fFile, this.fLinkToDefaultLocation);
            if (rootPath != null) {
                this.extractZipContents(this.fFile, rootPath);
                if (this.fDataFile != null) {
                    ResultViewImportExportUtils.resetViewFileFolder(this.fDataFile, null, false);
                    File file = this.fDataFile;
                    return file;
                }
            }
        }
        catch (Exception e) {
            throw new CLCoverageZipException(e);
        }
        finally {
            monitor.done();
        }
        return null;
    }

    public void importFromZip(IProgressMonitor monitor, IResultLocation location) throws CLCoverageZipException {
        location.importResultToLocation(this.fFile);
    }

    private void extractZipContents(File file, IFolder rootFolder) throws IOException, CoreException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.extractZipEntry(zipFile, entry, rootFolder);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void extractZipEntry(ZipFile zipFile, ZipEntry entry, IFolder rootFolder) throws CoreException, IOException {
        String entryName = entry.getName();
        if (entry.isDirectory()) {
            IFolder folderEntry = rootFolder.getFolder(entryName);
            if (!folderEntry.exists()) {
                folderEntry.create(true, true, null);
            }
        } else {
            InputStream is = zipFile.getInputStream(entry);
            IFile entryFile = rootFolder.getFile((IPath)new Path(entryName));
            if (entryFile.exists()) {
                entryFile.delete(true, null);
            }
            entryFile.create(is, true, null);
            entryFile.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
            if (entryName.toLowerCase().endsWith(".clcoveragedata")) {
                this.fDataFile = entryFile.getLocation().toFile();
            }
        }
    }

    private IFolder getUnzipRootPath(File file, boolean linkToDefaultLocation) throws CoreException {
        Path path = new Path(file.getAbsolutePath());
        path = new Path(path.lastSegment());
        String resultFolderName = null;
        if (this.fName == null) {
            this.fName = path.removeFileExtension().toOSString();
        }
        resultFolderName = this.fName;
        if (linkToDefaultLocation) {
            return ResultsViewUtilities.getProjectLinkedFolder(resultFolderName);
        }
        return ResultsViewUtilities.getProjectUnzipFolder(resultFolderName);
    }

    public static enum COVERAGE_TYPE {
        CCDATA,
        CCRAW,
        INVALID;

    }
}

