/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.utilities;

import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.ICCSource;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.ReportCcsServerFactory;
import com.ibm.debug.pdt.codecoverage.ui.CCResultsViewException;
import com.ibm.debug.pdt.codecoverage.ui.ICCResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class ReportUtilities {
    private static Map<String, Boolean> fProjectCache = new HashMap<String, Boolean>();

    public static String covertDateFormat(Long millisecond) {
        return DateFormat.getDateTimeInstance(2, 2, Locale.getDefault()).format(new Date(millisecond));
    }

    public static ICCResult excludeZeroLines(ICCResult iccResult) {
        iccResult.clearFilters();
        iccResult.addFilter((byte)1, new String[0]);
        return iccResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetSourceAvailableCache() {
        Map<String, Boolean> map = fProjectCache;
        synchronized (map) {
            fProjectCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSourceAvailable(ICCSource srcItem) {
        if (srcItem.isSourceAvailable()) {
            return true;
        }
        String projectName = (String)srcItem.getProperty("project");
        if (projectName == null || projectName.isEmpty()) {
            return false;
        }
        Map<String, Boolean> map = fProjectCache;
        synchronized (map) {
            if (fProjectCache.containsKey(projectName)) {
                return fProjectCache.get(projectName);
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project != null) {
                fProjectCache.put(projectName, project.isAccessible());
                return fProjectCache.get(projectName);
            }
        }
        return false;
    }

    public static String encodeString(String originalInput) {
        return Base64.getEncoder().encodeToString(originalInput.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static String decodeString(String originalInput) {
        return new String(Base64.getDecoder().decode(originalInput), StandardCharsets.ISO_8859_1);
    }

    public static void openResult(IResultAdapter adapter) {
        if (adapter.isResultAvailable()) {
            try {
                ReportCcsServerFactory.getInstance().openReport((ICCResultAdapter)adapter);
            }
            catch (CCResultsViewException cCResultsViewException) {
                // empty catch block
            }
        }
    }
}

