/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.RSECoveragePlugin;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class RemoteResultUtilities
implements IResultViewConstants {
    public static void deleteRemoteFile(final IRemoteFile remoteFile) {
        Job j = new Job(Labels.DELETE_RESULT){

            protected IStatus run(IProgressMonitor monitor) {
                IRemoteFileSubSystem subsystem = remoteFile.getParentRemoteFileSubSystem();
                try {
                    subsystem.delete(remoteFile, monitor);
                }
                catch (SystemMessageException sme) {
                    RSECoveragePlugin.log(sme);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return new Status(4, "com.ibm.debug.pdt.codecoverage.ui.view.rse", sme.getSystemMessage().getLevelOneText());
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family.equals("DeleteResultJob");
            }
        };
        j.schedule();
    }

    public static String renameFile(IRemoteFile fRemotePath, String newResultName) {
        IRemoteFileSubSystem subsystem = fRemotePath.getParentRemoteFileSubSystem();
        try {
            subsystem.rename(fRemotePath, newResultName, null);
            return null;
        }
        catch (SystemMessageException ex) {
            RSECoveragePlugin.log(ex);
            return ex.getSystemMessage().getLevelOneText();
        }
    }

    public static String downloadAndGetLocalFile(final IRemoteFile remoteFile) {
        Job j = new Job(Labels.DOWNLOAD_RESULT){

            protected IStatus run(IProgressMonitor monitor) {
                UniversalFileTransferUtility.downloadResourceToWorkspace((IRemoteFile)remoteFile, (IProgressMonitor)monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        try {
            j.join();
        }
        catch (InterruptedException e) {
            RSECoveragePlugin.log(e);
        }
        return remoteFile.getFile() == null ? null : ((File)remoteFile.getFile()).getAbsolutePath();
    }
}

