/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote;

import com.ibm.debug.pdt.codecoverage.internal.core.results.exporters.ccresults.CCResultExporter;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote.RemoteResultUtilities;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCAPIResultAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;

public class RemoteCCAPIResultAdapter
extends CCAPIResultAdapter {
    private IRemoteFile fRemoteFile;
    private String fLocalPath;
    private boolean fIsInitialized = false;

    public RemoteCCAPIResultAdapter(IRemoteFile remoteFile) {
        super(remoteFile.getAbsolutePathPlusConnection());
        this.fRemoteFile = remoteFile;
        this.fIsInitialized = true;
    }

    public String getLocalPath() {
        if (this.fIsInitialized && this.fLocalPath == null) {
            this.fLocalPath = RemoteResultUtilities.downloadAndGetLocalFile(this.fRemoteFile);
        }
        return this.fLocalPath;
    }

    public boolean exists() {
        return this.fRemoteFile.exists();
    }

    public String rename(String newResultName) {
        String errorMsg = super.rename(newResultName);
        if (errorMsg == null) {
            errorMsg = RemoteResultUtilities.renameFile(this.fRemoteFile, newResultName + CCResultExporter.getExtension());
        }
        return errorMsg;
    }

    public void cleanup(boolean deleteDataFiles) {
        super.cleanup(deleteDataFiles);
        if (deleteDataFiles) {
            RemoteResultUtilities.deleteRemoteFile(this.fRemoteFile);
        }
    }
}

