/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote;

import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.RSECoveragePlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote.IAlternateRemoteResultProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;

public class AlternateRemoteResults {
    private static final List<IAlternateRemoteResultProvider> fContentProviders = AlternateRemoteResults.getContentProviders();

    private static List<IAlternateRemoteResultProvider> getContentProviders() {
        ArrayList<IAlternateRemoteResultProvider> result = new ArrayList<IAlternateRemoteResultProvider>();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.codecoverage.ui.view.rse.remoteContentSupport");
        if (ep != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = ep.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    IAlternateRemoteResultProvider provider = (IAlternateRemoteResultProvider)config.createExecutableExtension("class");
                    result.add(provider);
                }
                catch (CoreException e) {
                    RSECoveragePlugin.log(e);
                }
                catch (ClassCastException e) {
                    RSECoveragePlugin.log(e);
                }
                ++n2;
            }
        }
        return result;
    }

    public static IResultAdapter getResultAdapter(String locationPath) {
        for (IAlternateRemoteResultProvider provider : fContentProviders) {
            IResultAdapter adapter = provider.getResultAdapter(locationPath);
            if (adapter == null) continue;
            return adapter;
        }
        return null;
    }

    public static boolean isSupportedExtension(String extension) {
        for (IAlternateRemoteResultProvider provider : fContentProviders) {
            if (!provider.isSupportedExtension(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasResultsToImport(IRemoteFile remoteFile) {
        for (IAlternateRemoteResultProvider provider : fContentProviders) {
            if (!provider.hasResultsToImport(remoteFile)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidRemoteResult(IRemoteFile remoteFile) {
        for (IAlternateRemoteResultProvider provider : fContentProviders) {
            if (!provider.isValidRemoteResult(remoteFile)) continue;
            return true;
        }
        return false;
    }

    public static IResultAdapter getResultAdapter(IRemoteFile remoteFile) {
        for (IAlternateRemoteResultProvider provider : fContentProviders) {
            IResultAdapter adapter = provider.getResultAdapter(remoteFile);
            if (adapter == null) continue;
            return adapter;
        }
        return null;
    }
}

