/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.rse;

import com.ibm.debug.pdt.codecoverage.internal.core.results.XMLUtils;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.RSECoveragePlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.RemoteException;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileEncodingManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CLRemoteUtilities {
    static final String ELEMENT_LLC = "LLC";
    static final String ATTR_VIEWFILE_FOLDER = "viewFileFolder";

    public static IFile downloadRemoteFile(IRemoteFile remoteFile) {
        String fileName = remoteFile.getName();
        if (!fileName.endsWith("zip")) {
            RemoteFileEncodingManager mgr = RemoteFileEncodingManager.getInstance();
            String hostname = remoteFile.getHost().getHostName();
            mgr.setEncoding(hostname, remoteFile.getAbsolutePath(), "UTF-8");
        }
        return (IFile)UniversalFileTransferUtility.downloadResourceToWorkspace((IRemoteFile)remoteFile, null);
    }

    public static IFile copyRemoteFilesToCCRSETempLocation(IFile remoteTempFile, IFile[] dataFiles, IFolder remoteSourceFolder) {
        return CLRemoteUtilities.copyRemoteFilesToCCRSETempLocation(remoteTempFile, dataFiles, remoteSourceFolder, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IFile copyRemoteFilesToCCRSETempLocation(IFile remoteTempFile, IFile[] dataFiles, IFolder remoteSourceFolder, IProgressMonitor monitor) {
        try {
            monitor.beginTask("", 10 * dataFiles.length + 20);
            IFolder folder = ResultsViewUtilities.getProjectLinkedFolder((String)new Path(remoteTempFile.getName()).removeFileExtension().toString());
            CLRemoteUtilities.copyRemoteResource((IResource)remoteTempFile, folder);
            monitor.worked(10);
            remoteTempFile = folder.getFile((IPath)new Path(remoteTempFile.getName()));
            if (remoteTempFile != null) {
                IFile[] iFileArray = dataFiles;
                int n = dataFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile f = iFileArray[n2];
                    CLRemoteUtilities.copyRemoteResource((IResource)f, folder);
                    monitor.worked(10);
                    ++n2;
                }
            }
            if (remoteSourceFolder != null) {
                CLRemoteUtilities.copyRemoteResource((IResource)remoteSourceFolder, folder);
                monitor.worked(10);
                try {
                    CLRemoteUtilities.resetViewFileFolder(remoteTempFile.getLocation().toFile(), null, false);
                }
                catch (Exception ex) {
                    RSECoveragePlugin.log(ex);
                }
            }
        }
        catch (CoreException e) {
            RSECoveragePlugin.log(e);
            return null;
        }
        monitor.done();
        return remoteTempFile;
    }

    private static IResource copyRemoteResource(IResource local, IFolder folder) {
        if (folder != null) {
            try {
                String fileName = local.getName();
                IResource result = folder.findMember(fileName);
                if (result != null && result.exists()) {
                    result.delete(false, (IProgressMonitor)new NullProgressMonitor());
                }
                IPath newPath = folder.getFullPath();
                newPath = newPath.append(fileName);
                local.copy(newPath, false, (IProgressMonitor)new NullProgressMonitor());
                return folder.findMember(fileName);
            }
            catch (CoreException e) {
                RSECoveragePlugin.log(e);
            }
        }
        return local;
    }

    public static IFile[] downloadOtherDataFiles(IRemoteFile remoteDataFile) {
        String dataFileName;
        String baseName = dataFileName = remoteDataFile.getName();
        int suffixIndex = dataFileName.lastIndexOf(".clcoveragedata");
        if (suffixIndex > 0) {
            baseName = dataFileName.substring(0, suffixIndex);
        }
        IFile[] otherFiles = new IFile[4];
        IRemoteFile parent = remoteDataFile.getParentRemoteFile();
        IRemoteFileSubSystem subsystem = remoteDataFile.getParentRemoteFileSubSystem();
        try {
            IRemoteFile[] children;
            IRemoteFile[] iRemoteFileArray = children = subsystem.list(parent, 1, null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IRemoteFile child = iRemoteFileArray[n2];
                String fileName = child.getName();
                suffixIndex = fileName.lastIndexOf(46);
                if (suffixIndex > 0) {
                    String aBaseName = fileName.substring(0, suffixIndex);
                    String extensionName = fileName.substring(suffixIndex);
                    if (aBaseName.equals(baseName)) {
                        if (extensionName.equals(".metadata")) {
                            otherFiles[0] = CLRemoteUtilities.downloadRemoteFile(child);
                        } else if (extensionName.equals(".componentMap")) {
                            otherFiles[1] = CLRemoteUtilities.downloadRemoteFile(child);
                        } else if (extensionName.equals("info.properties")) {
                            otherFiles[2] = CLRemoteUtilities.downloadRemoteFile(child);
                        } else if (extensionName.equals(".metadata")) {
                            otherFiles[3] = CLRemoteUtilities.downloadRemoteFile(child);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (SystemMessageException sme) {
            RSECoveragePlugin.log(sme);
        }
        return otherFiles;
    }

    public static IFolder downloadSource(IRemoteFile resultDir) {
        IRemoteFileSubSystem subsystem = resultDir.getParentRemoteFileSubSystem();
        IFolder localSourceFolder = null;
        try {
            IRemoteFile[] folders;
            IRemoteFile[] iRemoteFileArray = folders = subsystem.list(resultDir, 2, null);
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                IRemoteFile folder = iRemoteFileArray[n2];
                if (folder.getName().equals("src")) {
                    localSourceFolder = CLRemoteUtilities.downloadFolder(folder);
                    break;
                }
                ++n2;
            }
        }
        catch (SystemMessageException sme) {
            RSECoveragePlugin.log(sme);
        }
        return localSourceFolder;
    }

    public static IFolder downloadFolder(IRemoteFile folder) {
        IFolder localSourceFolder = null;
        IRemoteFileSubSystem subsystem = folder.getParentRemoteFileSubSystem();
        try {
            IRemoteFile[] srcFiles;
            IRemoteFile[] iRemoteFileArray = srcFiles = subsystem.list(folder, 0, null);
            int n = srcFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IRemoteFile srcFile = iRemoteFileArray[n2];
                Object localfile = null;
                localfile = srcFile.isDirectory() ? CLRemoteUtilities.downloadFolder(srcFile) : CLRemoteUtilities.downloadRemoteFile(srcFile);
                if (localSourceFolder == null) {
                    localSourceFolder = (IFolder)localfile.getParent();
                }
                ++n2;
            }
        }
        catch (SystemMessageException sme) {
            RSECoveragePlugin.log(sme);
        }
        return localSourceFolder;
    }

    public static IRemoteFile resolveRemotePath(String profileName, String connectionName, String pathname, boolean onlyResolveWhenConnected, boolean retry) throws RemoteException {
        return CLRemoteUtilities.resolveRemotePath(profileName, connectionName, pathname, onlyResolveWhenConnected, retry, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRemoteFile resolveRemotePath(String profileName, String connectionName, String pathname, boolean onlyResolveWhenConnected, boolean retry, boolean ensureDirectory) throws RemoteException {
        ISubSystem[] subsystems;
        ISystemRegistry registry = RSECorePlugin.getDefault().getSystemRegistry();
        ISystemProfile profile = registry.getSystemProfile(profileName);
        if (profile == null) throw new RemoteException(NLS.bind((String)Labels.RSE_PROFILE_NOT_FOUND, (Object)profileName), 1);
        IHost host = registry.getHost(profile, connectionName);
        IRemoteFileSubSystem fileSubsystem = null;
        if (host == null) throw new RemoteException(NLS.bind((String)Labels.RSE_CONNECTION_NOT_FOUND, (Object)connectionName), 2);
        ISubSystem[] iSubSystemArray = subsystems = host.getSubSystems();
        int n = subsystems.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem subsystem = iSubSystemArray[n2];
            if (subsystem instanceof IRemoteFileSubSystem) {
                fileSubsystem = (IRemoteFileSubSystem)subsystem;
                break;
            }
            ++n2;
        }
        if (fileSubsystem == null) return null;
        if (!onlyResolveWhenConnected) return CLRemoteUtilities.getRemoteFileFromPath(fileSubsystem, pathname, retry, ensureDirectory);
        if (fileSubsystem.isConnected()) return CLRemoteUtilities.getRemoteFileFromPath(fileSubsystem, pathname, retry, ensureDirectory);
        return null;
    }

    private static IRemoteFile getRemoteFileFromPath(IRemoteFileSubSystem fileSubsystem, String pathname, boolean retry, boolean ensureDirectory) throws RemoteException {
        IRemoteFile remoteFile = null;
        int maxRetry = 5;
        int retryCount = 0;
        boolean invalidRemotePath = false;
        do {
            try {
                remoteFile = fileSubsystem.getRemoteFileObject(pathname, (IProgressMonitor)new NullProgressMonitor());
                if (remoteFile != null && remoteFile.exists()) {
                    if (remoteFile.isDirectory() || !ensureDirectory) {
                        return remoteFile;
                    }
                    throw new RemoteException(NLS.bind((String)Labels.REMOTE_PATH_NOT_A_DIRECTORY, (Object)pathname), 4);
                }
                invalidRemotePath = true;
            }
            catch (SystemMessageException ex) {
                throw new RemoteException(ex);
            }
            if (!retry) continue;
            ++retryCount;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (retry && retryCount < maxRetry && invalidRemotePath);
        if (invalidRemotePath) {
            throw new RemoteException(NLS.bind((String)Labels.INVALID_REMOTE_PATH_ON_HOST, (Object[])new Object[]{pathname, fileSubsystem.getHost().getHostName()}), 3);
        }
        return null;
    }

    public static IRemoteFile resolveRemotePath(String remotePath) throws RemoteException {
        return CLRemoteUtilities.resolveRemotePath(remotePath, false, false);
    }

    public static IRemoteFile resolveRemotePath(String remotePath, boolean onlyResolveWhenConnected, boolean retry) throws RemoteException {
        return CLRemoteUtilities.resolveRemotePath(remotePath, onlyResolveWhenConnected, retry, true);
    }

    public static IRemoteFile resolveRemotePath(String remotePath, boolean onlyResolveWhenConnected, boolean retry, boolean ensureConnected) throws RemoteException {
        int dotIndex = remotePath.indexOf(46);
        if (dotIndex > 0) {
            String profileName = remotePath.substring(0, dotIndex);
            int colonIndex = remotePath.indexOf(58, dotIndex + 1);
            if (colonIndex > 0) {
                String connectionName = remotePath.substring(dotIndex + 1, colonIndex);
                String pathname = remotePath.substring(colonIndex + 1);
                return CLRemoteUtilities.resolveRemotePath(profileName, connectionName, pathname, onlyResolveWhenConnected, retry, ensureConnected);
            }
        }
        return null;
    }

    public static void uploadFileRemote(String localFilePath, IRemoteFile remoteDir, IHost host) throws RemoteException {
        Object result = UniversalFileTransferUtility.downloadResourceToWorkspace((File)new File(localFilePath), null);
        if (result != null && result instanceof IFile) {
            IFile tempFile = (IFile)result;
            Object uploadResult = UniversalFileTransferUtility.uploadResourceFromWorkspace((IResource)tempFile, (IRemoteFile)remoteDir, null);
            if (uploadResult == null) {
                throw new RemoteException(CCResultViewMessages.CRRDG9324);
            }
        } else {
            throw new RemoteException(CCResultViewMessages.CRRDG9325);
        }
    }

    public static void resetViewFileFolder(File dataFile, String newValue, boolean prepend) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        DocumentBuilder docBuilder = XMLUtils.getSecureDocumentBuilderFactory().newDocumentBuilder();
        Document doc = docBuilder.parse(dataFile);
        Element rootElement = doc.getDocumentElement();
        if (rootElement.getNodeName().equals(ELEMENT_LLC)) {
            if (prepend) {
                Object viewFileFolder = rootElement.getAttribute(ATTR_VIEWFILE_FOLDER);
                viewFileFolder = newValue + (String)viewFileFolder;
                rootElement.setAttribute(ATTR_VIEWFILE_FOLDER, (String)viewFileFolder);
            } else if (newValue == null) {
                rootElement.removeAttribute(ATTR_VIEWFILE_FOLDER);
            } else {
                rootElement.setAttribute(ATTR_VIEWFILE_FOLDER, newValue);
            }
        }
        Transformer xformer = XMLUtils.getSecureTransformerFactory().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        FileOutputStream fos = new FileOutputStream(dataFile);
        StreamResult result = new StreamResult(fos);
        DOMSource source = new DOMSource(doc);
        xformer.transform(source, result);
        fos.close();
    }

    public static String getConnectionFromPath(String remotePath) {
        int colonIndex;
        int dotIndex = remotePath.indexOf(46);
        if (dotIndex > 0 && (colonIndex = remotePath.indexOf(58, dotIndex + 1)) > 0) {
            String connectionName = remotePath.substring(dotIndex + 1, colonIndex);
            return connectionName;
        }
        return null;
    }

    public static String getProfileFromPath(String remotePath) {
        int dotIndex = remotePath.indexOf(46);
        if (dotIndex > 0) {
            return remotePath.substring(0, dotIndex);
        }
        return null;
    }

    public static Job getRSEViewConnectJob() {
        Job[] jobs;
        Job[] jobArray = jobs = Job.getJobManager().find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job.getName().equalsIgnoreCase("connect")) {
                return job;
            }
            ++n2;
        }
        return null;
    }
}

