/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.internal.launch;

import com.ibm.debug.pdt.codecoverage.core.results.ICCConstants;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CCLaunchUtils;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CodeCoverageCompositeListener;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CodeCoverageLaunchComposite;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.Labels;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class CodeCoverageLaunchConfigTab
extends AbstractLaunchConfigurationTab
implements CodeCoverageCompositeListener {
    private static String CC_LAUNCH_CONFIG_PAGE = "com.ibm.debug.pdt.codecoverage.ui.launch.cclaunch_settings_page";
    private CodeCoverageLaunchComposite fCoverageComposite;

    public void createControl(Composite parent) {
        this.setDirty(false);
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        this.fCoverageComposite = this.getCoverageLaunchComposite(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fCoverageComposite);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fCoverageComposite, CC_LAUNCH_CONFIG_PAGE);
    }

    protected CodeCoverageLaunchComposite getCoverageLaunchComposite(Composite parent) {
        return new CodeCoverageLaunchComposite(parent, 0, this);
    }

    protected void updateLaunchConfigurationDialog() {
        this.setErrorMessage(null);
        if (this.fCoverageComposite != null) {
            this.fCoverageComposite.validateFields();
            this.setErrorMessage(this.fCoverageComposite.getErrorMessage());
        }
        this.getLaunchConfigurationDialog().updateMessage();
        super.updateLaunchConfigurationDialog();
    }

    public String getName() {
        return Labels.CodeCoverageTab_tabName;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.initializeResults(configuration);
            this.initializeCoverageLevel(configuration);
            this.initializeOptions(configuration);
        }
        catch (CoreException e) {
            CCLaunchUtils.log(1, "failed to get code coverage attribute; will use default", e);
        }
        this.updateLaunchConfigurationDialog();
    }

    private void initializeOptions(ILaunchConfiguration configuration) throws CoreException {
        if (this.fCoverageComposite != null) {
            this.fCoverageComposite.initializeOptions(configuration.getAttribute("ignoreerrors", false), configuration.getAttribute("testid", ""), configuration.getAttribute("tag", ""), configuration.getAttribute("root", ""), configuration.getAttribute("ccGeneratePDF", false));
        }
    }

    private void initializeResults(ILaunchConfiguration configuration) throws CoreException {
        if (this.fCoverageComposite != null) {
            this.fCoverageComposite.initializeFilter(configuration.getAttribute("ccFilterList", false), this.retrieveFilterListPath(configuration));
        }
    }

    private String retrieveFilterListPath(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.hasAttribute("ccFilterListPath") && !configuration.getAttribute("ccFilterListPath", "").isEmpty()) {
            return configuration.getAttribute("ccFilterListPath", "");
        }
        if (configuration.hasAttribute("ccFilterListPathV2")) {
            return configuration.getAttribute("ccFilterListPathV2", "");
        }
        return "";
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fCoverageComposite != null) {
            this.fCoverageComposite.applyToConfiguration(configuration);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("ignoreerrors", false);
        configuration.setAttribute("ccGeneratePDF", false);
        configuration.setAttribute("testid", "");
        configuration.setAttribute("tag", "");
        configuration.setAttribute("CODE_COVERAGE_LEVEL", ICCConstants.COVERAGE_LEVEL.LINE.toString());
        configuration.removeAttribute("ccFilterListPath");
        configuration.setAttribute("ccFilterListPathV2", "");
        configuration.setAttribute("ccFilterList", false);
    }

    public boolean canSave() {
        return this.getErrorMessage() == null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    private void initializeCoverageLevel(ILaunchConfiguration configuration) throws CoreException {
        if (this.fCoverageComposite != null) {
            this.fCoverageComposite.initializeLevel(configuration.getAttribute("CODE_COVERAGE_LEVEL", ICCConstants.COVERAGE_LEVEL.LINE.toString()));
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    public void widgetSelected(SelectionEvent arg0) {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    public void modifyText(ModifyEvent arg0) {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }
}

