/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.internal.launch;

import com.ibm.commoncomponents.codecoverage.core.exporters.events.FopEventListener;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporterInfo;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporterSettings;
import com.ibm.debug.pdt.codecoverage.internal.core.CCData;
import com.ibm.debug.pdt.codecoverage.internal.core.CCParams;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.Messages;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCollectionEnd;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCollectionStart;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventComplete;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCoverageChange;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventError;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventReportEnd;
import com.ibm.debug.pdt.codecoverage.internal.core.events.ICCListener;
import com.ibm.debug.pdt.codecoverage.internal.core.exporter.cobertura.CCCoberturaExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.exporter.pdf.CCPdfExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.exporter.pdf.CCPdfExporterSettings;
import com.ibm.debug.pdt.codecoverage.internal.core.results.exporters.sonar.CCSonarQubeExporter;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.Labels;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.fop.events.EventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class CLCodeCoverageReportListener
implements ICCListener {
    private static final String PDF_EXTENSION = ".pdf";

    public void collectionStart(CCEventCollectionStart event) {
    }

    public void collectionEnd(final CCEventCollectionEnd event) {
        final CCData data = event.getData();
        if (!data.isExporterType()) {
            return;
        }
        final File result = event.getFile();
        try {
            final String[] exporters = data.getExporterTypes();
            boolean singleReport = exporters.length == 1;
            final String label = NLS.bind((String)(singleReport ? Labels.CoverageJobLabel_generating_report : Labels.CoverageJobLabel_generating_reports), (Object)event.getProgramName());
            Job job = new Job(label){

                public IStatus run(IProgressMonitor monitor) {
                    String outputPath = String.valueOf(data.getOutputDir()) + File.separator + data.getResultsName() + "E";
                    String[] inputPaths = new String[]{result.getAbsolutePath()};
                    ICCResult results = null;
                    try {
                        monitor.beginTask(label, exporters.length * 2);
                        results = CCResultsFactory.getInstance().createResult(inputPaths);
                        String[] stringArray = exporters;
                        int n = exporters.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String exporterType = stringArray[n2];
                            monitor.worked(1);
                            switch (exporterType) {
                                case "PDF": 
                                case "CCPDF": {
                                    monitor.setTaskName(NLS.bind((String)Labels.CoverageJobLabel_open_pdf_coverage_report, (Object)event.getProgramName()));
                                    CLCodeCoverageReportListener.this.exportPDF(results, "CCPDF", outputPath, data);
                                    break;
                                }
                                case "CCSONARQUBE": 
                                case "SQ": {
                                    monitor.setTaskName(NLS.bind((String)Labels.CoverageJobLabel_open_pdf_coverage_report, (Object)event.getProgramName(), (Object)"SonarQube"));
                                    CLCodeCoverageReportListener.this.exportSonarQube(results, "CCSONARQUBE", outputPath, data);
                                    break;
                                }
                                case "CCCOBERTURA": 
                                case "COB": {
                                    monitor.setTaskName(NLS.bind((String)Labels.CoverageJobLabel_open_pdf_coverage_report, (Object)event.getProgramName(), (Object)"Cobertura"));
                                    CLCodeCoverageReportListener.this.exportCobertura(results, "CCCOBERTURA", outputPath, data);
                                    break;
                                }
                            }
                            if (!monitor.isCanceled()) {
                                monitor.worked(1);
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (CCResultException e) {
                        CCUtilities.log((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (CCParams.CCParseException e) {
            CCUtilities.log((Throwable)e);
        }
    }

    private void exportCobertura(ICCResult results, String exporterType, String outputPath, CCData data) {
        CCExporterFactory.getInstance().registerExporter((ICCExporter)new CCCoberturaExporter(), exporterType);
        this.exportResult(results, exporterType, outputPath, data, true, null, true);
    }

    private void exportSonarQube(ICCResult results, String exporterType, String outputPath, CCData data) {
        CCExporterFactory.getInstance().registerExporter((ICCExporter)new CCSonarQubeExporter(), exporterType);
        this.exportResult(results, exporterType, outputPath, data, true, null, true);
    }

    private void exportPDF(ICCResult results, String exporterType, final String outputPath, CCData data) {
        CCExporterFactory.getInstance().registerExporter((ICCExporter)new CCPdfExporter(), exporterType);
        CCPdfExporterSettings settings = new CCPdfExporterSettings();
        FopEventListener fopEventListener = new FopEventListener();
        settings.setListener((EventListener)fopEventListener);
        settings.setReportOption("pdf");
        if (data.isSaveSource()) {
            settings.setIncludeSource("true");
        }
        this.exportResult(results, exporterType, outputPath + PDF_EXTENSION, data, false, (ICCExporterSettings)settings, false);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (URI)new File(outputPath + CLCodeCoverageReportListener.PDF_EXTENSION).toURI(), (String)"org.eclipse.ui.systemExternalEditor", (boolean)true);
                }
                catch (PartInitException e) {
                    CCUtilities.log((Throwable)e);
                }
            }
        });
    }

    private void exportResult(ICCResult results, String exporterType, String outputPath, CCData data, boolean createInSubDir, ICCExporterSettings settings, boolean displayMessage) {
        if (createInSubDir) {
            String outputDirPath = null;
            try {
                outputDirPath = new File((String)outputPath).getParent() + File.separator + data.getResultsName() + "_" + exporterType;
                File resultDir = new File(outputDirPath);
                if (!resultDir.exists()) {
                    Files.createDirectory(resultDir.toPath(), new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                CCUtilities.log((Throwable)e);
                return;
            }
            outputPath = outputDirPath + File.separator + data.getResultsName() + "_" + exporterType;
        }
        try {
            ICCExporter exporter = CCExporterFactory.getInstance().getExporter(exporterType);
            ICCExporterInfo info = exporter.exportResult(results, settings, (String)outputPath, true);
            if (displayMessage) {
                PICLDebugPlugin.showMessageDialog(null, (int)2, (String)Labels.Coverage_report_dialog_title, (String)NLS.bind((String)Messages.CRRDG7109, (Object)info.getDestination()), (boolean)false);
            }
        }
        catch (CCExportException e) {
            CCUtilities.log((Throwable)e);
        }
    }

    public void error(CCEventError event) {
    }

    public void reportEnd(CCEventReportEnd event) {
    }

    public void complete(CCEventComplete event) {
    }

    public void coverageChanged(CCEventCoverageChange event) {
    }
}

