/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.internal.launch;

import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.Messages;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCollectionEnd;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCollectionStart;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventComplete;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCoverageChange;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventError;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventReportEnd;
import com.ibm.debug.pdt.codecoverage.internal.core.events.ICCListener;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.utilities.ReportUtilities;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.Labels;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.UIJob;

public class CLCodeCoverageListener
implements ICCListener {
    private HashMap<String, CoverageSession> coverageSessions = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectionStart(CCEventCollectionStart event) {
        CodeCoverageStatusJob statusJob = null;
        String programName = event.getProgramName();
        String targetId = ((IPDTDebugTarget)event.getDebugTarget()).getId();
        statusJob = programName != null && programName.trim().length() > 0 ? new CodeCoverageStatusJob(programName, targetId) : new CodeCoverageStatusJob("Unknown", targetId);
        CoverageSession thisSession = new CoverageSession(event.getDebugTarget(), statusJob);
        HashMap<String, CoverageSession> hashMap = this.coverageSessions;
        synchronized (hashMap) {
            this.coverageSessions.put(targetId, thisSession);
        }
        statusJob.schedule();
    }

    public void collectionEnd(final CCEventCollectionEnd event) {
        this.cancelStatusJob(((IPDTDebugTarget)event.getDebugTarget()).getId());
        String label = NLS.bind((String)Labels.CoverageJobLabel_open_coverage_report, (Object)event.getProgramName());
        UIJob job = new UIJob(label){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ResultsViewUtilities.showCodeCoverageResultsView();
                IResultAdapter adapter = ResultsViewUtilities.addCCZipResult((String)event.getFile().getPath(), (boolean)true);
                ReportUtilities.openResult((IResultAdapter)adapter);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void error(CCEventError event) {
        this.cancelStatusJob(((IPDTDebugTarget)event.getDebugTarget()).getId());
        PICLUtils.logString(null, (String)event.getErrorMessage(), (int)2);
        String errorMessage = event.getErrorMessage();
        if (!(errorMessage == null || errorMessage.equals(Messages.CRRDG7033) && event.getData().isZunit())) {
            PICLDebugPlugin.showMessageDialog(null, (int)4, (String)com.ibm.debug.pdt.codecoverage.internal.core.Labels.CCMessageTitle, (String)event.getErrorMessage(), (boolean)false);
        }
    }

    public void reportEnd(CCEventReportEnd event) {
        this.cancelStatusJob(((IPDTDebugTarget)event.getDebugTarget()).getId());
    }

    public void complete(CCEventComplete event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelStatusJob(String debugTargetID) {
        CodeCoverageStatusJob thisStatusJob;
        CoverageSession thisSession = null;
        HashMap<String, CoverageSession> hashMap = this.coverageSessions;
        synchronized (hashMap) {
            thisSession = this.coverageSessions.get(debugTargetID);
            if (thisSession != null) {
                this.coverageSessions.remove(debugTargetID);
            }
        }
        if (thisSession != null && (thisStatusJob = thisSession.fStatusJob) != null) {
            thisStatusJob.setDone(true);
        }
    }

    public void coverageChanged(CCEventCoverageChange event) {
    }

    private class CodeCoverageStatusJob
    extends Job {
        private boolean fDone;
        private String fTargetID;

        public CodeCoverageStatusJob(String programName, String targetID) {
            super(NLS.bind((String)Labels.CoverageProgressJobLabel, (Object)programName));
            this.fDone = false;
            this.fTargetID = null;
            this.fTargetID = targetID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected IStatus run(IProgressMonitor monitor) {
            thisSession = null;
            var3_3 = CLCodeCoverageListener.this.coverageSessions;
            synchronized (var3_3) {
                thisSession = CLCodeCoverageListener.this.coverageSessions.get(this.fTargetID);
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
                if (true) ** GOTO lbl25
            }
            do {
                try {
                    if (thisSession == null) break;
                    thisTarget = thisSession.fDebugTarget;
                    if (monitor.isCanceled()) {
                        thisTarget.terminate();
                        break;
                    }
                    if (thisTarget == null || thisTarget.isTerminated()) break;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    CCUtilities.log((Throwable)e);
                }
                catch (DebugException e) {
                    CCUtilities.log((Throwable)e);
                }
lbl25:
                // 4 sources

            } while (!this.fDone);
            return Status.OK_STATUS;
        }

        public void setDone(boolean done) {
            this.fDone = done;
        }
    }

    private static class CoverageSession {
        private IDebugTarget fDebugTarget;
        private CodeCoverageStatusJob fStatusJob;

        CoverageSession(IDebugTarget debugTarget, CodeCoverageStatusJob statusJob) {
            this.fDebugTarget = debugTarget;
            this.fStatusJob = statusJob;
        }
    }
}

