/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.dcc;

import com.ibm.debug.pdt.codecoverage.core.results.importers.CCImportException;
import com.ibm.debug.pdt.codecoverage.internal.core.CCData;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.ICCCoreConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.DCCPartListener;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.dialog.DCCSetParametersDialog;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.model.DCCData;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.model.DCCDebugEngineEventListener;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.model.DCCParams;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.model.DCCProcessEventListener;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IDebugEngineEventListener;
import com.ibm.debug.pdt.internal.core.model.IProcessEventListener;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqStartCC;
import com.ibm.debug.pdt.internal.epdc.EReqStopCC;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class DCCUtilities {
    private Map<PDTDebugTarget, DCCData> fCCDebugTargetMap = new HashMap<PDTDebugTarget, DCCData>();
    private Map<PDTDebugTarget, Set<ViewFile>> fLoadEntireFileMap = new HashMap<PDTDebugTarget, Set<ViewFile>>();
    private static DCCUtilities fInstance = new DCCUtilities();
    private DCCPartListener fListener = new DCCPartListener();

    private DCCUtilities() {
    }

    public static DCCUtilities getInstance() {
        return fInstance;
    }

    public EPDC_Reply startCC(Shell shell, PDTDebugTarget debugTarget) throws DebugException {
        IEditorInput editorInput;
        ITextEditor activeEditor;
        String testID = (String)debugTarget.getProperty("com.ibm.debug.pdt.codecoverage.ui.dcc.TEST_ID");
        String tags = (String)debugTarget.getProperty("com.ibm.debug.pdt.codecoverage.ui.dcc.TAGS");
        ICCCoreConstants.DESIRED_COVERAGE_VIEW ccView = DCCUtilities.getCodeCoverageView(debugTarget);
        if (testID == null) {
            DCCSetParametersDialog dialog = new DCCSetParametersDialog(shell, ((DebuggeeProcess)debugTarget.getProcess()).getQualifiedName());
            int retCode = dialog.open();
            if (retCode == 1) {
                return null;
            }
            testID = dialog.getTestID();
            tags = dialog.getTags();
            debugTarget.setProperty("com.ibm.debug.pdt.codecoverage.ui.dcc.TEST_ID", (Object)testID);
            if (!tags.isEmpty()) {
                debugTarget.setProperty("com.ibm.debug.pdt.codecoverage.ui.dcc.TAGS", (Object)tags);
            }
            DCCParams params = new DCCParams(ccView, testID, tags);
            DCCData dccData = new DCCData(params);
            dccData.initTimer();
            DebuggeeProcess process = (DebuggeeProcess)debugTarget.getProcess();
            dccData.setPgmName(process.getQualifiedName());
            dccData.setDebugTarget((IPDTDebugTarget)debugTarget);
            dccData.initialize(debugTarget.getDebugEngine());
            this.fCCDebugTargetMap.put(debugTarget, dccData);
            this.fListener.registerPartListener();
            DCCUtilities.createDCCModel(debugTarget, dccData);
        }
        if ((activeEditor = DCCUtilities.getActiveTextEditor()) != null && (editorInput = activeEditor.getEditorInput()) instanceof EngineSuppliedViewEditorInput && activeEditor instanceof DebuggerEditor) {
            this.loadEntireFile((DebuggerEditor)activeEditor, (EngineSuppliedViewEditorInput)editorInput, debugTarget);
        }
        int view = switch (ccView) {
            case ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY -> 3;
            case ICCCoreConstants.DESIRED_COVERAGE_VIEW.LISTING_ONLY -> 2;
            case ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_LISTING -> 4;
            default -> 1;
        };
        try {
            EReqStartCC request = new EReqStartCC(1, view, null, debugTarget.getEngineSession());
            return debugTarget.getDebugEngine().processRequest((EPDC_Request)request);
        }
        catch (EngineRequestException ex) {
            CCUtilities.log((Throwable)ex);
            return null;
        }
    }

    private boolean isLoadedEntireFile(ViewFile viewFile, PDTDebugTarget debugTarget) {
        Set<ViewFile> viewFiles = this.fLoadEntireFileMap.get(debugTarget);
        if (viewFiles != null) {
            return viewFiles.contains(viewFile);
        }
        return false;
    }

    protected void loadEntireFile(DebuggerEditor debuggerEditor, EngineSuppliedViewEditorInput editorInput, PDTDebugTarget debugTarget) throws DebugException {
        ViewFile viewFile = PICLUtils.getViewFile((IEditorInput)editorInput);
        if (viewFile != null && viewFile.getDebugTarget() == debugTarget && !this.isLoadedEntireFile(viewFile, debugTarget)) {
            int lineNumber = debuggerEditor.getCurrentExecutionPointLineNumber();
            editorInput.loadEntireFile();
            Set<ViewFile> viewFiles = this.fLoadEntireFileMap.get(debugTarget);
            if (viewFiles == null) {
                viewFiles = new HashSet<ViewFile>();
                this.fLoadEntireFileMap.put(debugTarget, viewFiles);
            }
            viewFiles.add(viewFile);
            if (lineNumber >= 0) {
                debuggerEditor.gotoLine(lineNumber, true);
                debuggerEditor.setCurrentExecutionPointLineNumber(lineNumber);
            }
        }
    }

    private static ICCCoreConstants.DESIRED_COVERAGE_VIEW getCodeCoverageView(PDTDebugTarget debugTarget) {
        if (debugTarget.getDebugEngine().getEngineSession().supportsSwitchViewWithMixedCC()) {
            return ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT;
        }
        try {
            ViewFile viewFile;
            DebuggeeThread thread;
            IAdaptable contextElement = DebugUITools.getDebugContext();
            IStackFrame stackFrame = null;
            if (contextElement instanceof IStackFrame) {
                stackFrame = (IStackFrame)contextElement;
            }
            if (stackFrame == null && (thread = debugTarget.getCurrentThread()) != null) {
                stackFrame = thread.getTopStackFrame();
            }
            if (stackFrame != null && stackFrame instanceof StackFrame && (viewFile = ((StackFrame)stackFrame).getViewFile()) != null && viewFile.getView() != null) {
                if (viewFile.getView().isSourceView()) {
                    return ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY;
                }
                if (viewFile.getView().isListingView()) {
                    return ICCCoreConstants.DESIRED_COVERAGE_VIEW.LISTING_ONLY;
                }
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT;
    }

    private static void createDCCModel(PDTDebugTarget debugTarget, DCCData data) {
        Module[] modules;
        DebuggeeProcess process = (DebuggeeProcess)debugTarget.getProcess();
        Module[] moduleArray = modules = process.getModules(false);
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            Part[] parts;
            Module module = moduleArray[n2];
            data.add(module);
            Part[] partArray = parts = module.getParts(false);
            int n3 = parts.length;
            int n4 = 0;
            while (n4 < n3) {
                Part part = partArray[n4];
                try {
                    data.add(part);
                }
                catch (CCImportException e) {
                    if (!(e.getCause() instanceof EngineRequestException)) {
                        CCUtilities.log((Throwable)e);
                    }
                    return;
                }
                ++n4;
            }
            ++n2;
        }
        debugTarget.getDebugEngine().addEventListener((IDebugEngineEventListener)new DCCDebugEngineEventListener((CCData)data));
        process.addEventListener((IProcessEventListener)new DCCProcessEventListener((CCData)data));
    }

    public void stopCC(PDTDebugTarget debugTarget) {
        try {
            EReqStopCC request = new EReqStopCC(debugTarget.getEngineSession());
            debugTarget.getDebugEngine().processRequest((EPDC_Request)request);
        }
        catch (EngineRequestException ex) {
            CCUtilities.log((Throwable)ex);
        }
    }

    public void removeCCDebugTarget(PDTDebugTarget debugTarget) {
        this.fCCDebugTargetMap.remove(debugTarget);
        if (this.fCCDebugTargetMap.isEmpty()) {
            this.fListener.removePartListener();
        }
        this.fLoadEntireFileMap.remove(debugTarget);
    }

    public DCCData getCCData(PDTDebugTarget debugTarget) {
        return this.fCCDebugTargetMap.get(debugTarget);
    }

    private static ITextEditor getActiveTextEditor() {
        IEditorPart activeEditor;
        IWorkbenchPage activePage;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length > 0 && (activePage = windows[0].getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) instanceof ITextEditor) {
            return (ITextEditor)activeEditor;
        }
        return null;
    }
}

