/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.rdz.ui.internal.handlers;

import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.internal.core.results.converters.compiled.dt.DebugToolCodeCoverageConverter;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZip;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZipException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.ConnectLocationFields;
import com.ibm.debug.pdt.codecoverage.rdz.ui.internal.Labels;
import com.ibm.debug.pdt.codecoverage.rdz.ui.internal.handlers.CCImportErrorMessages;
import com.ibm.debug.pdt.codecoverage.rdz.ui.internal.handlers.DTImportLog;
import com.ibm.debug.pdt.codecoverage.rdz.ui.internal.handlers.PDSSelectionDialog;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.resources.core.physical.util.OperationFailedException;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSCatalog;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSequentialDataSet;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class DTImportWizardPage
extends WizardPage {
    private static final String SEQ_DS = ".seqDS";
    private IResultLocation fLocation;
    private IDialogSettings fDialogSettings;
    private ConnectLocationFields fConnectionInfo;

    protected DTImportWizardPage(IResultLocation location) {
        super("com.ibm.debug.pdt.codecoverage.rdz.ui.dt.importResult");
        this.fLocation = location;
        this.setTitle(Labels.IMPORT_TITLE);
        this.setDescription(Labels.IMPORT_DESCRIPTION);
    }

    public void createControl(Composite composite) {
        Composite scrollParent = new Composite(composite, 0);
        scrollParent.setLayout((Layout)new FillLayout());
        scrollParent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(1, 1).create());
        ScrolledComposite sc = new ScrolledComposite(scrollParent, 768);
        Composite mainComposite = new Composite((Composite)sc, 0);
        GridLayoutFactory.swtDefaults().applyTo(mainComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        Composite coverageContainer = new Composite(mainComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(coverageContainer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)coverageContainer);
        this.fDialogSettings = this.getWizard().getDialogSettings();
        this.fConnectionInfo = new ConnectLocationFields(coverageContainer, this.getShell(), this.fDialogSettings, com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels.COVERAGEIMPORTWIZARDPAGE_CONNECTION_LABEL, Labels.DATA_SET, false, this.fLocation.isDefaultLocation(), true, true){

            protected void handleBrowseFileSelected() {
                String locationPath = null;
                PDSSelectionDialog dialog = new PDSSelectionDialog(DTImportWizardPage.this.getShell());
                if (dialog.open() == 0) {
                    Object member = dialog.getOutputObject();
                    locationPath = ((MVSFileResource)member).getName();
                }
                if (locationPath != null) {
                    String[] loc = DTImportWizardPage.this.fDialogSettings.getArray(this.getConnection() + DTImportWizardPage.SEQ_DS);
                    ArrayList<String> locations = new ArrayList<String>();
                    if (loc != null) {
                        locations.addAll(Arrays.asList(loc));
                    }
                    if (!locations.contains(locationPath)) {
                        locations.add(locationPath);
                        DTImportWizardPage.this.fDialogSettings.put(this.getConnection() + DTImportWizardPage.SEQ_DS, locations.toArray(new String[locations.size()]));
                    }
                    this.fDestCombo.setText(locationPath);
                }
            }

            protected void loadLocationList() {
                this.fDestCombo.removeAll();
                String[] list = DTImportWizardPage.this.fDialogSettings.getArray(this.getConnection() + DTImportWizardPage.SEQ_DS);
                if (list != null) {
                    String[] stringArray = list;
                    int n = list.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        if (this.fDestCombo.indexOf(item) == -1) {
                            this.fDestCombo.add(item);
                        }
                        ++n2;
                    }
                }
            }

            protected boolean isValidLocation() {
                return DTImportWizardPage.this.getDataSet() != null;
            }

            protected boolean isExistingLocation() {
                return false;
            }
        };
        this.fConnectionInfo.addConnectLocationListener(new ConnectLocationFields.IConnectLocationListener(){

            public void modifyText() {
                DTImportWizardPage.this.validateFields();
            }
        });
        sc.setContent((Control)mainComposite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.addListener(11, event -> {
            int width = composite.getClientArea().width;
            sc.setMinSize(mainComposite.computeSize(width, -1));
        });
        this.setControl((Control)scrollParent);
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)scrollParent, "com.ibm.debug.pdt.codecoverage.ui.view.import_zos_debugger");
    }

    private void validateFields() {
        this.setErrorMessage(null);
        String connection = this.fConnectionInfo.getConnection();
        String location = this.fConnectionInfo.getLocation();
        if (connection.trim().isEmpty() || location.trim().isEmpty()) {
            this.setErrorMessage(CCResultViewMessages.CRRDG9333);
        } else {
            switch (this.fConnectionInfo.validate()) {
                case OK: {
                    break;
                }
                case INVALID_LOCATION: {
                    this.setErrorMessage(CCResultViewMessages.CRRDG9319);
                    break;
                }
                case HOST_NOT_CONNECTED: {
                    this.setErrorMessage(CCResultViewMessages.CRRDG9300);
                    break;
                }
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public boolean performFinish(IProgressMonitor monitor) {
        monitor.beginTask(Labels.IMPORTING, -1);
        monitor.subTask(Labels.DOWNLOAD_MEMBER);
        File tempDir = null;
        File cczipFile = null;
        IZOSSequentialDataSet dataset = this.getDataSet();
        File temp = this.getTemporaryCopy(dataset);
        if (temp != null && temp.length() > 0L) {
            try {
                monitor.subTask(Labels.CONVERTING);
                tempDir = Files.createTempDirectory(dataset.getName(), new FileAttribute[0]).toFile();
                DebugToolCodeCoverageConverter importer = new DebugToolCodeCoverageConverter(temp.getAbsolutePath(), new CCImportErrorMessages());
                String result = importer.importCodeCoverageData(tempDir.getAbsolutePath());
                cczipFile = new File(result);
                CLCoverageZip ccZip = new CLCoverageZip(cczipFile, true);
                ccZip.importFromZip(monitor, this.fLocation);
                return true;
            }
            catch (IOException e) {
                DTImportLog.log(e);
                PICLDebugPlugin.showMessageDialog(null, (String)CCResultViewMessages.CRRDG9315, (boolean)false);
                return false;
            }
            catch (CCExportException | CLCoverageZipException e) {
                DTImportLog.log(e);
                PICLDebugPlugin.showMessageDialog(null, (String)e.getMessage(), (boolean)false);
                return false;
            }
            finally {
                if (temp.exists() && !temp.delete()) {
                    DTImportLog.log(1, "unable to remove temp file: " + temp.getAbsolutePath());
                }
                if (cczipFile != null && cczipFile.exists() && !cczipFile.delete()) {
                    DTImportLog.log(1, "unable to remove temp file: " + cczipFile.getAbsolutePath());
                }
                if (tempDir != null && tempDir.exists() && !tempDir.delete()) {
                    DTImportLog.log(1, "unable to remove temp dir: " + tempDir.getAbsolutePath());
                }
                monitor.done();
            }
        }
        monitor.done();
        return false;
    }

    private IZOSSequentialDataSet getDataSet() {
        IAdaptable dsm;
        if (this.fConnectionInfo == null) {
            return null;
        }
        String connection = this.fConnectionInfo.getConnection();
        String location = this.fConnectionInfo.getLocation();
        IZOSSystemImage image = DebugLaunchUtils.getConnection((String)connection);
        if (image == null) {
            return null;
        }
        IZOSCatalog root = (IZOSCatalog)image.getRoot();
        if (root != null && (dsm = root.findMember(location, (IProgressMonitor)new NullProgressMonitor())) instanceof IZOSSequentialDataSet) {
            return (IZOSSequentialDataSet)dsm;
        }
        return null;
    }

    private File getTemporaryCopy(IZOSSequentialDataSet seqDataSet) {
        if (seqDataSet == null) {
            return null;
        }
        File temp = null;
        InputStream contents = null;
        OutputStream output = null;
        try {
            try {
                temp = File.createTempFile(seqDataSet.getName() + ".", "");
                if (temp != null) {
                    contents = seqDataSet.getContents();
                    output = new BufferedOutputStream(new FileOutputStream(temp));
                    while (contents.available() > 0) {
                        output.write(contents.read());
                    }
                }
            }
            catch (OperationFailedException e) {
                PICLDebugPlugin.showMessageDialog(null, (String)e.getMessage(), (boolean)false);
                DTImportLog.log(e);
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException e) {
                block32: {
                    DTImportLog.log(e);
                    if (contents == null) break block32;
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
        return temp;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fConnectionInfo != null) {
            this.fConnectionInfo.forceFocus();
        }
    }
}

