/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.animatedstep;

import com.ibm.debug.pdt.internal.animatedstep.AnimatedStepLabels;
import com.ibm.debug.pdt.internal.animatedstep.DecreasePaceAction;
import com.ibm.debug.pdt.internal.animatedstep.IncreasePaceAction;
import com.ibm.debug.pdt.internal.animatedstep.ResetPaceAction;
import com.ibm.debug.pdt.internal.animatedstep.ShowPacePrefAction;
import com.ibm.debug.pdt.internal.animatedstep.preferences.PreferenceInitializer;
import com.ibm.debug.pdt.internal.core.model.BreakpointAddedEvent;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.ExpressionAddedEvent;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.model.IProcessEventListener;
import com.ibm.debug.pdt.internal.core.model.IThreadEventListener;
import com.ibm.debug.pdt.internal.core.model.ModuleAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessDetachedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessEndedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmError;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmOutput;
import com.ibm.debug.pdt.internal.core.model.ProcessStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadChangedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadEndedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadStoppedEvent;
import com.ibm.debug.pdt.internal.epdc.ProcessStopInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AnimatedStepAction
extends Action
implements IJobChangeListener,
IDebugContextListener {
    private static final ImageDescriptor ENABLED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.animatedstep", (String)"/icons/elcl16/animatedstep.png");
    private static final ImageDescriptor DISABLED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.animatedstep", (String)"/icons/dlcl16/animatedstep.png");
    private static final ImageDescriptor RUNNING_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.animatedstep", (String)"/icons/elcl16/anistep_running.png");
    public static final String ID = "com.ibm.debug.pdt.animatedstep";
    private static final AnimatedStepAction _action = new AnimatedStepAction();
    private AnimatedStepJob fStepJob;
    private IThread fCurrentStepTarget;
    private Action fShowPacePrefAction = new ShowPacePrefAction();

    public AnimatedStepAction() {
        super(AnimatedStepLabels.AnimatedStepAction_ActionTitle2);
        this.setId(ID);
        this.setImageDescriptor(ENABLED_ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setEnabled(false);
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        this.setToolTipText(this.getLabel());
        this.initMenus();
    }

    public static int getPace() {
        return PreferenceInitializer.getPrefStore().getInt("defaultPace");
    }

    public static void setPace(int pace) {
        PreferenceInitializer.getPrefStore().setValue("defaultPace", pace);
        AnimatedStepAction action = AnimatedStepAction.getAction();
        action.setToolTipText(action.getLabel());
    }

    public static AnimatedStepAction getAction() {
        return _action;
    }

    public void run() {
        if (this.fStepJob == null) {
            this.fStepJob = new AnimatedStepJob(this);
            this.fStepJob.addJobChangeListener(this);
        }
        if (this.fStepJob.getState() == 4) {
            this.fStepJob.cancel();
        } else if (this.fCurrentStepTarget != null && this.fCurrentStepTarget.canStepInto() && !this.fCurrentStepTarget.isStepping()) {
            this.fStepJob.schedule();
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        if (event.getFlags() != 1) {
            return;
        }
        IThread newStepTarget = this.getStepTarget(event.getContext());
        boolean stopSteppingJob = false;
        if (newStepTarget == null) {
            this.setEnabled(false);
            this.fCurrentStepTarget = null;
        } else {
            this.setEnabled(true);
            if (this.fCurrentStepTarget != null && this.fCurrentStepTarget.getDebugTarget() != newStepTarget.getDebugTarget()) {
                stopSteppingJob = true;
            }
            this.fCurrentStepTarget = newStepTarget;
        }
        if (stopSteppingJob && this.fStepJob != null) {
            this.fStepJob.cancel();
        }
    }

    private IThread getStepTarget(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structSel = (IStructuredSelection)selection;
        if (structSel.size() > 1) {
            return null;
        }
        Object element = structSel.getFirstElement();
        IThread stepTarget = null;
        if (element instanceof IStackFrame) {
            stepTarget = ((IStackFrame)element).getThread();
        } else if (element instanceof IThread) {
            stepTarget = (IThread)element;
        }
        if (stepTarget instanceof DebuggeeThread) {
            return stepTarget;
        }
        return null;
    }

    private void initMenus() {
        this.setMenuCreator(new AnimatedStepMenuCreator());
    }

    private String getLabel() {
        return NLS.bind((String)AnimatedStepLabels.AnimatedStepAction_ActionTitle2, (Object)AnimatedStepAction.getPace());
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        this.setImageDescriptor(ENABLED_ICON);
        this.fShowPacePrefAction.setEnabled(true);
    }

    public void running(IJobChangeEvent event) {
        this.setImageDescriptor(RUNNING_ICON);
        this.fShowPacePrefAction.setEnabled(false);
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    static class AnimatedStepJob
    extends Job
    implements IProcessEventListener,
    IThreadEventListener {
        private AnimatedStepAction fAction;

        public AnimatedStepJob(AnimatedStepAction action) {
            super(AnimatedStepLabels.AnimatedStepAction_JobName);
            this.fAction = action;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(AnimatedStepLabels.AnimatedStepAction_JobTitle, -1);
            IThread stepTarget = this.fAction.fCurrentStepTarget;
            if (stepTarget != null) {
                DebuggeeProcess process = (DebuggeeProcess)stepTarget.getDebugTarget().getProcess();
                this.startListening(process);
                while ((stepTarget = this.fAction.fCurrentStepTarget) != null && !stepTarget.isTerminated() && !monitor.isCanceled()) {
                    try {
                        if (stepTarget.canStepInto() && !stepTarget.isStepping()) {
                            stepTarget.stepInto();
                            Thread.sleep(AnimatedStepAction.getPace());
                            continue;
                        }
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        monitor.setCanceled(true);
                        break;
                    }
                }
                this.stopListening(process);
            }
            boolean cancelled = monitor.isCanceled();
            monitor.done();
            if (cancelled) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        private void startListening(DebuggeeProcess process) {
            DebuggeeThread[] threads;
            process.addEventListener((IProcessEventListener)this);
            DebuggeeThread[] debuggeeThreadArray = threads = process.getThreads();
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                DebuggeeThread debuggeeThread = debuggeeThreadArray[n2];
                debuggeeThread.addEventListener((IThreadEventListener)this);
                ++n2;
            }
        }

        private void stopListening(DebuggeeProcess process) {
            DebuggeeThread[] threads;
            process.removeListener((IModelEventListener)this);
            DebuggeeThread[] debuggeeThreadArray = threads = process.getThreads();
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                DebuggeeThread debuggeeThread = debuggeeThreadArray[n2];
                debuggeeThread.removeListener((IModelEventListener)this);
                ++n2;
            }
        }

        public void breakpointAdded(BreakpointAddedEvent event) {
        }

        public void expressionAdded(ExpressionAddedEvent event) {
        }

        public void moduleAdded(ModuleAddedEvent event) {
        }

        public void processDetached(ProcessDetachedEvent event) {
        }

        public void processEnded(ProcessEndedEvent event) {
        }

        public void processStopped(ProcessStoppedEvent event) {
        }

        public void programError(ProcessPgmError event) {
        }

        public void programOutput(ProcessPgmOutput event) {
        }

        public void threadAdded(ThreadAddedEvent event) {
            event.getThread().addEventListener((IThreadEventListener)this);
        }

        public void expressionLocalAdded(ExpressionAddedEvent event) {
        }

        public void threadChanged(ThreadChangedEvent event) {
        }

        public void threadEnded(ThreadEndedEvent event) {
            event.getThread().removeListener((IModelEventListener)this);
        }

        public void threadStopped(ThreadStoppedEvent event) {
            this.checkStopInfo(event.getStopInfo());
        }

        private void checkStopInfo(ProcessStopInfo stopInfo) {
            if (stopInfo.isStoppedByBreakpoint() || stopInfo.isStoppedByException() || stopInfo.isStoppedByExec() || stopInfo.isStoppedByFork()) {
                this.cancel();
            }
        }
    }

    class AnimatedStepMenuCreator
    implements IMenuCreator {
        private Menu fMenu;

        AnimatedStepMenuCreator() {
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu == null) {
                this.fMenu = new Menu(parent);
                this.fillMenu(this.fMenu);
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        private void fillMenu(Menu menu) {
            new ActionContributionItem((IAction)new IncreasePaceAction()).fill(menu, 0);
            new ActionContributionItem((IAction)new DecreasePaceAction()).fill(menu, 1);
            new ActionContributionItem((IAction)new ResetPaceAction()).fill(menu, 2);
            new ActionContributionItem((IAction)AnimatedStepAction.this.fShowPacePrefAction).fill(menu, 3);
        }
    }
}

