/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon;

import com.ibm.debug.daemon.CoreDaemonListener;
import com.ibm.debug.daemon.DaemonSocketConnection;
import com.ibm.debug.daemon.IOldDaemonDefaultSupport;
import com.ibm.debug.daemon.IOldDaemonSupport;
import com.ibm.debug.daemon.NameValuePair;
import com.ibm.debug.daemon.internal.core.DaemonCore;
import com.ibm.debug.daemon.internal.core.DaemonException;
import com.ibm.debug.daemon.internal.core.DaemonLabels;
import com.ibm.debug.daemon.internal.core.DaemonMessages;
import com.ibm.debug.daemon.internal.ui.DaemonUtils;
import com.ibm.debug.daemon.internal.ui.DebugCoreDaemonListener;
import com.ibm.debug.daemon.internal.ui.DebugDaemonPlugin;
import com.ibm.debug.daemon.internal.ui.LinkedErrorDialog;
import com.ibm.debug.daemon.internal.ui.PortUtility;
import java.net.SocketException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CoreDaemon
extends DaemonCore {
    private static Object listenerInitializationLock = new Object();
    private static Boolean haveAddedListener = Boolean.FALSE;
    private static String errorMessage = null;
    private static final Object fLockObject = new Object();
    static CoreDaemon coreDaemonInstance;

    private CoreDaemon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoreDaemon getInstance() {
        Object object = fLockObject;
        synchronized (object) {
            if (coreDaemonInstance == null) {
                DaemonCore.getInstance();
                coreDaemonInstance = new CoreDaemon();
                CoreDaemon.addDaemonStatusChangeListener();
            }
            return coreDaemonInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDaemonStatusChangeListener() {
        Object object = listenerInitializationLock;
        synchronized (object) {
            if (haveAddedListener.equals(Boolean.FALSE)) {
                DaemonCore.getInstance().getListenerRegistry().addListener((CoreDaemonListener)new DebugCoreDaemonListener());
                haveAddedListener = Boolean.TRUE;
            }
        }
    }

    public static boolean startListeningSecure(boolean showError) {
        IWorkbench workbench;
        CoreDaemon.initAuthentication();
        String portPref = PortUtility.getSecurePortPreference();
        Integer[] ports = PortUtility.getPorts((String)portPref);
        String keystoreFileName = DebugDaemonPlugin.getInstance().getKeyStoreFileName();
        char[] keystorePassword = DebugDaemonPlugin.getInstance().getKeyStorePassword(keystoreFileName);
        DaemonCore.setMaxParameterBuffer((int)PortUtility.getMaxParameterBufferSize());
        Exception exception = null;
        Integer[] integerArray = ports;
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            Integer port = integerArray[n2];
            try {
                return CoreDaemon.startListeningSecure(port, keystoreFileName, keystorePassword);
            }
            catch (Exception e) {
                exception = e;
                ++n2;
            }
        }
        if (exception instanceof SocketException) {
            if (showError) {
                workbench = PlatformUI.getWorkbench();
                final DaemonException daemonException = new DaemonException(NLS.bind((String)DaemonMessages.CRRDG1119, (Object)portPref));
                workbench.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                        if (window != null) {
                            Status status = new Status(4, "com.ibm.debug.daemon.ui", daemonException.getMessage());
                            LinkedErrorDialog.openLinkError(DaemonUtils.getShell(), DaemonLabels.ErrorDialog_error, null, (IStatus)status);
                        }
                    }
                });
            } else {
                errorMessage = NLS.bind((String)DaemonMessages.CRRDG1120, (Object)portPref);
            }
            return false;
        }
        if (exception instanceof DaemonException) {
            if (showError) {
                workbench = PlatformUI.getWorkbench();
                final DaemonException daemonException = (DaemonException)exception;
                workbench.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                        if (window != null) {
                            Status status = new Status(4, "com.ibm.debug.daemon.ui", daemonException.getMessage());
                            LinkedErrorDialog.openLinkError(DaemonUtils.getShell(), DaemonLabels.ErrorDialog_error, null, (IStatus)status);
                        }
                    }
                });
            } else {
                errorMessage = exception.getMessage();
            }
            return false;
        }
        return false;
    }

    public static boolean startListeningSecure() {
        return CoreDaemon.startListeningSecure(false);
    }

    public static boolean startListeningSecure(int port, String keystoreFileName, char[] keystorePassword) throws SocketException, DaemonException {
        CoreDaemon.initAuthentication();
        return CoreDaemon.getInstance().startDaemonSecure(port, keystoreFileName, keystorePassword);
    }

    public static boolean startListening(boolean showError) {
        CoreDaemon.initAuthentication();
        String portPref = PortUtility.getPortPreference();
        Integer[] ports = PortUtility.getPorts((String)portPref);
        DaemonCore.setMaxParameterBuffer((int)PortUtility.getMaxParameterBufferSize());
        DaemonException exception = null;
        Integer[] integerArray = ports;
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            Integer port = integerArray[n2];
            try {
                return CoreDaemon.startListening(port);
            }
            catch (DaemonException de) {
                exception = de;
                ++n2;
            }
        }
        if (showError) {
            final DaemonException daemonException = exception;
            final IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    if (window != null) {
                        Status status = new Status(4, "com.ibm.debug.daemon.ui", daemonException.getMessage());
                        LinkedErrorDialog.openLinkError(DaemonUtils.getShell(), DaemonLabels.ErrorDialog_error, null, (IStatus)status);
                    }
                }
            });
        }
        return false;
    }

    public static boolean startListening(int port) throws DaemonException {
        CoreDaemon.initAuthentication();
        CoreDaemon.getInstance().startDaemon(new int[]{port}, null);
        if (CoreDaemon.isListening()) {
            return true;
        }
        throw new DaemonException(NLS.bind((String)DaemonMessages.CRRDG1117, (Object)port));
    }

    public static boolean startListening() {
        return CoreDaemon.startListening(false);
    }

    public void displayError(String title, String message) {
        DebugDaemonPlugin.displayError(title, message);
    }

    public static NewDaemonInput retrieveNewDaemonInput(int key) {
        DaemonCore.NewDaemonInput internalInput = (DaemonCore.NewDaemonInput)newDaemonInputHashtable.get(key);
        if (internalInput != null) {
            CoreDaemon cd;
            if (DebugDaemonPlugin.isLogging()) {
                DebugDaemonPlugin.log("Input retrieved from hashtable, key=" + key, null);
            }
            CoreDaemon coreDaemon = cd = CoreDaemon.getInstance();
            ((Object)((Object)coreDaemon)).getClass();
            NewDaemonInput input = coreDaemon.new NewDaemonInput(internalInput.getSocket(), internalInput.getInputArray(), internalInput.getVersion());
            return input;
        }
        if (DebugDaemonPlugin.isLogging()) {
            DebugDaemonPlugin.log("Input NOT FOUND in hashtable, key=" + key, null);
        }
        return null;
    }

    public static OldDaemonInput retrieveOldDaemonInput(int key) {
        OldDaemonInput input = (OldDaemonInput)((Object)oldDaemonInputHashtable.get(key));
        if (input != null) {
            if (DebugDaemonPlugin.isLogging()) {
                DebugDaemonPlugin.log("Input retrieved from hashtable, key=" + key, null);
            } else if (DebugDaemonPlugin.isLogging()) {
                DebugDaemonPlugin.log("Input NOT FOUND in hashtable, key=" + key, null);
            }
        }
        return input;
    }

    public static String getErrorMessage() {
        return errorMessage;
    }

    protected void compatibilityDelegate(ILaunchConfigurationDelegate delegate, DaemonSocketConnection connection, String[] input, int version) {
        ((IOldDaemonDefaultSupport)delegate).figureOutWhatToDo((IOldDaemonSupport.IOldDaemonInput)new OldDaemonInput(connection, input, version));
    }

    private static void initAuthentication() {
        if (DaemonCore.hasAuthenticators()) {
            String keystoreFile = DebugDaemonPlugin.getInstance().getAuthKeyStoreFileName();
            if (keystoreFile == null || keystoreFile.isEmpty()) {
                CoreDaemon.getInstance().setAuthenticatorKeystore(null, null);
            } else {
                CoreDaemon.getInstance().setAuthenticatorKeystore(keystoreFile, DebugDaemonPlugin.getInstance().getAuthKeyStorePassword(keystoreFile));
            }
        }
    }

    public class NewDaemonInput
    extends DaemonCore.NewDaemonInput {
        public NewDaemonInput(DaemonSocketConnection socket, NameValuePair[] input, int version) {
            super(socket, input, version);
        }
    }

    public class OldDaemonInput
    extends DaemonCore.OldDaemonInput {
        public OldDaemonInput(DaemonSocketConnection socket, String[] input, int version) {
            super(socket, input, version);
        }

        public DaemonSocketConnection getSocket() {
            return super.getSocket();
        }
    }
}

