/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug.ui;

import com.ibm.cdz.remote.debug.IUniversalPDTLaunchConstants;
import com.ibm.cdz.remote.debug.PDTLaunchPlugin;
import com.ibm.cdz.remote.debug.ui.UniversalPDTDebugTab;
import com.ibm.etools.systems.launch.LaunchPlugin;
import com.ibm.etools.systems.launch.UniversalLaunchUtil;
import com.ibm.etools.systems.launch.sourceLookup.RemoteSourceContainerDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.actions.SystemSelectRemoteFileAction;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.widgets.SystemHostCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UniversalPDTMainTab
extends AbstractLaunchConfigurationTab
implements IUniversalPDTLaunchConstants,
IRunnableContext {
    private static final String SLASH = "/";
    private static final String TOOLTIP = "tooltip";
    private static final String LABEL = "label";
    private static final String PERIOD = ".";
    private static final String EMPTY = "";
    private IHost connection = null;
    private SystemHostCombo connectionCombo = null;
    protected ResourceBundle stringsResourceBundle = PDTLaunchPlugin.getStringsResourceBundle();
    private Text classText;
    private Button classBrowseButton;
    private Text workingDirText;
    private Button workingDirBrowseButton;
    private Button stopInMainCheckBox;
    private ProgressMonitorPart progressMonitorPart = null;

    public void createControl(Composite parent) {
        int parentSpan = 1;
        int layoutCompositeNumberOfColumns = 1;
        Composite layoutComposite = SystemWidgetHelpers.createComposite((Composite)parent, (int)layoutCompositeNumberOfColumns);
        ((GridData)layoutComposite.getLayoutData()).horizontalAlignment = 4;
        ((GridData)layoutComposite.getLayoutData()).verticalAlignment = 1;
        this.setControl((Control)layoutComposite);
        this.createVerticalSpacer(layoutComposite, 3);
        int connectionCompositeNumberOfColumns = 1;
        Composite connectionComposite = SystemWidgetHelpers.createComposite((Composite)layoutComposite, (int)parentSpan, (int)connectionCompositeNumberOfColumns, (boolean)false, null, (int)-1, (int)-1);
        IRSESystemType[] supportedTypes = new IRSESystemType[]{RSECorePlugin.getTheCoreRegistry().getSystemTypeById("com.ibm.etools.zos.system")};
        if (supportedTypes != null) {
            this.connectionCombo = new SystemHostCombo(connectionComposite, 0, supportedTypes, null, true);
        }
        this.connectionCombo.setData("org.eclipse.e4.ui.css.id", (Object)"debug-composite");
        this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                UniversalPDTMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(layoutComposite, 1);
        Composite classComposite = new Composite(layoutComposite, 0);
        GridLayout myLayout = new GridLayout();
        myLayout.numColumns = 2;
        myLayout.marginHeight = 0;
        myLayout.marginWidth = 0;
        classComposite.setLayout((Layout)myLayout);
        GridData gd = new GridData(768);
        classComposite.setLayoutData((Object)gd);
        Label classLabel = new Label(classComposite, 0);
        classLabel.setText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.class.label"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        classLabel.setLayoutData((Object)gd);
        this.classText = new Text(classComposite, 2052);
        gd = new GridData(768);
        this.classText.setLayoutData((Object)gd);
        this.classText.setToolTipText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.class.tooltip"));
        this.classText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                UniversalPDTMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.classBrowseButton = this.createPushButton(classComposite, this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.browsePrompt"), null);
        this.classBrowseButton.setToolTipText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.class.browse.tooltip"));
        this.classBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                UniversalPDTMainTab.this.browseClass();
            }
        });
        this.createVerticalSpacer(layoutComposite, 1);
        Composite workingPathComposite = new Composite(layoutComposite, 0);
        myLayout = new GridLayout();
        myLayout.numColumns = 2;
        myLayout.marginHeight = 0;
        myLayout.marginWidth = 0;
        workingPathComposite.setLayout((Layout)myLayout);
        gd = new GridData(768);
        workingPathComposite.setLayoutData((Object)gd);
        Label directoryLabel = new Label(workingPathComposite, 0);
        directoryLabel.setText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.workingDir.label"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        directoryLabel.setLayoutData((Object)gd);
        this.workingDirText = new Text(workingPathComposite, 2052);
        gd = new GridData(768);
        this.workingDirText.setLayoutData((Object)gd);
        this.workingDirText.setToolTipText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.workingDir.tooltip"));
        this.workingDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                UniversalPDTMainTab.this.modifyWorkingPath();
            }
        });
        this.workingDirBrowseButton = this.createPushButton(workingPathComposite, this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.browsePrompt"), null);
        this.workingDirBrowseButton.setToolTipText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.workingDir.browse.tooltip"));
        this.workingDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                UniversalPDTMainTab.this.browseWorkingPath();
            }
        });
        this.createVerticalSpacer(layoutComposite, 1);
        this.createStopInMain(layoutComposite);
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        this.progressMonitorPart = new ProgressMonitorPart(layoutComposite, (Layout)pmlayout, -1);
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        this.progressMonitorPart.setVisible(true);
        SystemWidgetHelpers.setCompositeHelp((Composite)layoutComposite, (String)"com.ibm.cdz.remote.debug.zosunix_main");
    }

    private void createStopInMain(Composite layoutComposite) {
        if (!this.isDebugMode()) {
            return;
        }
        int stopInMainCompositeNumberOfColumns = 2;
        Composite stopInMainComposite = SystemWidgetHelpers.createComposite((Composite)layoutComposite, (int)stopInMainCompositeNumberOfColumns, (int)2, (boolean)false, null, (int)0, (int)0);
        this.stopInMainCheckBox = SystemWidgetHelpers.createCheckBox((Composite)stopInMainComposite, null, (String)this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.stopInMain.label"), (String)this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.stopInMain.tooltip"));
        this.stopInMainCheckBox.setSelection(true);
        this.stopInMainCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                UniversalPDTMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private boolean isDebugMode() {
        return this.getLaunchConfigurationDialog().getMode().equalsIgnoreCase("debug");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        ISystemRemoteElementAdapter systemRemoteFileAdapter;
        IPreferenceStore preferenceStore = PDTLaunchPlugin.getDefault().getPreferenceStore();
        configuration.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionProfileName", EMPTY);
        configuration.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", EMPTY);
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.HasAssociatedProject", true);
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.DefaultSourcePath", true);
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.Project", EMPTY);
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.Main", EMPTY);
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.WorkingDirectory", PERIOD);
        IStructuredSelection workbenchSelection = LaunchPlugin.getActiveWorkbenchSelection();
        if (workbenchSelection == null) {
            return;
        }
        if (this.isDebugMode()) {
            boolean preferenceStopInMain = preferenceStore.getBoolean("com.ibm.cdz.remote.debug.preference.stopInMain");
            configuration.setAttribute("com.ibm.cdz.remote.debug.attr.stopInMain", preferenceStopInMain);
        }
        if ((systemRemoteFileAdapter = UniversalLaunchUtil.getRSESelection((IStructuredSelection)workbenchSelection)) != null) {
            this.prefillDefaultFromRSE(workbenchSelection, systemRemoteFileAdapter, configuration);
        } else {
            this.prefillDefaultFormCDT(workbenchSelection.toArray(), configuration);
        }
    }

    private void prefillDefaultFormCDT(Object[] objects, ILaunchConfigurationWorkingCopy configuration) {
    }

    private void prefillDefaultFromRSE(IStructuredSelection selection, ISystemRemoteElementAdapter systemRemoteFileAdapter, ILaunchConfigurationWorkingCopy configuration) {
        Object selectedObject = selection.getFirstElement();
        if (!(selectedObject instanceof IRemoteFile) || !"class".equalsIgnoreCase(systemRemoteFileAdapter.getRemoteSubType(selectedObject))) {
            return;
        }
        IRemoteFile remoteFile = (IRemoteFile)selectedObject;
        if (!remoteFile.isExecutable()) {
            return;
        }
        String typeName = remoteFile.getName();
        Object defaultWorkingDir = null;
        IRemoteFile parent = UniversalLaunchUtil.getRealParentRemoteFile((IRemoteFile)remoteFile);
        boolean isWindows = UniversalLaunchUtil.isLocalWindows((IHost)remoteFile.getHost());
        defaultWorkingDir = !isWindows ? remoteFile.getSeparator() + parent.getParentNoRoot() : parent.getParentPath();
        if (defaultWorkingDir == null) {
            defaultWorkingDir = remoteFile.getRoot();
        }
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.HasAssociatedProject", false);
        configuration.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionProfileName", remoteFile.getHost().getSystemProfileName());
        configuration.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", remoteFile.getHost().getAliasName());
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.Main", typeName);
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.WorkingDirectory", (String)defaultWorkingDir);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String systemConnectionProfileName = configuration.getAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionProfileName", EMPTY);
            String systemConnectionAliasName = configuration.getAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", EMPTY);
            this.connection = UniversalLaunchUtil.getSystemConnection((String)systemConnectionProfileName, (String)systemConnectionAliasName);
            String mainType = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.Main", EMPTY);
            String workingPath = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.WorkingDirectory", EMPTY);
            this.connectionCombo.select(this.connection);
            this.classText.setText(mainType);
            this.workingDirText.setText(workingPath);
            if (this.isDebugMode()) {
                this.stopInMainCheckBox.setSelection(configuration.getAttribute("com.ibm.cdz.remote.debug.attr.stopInMain", true));
            }
        }
        catch (CoreException systemConnectionProfileName) {
            // empty catch block
        }
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
        int i = 0;
        while (i < tabs.length) {
            if (tabs[i] instanceof UniversalPDTDebugTab) {
                ((UniversalPDTDebugTab)tabs[i]).systemConnectionUpdated(this.connectionCombo.getHost());
            }
            ++i;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IHost systemConnection = this.connectionCombo.getHost();
        if (systemConnection == null) {
            configuration.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionProfileName", EMPTY);
            configuration.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", EMPTY);
        } else {
            configuration.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionProfileName", systemConnection.getSystemProfileName());
            configuration.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", systemConnection.getAliasName());
        }
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.Main", this.classText.getText().trim());
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.WorkingDirectory", this.workingDirText.getText().trim());
        if (this.isDebugMode()) {
            if (this.stopInMainCheckBox.getSelection()) {
                configuration.setAttribute("com.ibm.cdz.remote.debug.attr.stopInMain", true);
            } else {
                configuration.setAttribute("com.ibm.cdz.remote.debug.attr.stopInMain", false);
            }
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        block4: {
            this.setErrorMessage(null);
            this.setMessage(null);
            try {
                String mainType = launchConfig.getAttribute("com.ibm.cdz.remote.debug.attr.Main", EMPTY);
                if (!mainType.equalsIgnoreCase(EMPTY)) break block4;
                this.setErrorMessage(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.error.invalidMain"));
                return false;
            }
            catch (CoreException e) {
                this.setErrorMessage(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.exception"));
                PDTLaunchPlugin.logError((String)"Failed to retrieve information from launch configuration", (Throwable)e);
                return false;
            }
        }
        String workingDirectory = launchConfig.getAttribute("com.ibm.cdz.remote.debug.attr.WorkingDirectory", EMPTY);
        if (workingDirectory.equalsIgnoreCase(EMPTY)) {
            this.setErrorMessage(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.error.invalidWorkingDir"));
            return false;
        }
        return true;
    }

    public boolean canSave() {
        return true;
    }

    public String getName() {
        return this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.label");
    }

    public Image getImage() {
        return PDTLaunchPlugin.getDefault().getImage("com.ibm.cdz.remote.debug.full/obj16/tab_main.icon");
    }

    protected void browseClass() {
        this.browseClassFromRSE();
    }

    protected void browseClassFromRSE() {
        String rootFolder;
        if (!RemoteFileUtility.getFileSubSystem((IHost)this.connectionCombo.getHost()).isConnected()) {
            try {
                RemoteFileUtility.getFileSubSystem((IHost)this.connectionCombo.getHost()).connect((IProgressMonitor)new NullProgressMonitor(), false);
            }
            catch (Exception e) {
                this.setErrorMessage(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.error.connectionFailed"));
                return;
            }
        }
        if ((rootFolder = this.workingDirText.getText().trim()).equalsIgnoreCase(EMPTY)) {
            rootFolder = SLASH;
        }
        SystemSelectRemoteFileAction action = new SystemSelectRemoteFileAction(PDTLaunchPlugin.getActiveWorkbenchShell(), this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.class.dialog.label"), this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.class.dialog.tooltip"));
        action.setRootFolder(this.connectionCombo.getHost(), rootFolder);
        try {
            action.run();
        }
        catch (Exception e) {
            PDTLaunchPlugin.logError((String)"unexpected error", (Throwable)e);
        }
        IRemoteFile result = action.getSelectedFile();
        if (result == null) {
            return;
        }
        String typeName = result.getName();
        IRemoteFile parent = UniversalLaunchUtil.getRealParentRemoteFile((IRemoteFile)result);
        String defaultWorkingDir = parent.getAbsolutePath();
        if (defaultWorkingDir == null) {
            defaultWorkingDir = result.getRoot();
        }
        this.classText.setText(typeName);
        this.workingDirText.setText(defaultWorkingDir);
    }

    protected void browseClassFromProject() {
        this.browseClassFromRSE();
    }

    protected void modifyWorkingPath() {
        this.updateLaunchConfigurationDialog();
    }

    protected void browseWorkingPath() {
        IHost systemConnection = this.connectionCombo.getHost();
        RemoteSourceContainerDialog dialog = new RemoteSourceContainerDialog(this.getShell(), 43104, 0, false, false, systemConnection, SLASH);
        IRemoteFile[] result = dialog.open();
        if (result != null && result.length > 0) {
            this.workingDirText.setText(result[0].getAbsolutePath());
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.getProgressMonitor(), (Display)this.getShell().getDisplay());
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitorPart;
    }

    public void dispose() {
        if (this.progressMonitorPart != null) {
            this.progressMonitorPart.setCanceled(true);
        }
    }
}

