/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug.ui;

import com.ibm.cdz.remote.debug.IUniversalPDTLaunchConstants;
import com.ibm.cdz.remote.debug.PDTLaunchPlugin;
import com.ibm.cdz.remote.debug.ui.EnginePathVariable;
import com.ibm.cdz.remote.debug.ui.UniversalPDTEnginePathPromptDialog;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class UniversalPDTEnginePathEntryForm
implements SelectionListener,
IUniversalPDTLaunchConstants {
    private static final String EMPTY = "";
    private Composite parent = null;
    private String formTitle = null;
    private Table entriesTable = null;
    private Vector<Object> entries = null;
    private Object selectedObject = null;
    private TableViewer entriesTableViewer = null;
    private EntryTableContentProvider contentProvider = null;
    private Button addButton = null;
    private Button changeButton = null;
    private Button removeButton = null;
    private ResourceBundle stringsResourceBundle = null;
    private Vector<Object> entryListeners = new Vector();

    public UniversalPDTEnginePathEntryForm(Composite parent, String formTitle, Object selectedObject) {
        this.parent = parent;
        this.formTitle = formTitle;
        this.selectedObject = selectedObject;
        this.entries = new Vector();
        this.contentProvider = new EntryTableContentProvider();
        this.stringsResourceBundle = PDTLaunchPlugin.getStringsResourceBundle();
    }

    public Control createContents() {
        int numberOfColumns = 2;
        Composite layoutComposite = SystemWidgetHelpers.createComposite((Composite)this.parent, (int)numberOfColumns);
        ((GridData)layoutComposite.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)layoutComposite.getLayoutData()).grabExcessVerticalSpace = true;
        SystemWidgetHelpers.createLabel((Composite)layoutComposite, (String)this.formTitle, (int)numberOfColumns);
        this.entriesTable = new Table(layoutComposite, 68354);
        this.entriesTable.setLinesVisible(true);
        this.entriesTable.setHeaderVisible(true);
        this.entriesTable.setToolTipText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.tooltip"));
        this.entriesTable.addSelectionListener((SelectionListener)this);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        this.entriesTable.setLayout((Layout)tableLayout);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.entriesTable.setLayoutData((Object)gd);
        TableColumn hostNameColumn = new TableColumn(this.entriesTable, 0);
        hostNameColumn.setResizable(true);
        hostNameColumn.setText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.column.host.label"));
        TableColumn enginePathColumn = new TableColumn(this.entriesTable, 0);
        enginePathColumn.setResizable(true);
        enginePathColumn.setText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.column.path.label"));
        this.entriesTableViewer = new TableViewer(this.entriesTable);
        this.entriesTableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.entriesTableViewer.setLabelProvider((IBaseLabelProvider)this.contentProvider);
        this.entriesTableViewer.setInput(this.selectedObject);
        Composite buttonBar = SystemWidgetHelpers.createComposite((Composite)layoutComposite, (int)1);
        ((GridData)buttonBar.getLayoutData()).grabExcessHorizontalSpace = false;
        this.addButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.add.label"), null);
        this.addButton.setToolTipText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.add.tooltip"));
        this.addButton.addSelectionListener((SelectionListener)this);
        this.changeButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.edit.label"), null);
        this.changeButton.setToolTipText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.edit.tooltip"));
        this.changeButton.addSelectionListener((SelectionListener)this);
        this.removeButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.remove.label"), null);
        this.removeButton.setToolTipText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.remove.tooltip"));
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.updateButtonsEnablement();
        return this.parent;
    }

    public List<Object> getEntries() {
        return this.entries;
    }

    public void setEntries(Collection<Object> collectionOfEntries) {
        if (this.entries == null) {
            this.entries = new Vector<Object>(collectionOfEntries);
        } else if (this.entries != collectionOfEntries && !collectionOfEntries.isEmpty()) {
            this.entries.clear();
            this.entries.addAll(collectionOfEntries);
            if (this.entriesTableViewer != null) {
                this.refreshEntriesTableViewer();
            }
        }
    }

    public void addEntryListener(EntryChangeListener listener) {
        if (this.entryListeners == null) {
            this.entryListeners = new Vector();
        }
        this.entryListeners.add(listener);
    }

    public void removeEntryListener(EntryChangeListener listener) {
        this.entryListeners.remove(listener);
    }

    public void refreshEntriesTableViewer() {
        this.entriesTableViewer.refresh();
    }

    public void addEntry(EnginePathVariable entry) {
        if (entry.getHostName().equals(EMPTY) || entry.getEnginePath().equals(EMPTY)) {
            return;
        }
        int i = 0;
        while (i < this.entries.size()) {
            if (((EnginePathVariable)this.entries.get(i)).getHostName().equals(entry.getHostName())) {
                return;
            }
            ++i;
        }
        this.entries.add(entry);
        this.entriesTableViewer.refresh();
    }

    public void removeEntry(EnginePathVariable entry) {
        if (this.entries != null) {
            this.entries.remove(entry);
            this.entriesTableViewer.refresh();
        }
    }

    private void updateButtonsEnablement() {
        switch (this.entriesTable.getSelectionCount()) {
            case 0: {
                this.removeButton.setEnabled(false);
                this.changeButton.setEnabled(false);
                break;
            }
            case 1: {
                this.removeButton.setEnabled(true);
                this.changeButton.setEnabled(true);
                break;
            }
            default: {
                this.removeButton.setEnabled(true);
                this.changeButton.setEnabled(false);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() == this.entriesTable) {
            this.entriesTableViewer.refresh();
        } else if (event.getSource() == this.addButton) {
            UniversalPDTEnginePathPromptDialog promptDialog = new UniversalPDTEnginePathPromptDialog(PDTLaunchPlugin.getActiveWorkbenchShell(), this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.add.dialog.label"));
            int rc = promptDialog.open();
            if (rc == 0) {
                this.entries.add(new EnginePathVariable(promptDialog.getHostName(), promptDialog.getPath()));
                this.entriesTableViewer.refresh();
                int i = 0;
                while (i < this.entryListeners.size()) {
                    ((EntryChangeListener)this.entryListeners.get(i)).entryChanged();
                    ++i;
                }
            }
        } else if (event.getSource() == this.changeButton) {
            int selectionIndex = this.entriesTable.getSelectionIndex();
            if (-1 == selectionIndex) {
                return;
            }
            TableItem selectedItem = this.entriesTable.getItem(selectionIndex);
            UniversalPDTEnginePathPromptDialog promptDialog = new UniversalPDTEnginePathPromptDialog(PDTLaunchPlugin.getActiveWorkbenchShell(), this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.preference.dialog.table.edit.dialog.label"), selectedItem.getText(0), selectedItem.getText(1));
            int rc = promptDialog.open();
            if (rc == 0) {
                this.entries.set(selectionIndex, new EnginePathVariable(promptDialog.getHostName(), promptDialog.getPath()));
                this.entriesTableViewer.refresh();
                int i = 0;
                while (i < this.entryListeners.size()) {
                    ((EntryChangeListener)this.entryListeners.get(i)).entryChanged();
                    ++i;
                }
            }
        } else if (event.getSource() == this.removeButton) {
            int numberOfSelectedItems = this.entriesTable.getSelectionCount();
            if (numberOfSelectedItems == 0) {
                return;
            }
            if (1 == numberOfSelectedItems) {
                try {
                    this.entries.removeElementAt(this.entriesTable.getSelectionIndex());
                }
                catch (ArrayIndexOutOfBoundsException selectedItem) {}
            } else if (1 < numberOfSelectedItems) {
                int[] selectionIndexArray = this.entriesTable.getSelectionIndices();
                int i = 0;
                while (i <= selectionIndexArray.length) {
                    try {
                        this.entries.removeElementAt(selectionIndexArray[i]);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            this.entriesTableViewer.refresh();
            int i = 0;
            while (i < this.entryListeners.size()) {
                ((EntryChangeListener)this.entryListeners.get(i)).entryChanged();
                ++i;
            }
        }
        this.updateButtonsEnablement();
    }

    public void clearEntries() {
        if (this.entries != null) {
            this.entries.clear();
        }
    }

    public void setEnablement(boolean enabled) {
        if (!enabled) {
            this.entriesTable.setEnabled(false);
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        } else {
            this.entriesTable.setEnabled(true);
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        }
    }

    public static interface EntryChangeListener {
        public void entryChanged();
    }

    protected class EntryTableContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        protected EntryTableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return UniversalPDTEnginePathEntryForm.this.entries.toArray();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((EnginePathVariable)element).getHostName();
                }
                case 1: {
                    return ((EnginePathVariable)element).getEnginePath();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

