/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug.ui;

import com.ibm.cdz.remote.debug.PDTLaunchPlugin;
import com.ibm.cdz.remote.debug.ui.EnginePathTableContentProvider;
import com.ibm.cdz.remote.debug.ui.EnginePathTableLabelProvider;
import com.ibm.cdz.remote.debug.ui.UniversalPDTDebugTab;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.rse.files.ui.actions.SystemSelectRemoteFolderAction;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemBaseForm;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.widgets.GridUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class EnginePathsForm
extends SystemBaseForm
implements ISelectionChangedListener,
ICellModifier,
ICellEditorValidator {
    private static final String LABEL = "label";
    private static final String TOOLTIP = "tooltip";
    private static final String COMMA = ",";
    private List<Object> _paths;
    private Button _addButton;
    private Button _removeButton;
    private Button _upButton;
    private Button _downButton;
    private TableViewer _viewer;
    private String _tablePrompt;
    private UniversalPDTDebugTab _parentTab;
    private IRemoteFileSubSystem _ss;
    private ResourceBundle _stringsResourceBundle;

    public EnginePathsForm(ISystemMessageLine msgLine, String tablePrompt, UniversalPDTDebugTab tab) {
        super(null, msgLine);
        this._tablePrompt = tablePrompt;
        this._paths = new ArrayList<Object>();
        this._stringsResourceBundle = PDTLaunchPlugin.getStringsResourceBundle();
        this._parentTab = tab;
    }

    public void setFileSubSystem(IRemoteFileSubSystem ss) {
        this._ss = ss;
    }

    public void setPaths(String pathsStr) {
        this._paths.clear();
        if (pathsStr != null && pathsStr.length() > 0) {
            String[] paths = pathsStr.split(COMMA);
            int i = 0;
            while (i < paths.length) {
                this._paths.add(paths[i]);
                ++i;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this._viewer.getTable().setEnabled(enabled);
        if (!enabled) {
            this._addButton.setEnabled(enabled);
            this._removeButton.setEnabled(enabled);
            this._upButton.setEnabled(enabled);
            this._downButton.setEnabled(enabled);
        } else {
            this.updateButtonStates((IStructuredSelection)((StructuredSelection)this._viewer.getSelection()));
        }
    }

    public String getPaths() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this._paths.size()) {
            buf.append(this._paths.get(i));
            buf.append(COMMA);
            ++i;
        }
        return buf.toString();
    }

    public Control createContents(Composite parent) {
        super.setShell(parent.getShell());
        Composite c = SystemWidgetHelpers.createComposite((Composite)parent, (int)2);
        c.setLayoutData((Object)new GridData(1808));
        this.createTableViewer(c);
        Composite buttonBar = SystemWidgetHelpers.createComposite((Composite)c, (int)1);
        this._addButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)this._stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.searchPath.add.label"), (Listener)this);
        this._addButton.setToolTipText(this._stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.searchPath.add.tooltip"));
        this._removeButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)this._stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.searchPath.remove.label"), (Listener)this);
        this._removeButton.setToolTipText(this._stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.searchPath.remove.tooltip"));
        this._removeButton.setEnabled(false);
        this._upButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)this._stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.searchPath.up.label"), (Listener)this);
        this._upButton.setToolTipText(this._stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.searchPath.up.label"));
        this._upButton.setEnabled(false);
        this._downButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)this._stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.searchPath.down.label"), (Listener)this);
        this._downButton.setToolTipText(this._stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.searchPath.down.label"));
        this._downButton.setEnabled(false);
        this.updatePaths();
        return this._addButton;
    }

    private void createTableViewer(Composite parent) {
        Group tableComp = SystemWidgetHelpers.createGroupComposite((Composite)parent, (int)1, (String)this._tablePrompt);
        tableComp.setLayout((Layout)new GridLayout());
        tableComp.setLayoutData((Object)new GridData(1808));
        this._viewer = new TableViewer((Composite)tableComp, 2058);
        this._viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Table table = this._viewer.getTable();
        GridData data = GridUtil.createFill();
        data.heightHint = 30;
        data.widthHint = 80;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)table)};
        this._viewer.setCellEditors(cellEditors);
        this._viewer.setCellModifier((ICellModifier)this);
        this._viewer.setColumnProperties(new String[]{this._stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.searchPath")});
        cellEditors[0].setValidator((ICellEditorValidator)this);
        this._viewer.setContentProvider((IContentProvider)new EnginePathTableContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)new EnginePathTableLabelProvider());
    }

    private void removePath(String path) {
        this._paths.remove(path);
        this.updatePaths();
    }

    private void addPath(String path) {
        this._paths.add(path);
        this.updatePaths();
    }

    public void updatePaths() {
        if (this._viewer.getTable().getItemCount() > 0) {
            this._viewer.getTable().removeAll();
        }
        Object[] paths = this._paths.toArray();
        int i = 0;
        while (i < paths.length) {
            this._viewer.add(paths[i]);
            ++i;
        }
        this._parentTab.pathsUpdated();
    }

    public void handleEvent(Event evt) {
        Widget w = evt.widget;
        if (w == this._addButton) {
            SystemSelectRemoteFolderAction action = new SystemSelectRemoteFolderAction(this.getShell());
            action.setDefaultConnection(this._ss.getHost());
            action.setHost(this._ss.getHost());
            action.setShowNewConnectionPrompt(false);
            action.setShowPropertySheet(true, false);
            action.setMultipleSelectionMode(true);
            action.run();
            IRemoteFile[] selectedFolders = action.getSelectedFolders();
            int i = 0;
            while (i < selectedFolders.length) {
                IRemoteFile folder = selectedFolders[i];
                this.addPath(folder.getAbsolutePath());
                ++i;
            }
        } else if (w == this._removeButton) {
            IStructuredSelection sel = (IStructuredSelection)this._viewer.getSelection();
            for (Object obj : sel) {
                this.removePath((String)obj);
            }
            if (this._paths.size() == 0) {
                this._downButton.setEnabled(false);
                this._upButton.setEnabled(false);
                this._removeButton.setEnabled(false);
            }
        } else if (w == this._upButton) {
            IStructuredSelection sel = (IStructuredSelection)this._viewer.getSelection();
            Object first = sel.getFirstElement();
            int curIndex = this._paths.indexOf(first);
            this._paths.remove(first);
            this._paths.add(--curIndex, first);
            this._viewer.getTable().deselectAll();
            this.updatePaths();
            this._viewer.setSelection((ISelection)new StructuredSelection(first));
        } else if (w == this._downButton) {
            IStructuredSelection sel = (IStructuredSelection)this._viewer.getSelection();
            Object first = sel.getFirstElement();
            int curIndex = this._paths.indexOf(first);
            this._paths.remove(first);
            this._paths.add(++curIndex, first);
            this._viewer.getTable().deselectAll();
            this.updatePaths();
            this._viewer.setSelection((ISelection)new StructuredSelection(first));
        }
    }

    protected void updateButtonStates(IStructuredSelection sel) {
        this._addButton.setEnabled(true);
        if (sel.isEmpty()) {
            this._downButton.setEnabled(false);
            this._upButton.setEnabled(false);
            this._removeButton.setEnabled(false);
        } else if (sel.size() == 1) {
            Object first = sel.getFirstElement();
            int index = this._paths.indexOf(first);
            this._downButton.setEnabled(index + 1 != this._paths.size());
            this._upButton.setEnabled(index != 0);
            this._removeButton.setEnabled(true);
        } else {
            this._removeButton.setEnabled(true);
            this._downButton.setEnabled(false);
            this._upButton.setEnabled(false);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateButtonStates(sel);
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        return element;
    }

    public void modify(Object item, String property, Object value) {
        Object element = ((TableItem)item).getData();
        if (!element.equals(value)) {
            int index = this._paths.indexOf(element);
            this._paths.remove(element);
            this._paths.add(index, value);
            this.updatePaths();
        }
    }

    public String isValid(Object value) {
        return null;
    }
}

