/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug.sourceLookup;

import com.ibm.cdz.remote.debug.IUniversalPDTLaunchConstants;
import com.ibm.debug.pdt.core.sourcelocator.RemoteEngineContainer;
import com.ibm.etools.systems.launch.UniversalLaunchUtil;
import com.ibm.etools.systems.launch.sourceLookup.RemoteFolderSourceContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.rse.core.model.IHost;

public class RemotePDTSourcePathComputer
implements ISourcePathComputerDelegate,
IUniversalPDTLaunchConstants {
    private static final String EMPTY = "";
    public static final String ID = "com.ibm.etools.icerse.universal.launch.pdt.sourceLookup.RemotePDTSourcePathComputer";

    public String getId() {
        return ID;
    }

    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        boolean hasAssociatedProject = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.HasAssociatedProject", true);
        String projectName = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.Project", EMPTY);
        if (!hasAssociatedProject || projectName.trim().length() == 0) {
            String systemConnectionProfileName = configuration.getAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionProfileName", EMPTY);
            String systemConnectionAliasName = configuration.getAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", EMPTY);
            IHost systemConnection = UniversalLaunchUtil.getSystemConnection((String)systemConnectionProfileName, (String)systemConnectionAliasName);
            String workingDirectory = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.WorkingDirectory", null);
            if (workingDirectory == null) {
                workingDirectory = "/";
            }
            String sourcePath = UniversalLaunchUtil.createSourcePath((String)workingDirectory, (String)systemConnectionProfileName, (String)systemConnectionAliasName);
            return new ISourceContainer[]{new RemoteFolderSourceContainer(systemConnection, (IPath)new Path(sourcePath), true), new RemoteEngineContainer()};
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return new ISourceContainer[]{new ProjectSourceContainer(project, true), new RemoteEngineContainer()};
    }
}

