/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug.internal;

import com.ibm.cdz.remote.debug.PDTLaunchPlugin;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;

public class ZosUnixPropertyTester
extends PropertyTester {
    private static final String IS_LAUNCHABLE = "isZosUnixFileExecutable";
    private static final String ZOS_UNIX_SUBSYSTEM_ID = "ibm.uss.files";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IRemoteFile rFile;
        if (IS_LAUNCHABLE.equals(property) && receiver instanceof IRemoteFile && ZOS_UNIX_SUBSYSTEM_ID.equals((rFile = (IRemoteFile)receiver).getParentRemoteFileSubSystem().getConfigurationId()) && (rFile.isExecutable() || rFile.isBinary())) {
            IHostFilePermissions permissions = null;
            if (rFile instanceof IAdaptable) {
                IFilePermissionsService service = (IFilePermissionsService)((IAdaptable)rFile).getAdapter(IFilePermissionsService.class);
                try {
                    permissions = service.getFilePermissions(rFile.getHostFile(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (SystemMessageException e) {
                    PDTLaunchPlugin.logError((String)e.getMessage());
                }
            }
            if (permissions == null) {
                permissions = rFile.getPermissions();
            }
            if (permissions != null) {
                boolean canExecute = permissions.getPermission(73);
                return expectedValue.equals(canExecute);
            }
        }
        return false;
    }
}

