/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug.impl;

import com.ibm.cdz.remote.debug.PDTLaunchPlugin;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLStreamMonitor;
import com.ibm.debug.pdt.internal.core.PICLStreamsProxy;
import com.ibm.etools.systems.launch.IRemoteIORedirector;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.rse.subsystems.shells.core.model.RemoteCommandShellOperation;
import org.eclipse.swt.widgets.Display;

public class RemotePDTIORedirector
implements IRemoteIORedirector {
    private IPDTDebugTarget debugTarget = null;
    private IProcess piclProcess = null;
    private PICLStreamsProxy piclStreamsProxy = null;
    private PICLStreamMonitor piclOutputMonitor = null;
    private PICLStreamMonitor piclErrorMonitor = null;
    private RemoteCommandShellOperation remoteCommandShellOperation = null;
    private boolean hasInited = false;
    private Boolean enabled = null;
    private String localInput = null;

    public RemotePDTIORedirector(IPDTDebugTarget debugTarget, RemoteCommandShellOperation remoteCommandShellOperation) {
        this.debugTarget = debugTarget;
        this.remoteCommandShellOperation = remoteCommandShellOperation;
    }

    public boolean init() {
        if (this.hasInited) {
            return true;
        }
        this.hasInited = this.getPICLProcess(this.debugTarget) != null;
        return this.hasInited;
    }

    public void writeOutput(String output) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getPICLProcess(this.debugTarget) == null) {
            return;
        }
        this.piclOutputMonitor = this.getPICLOutputStreamMonitor(this.getPICLProcess(this.debugTarget));
        try {
            if (this.piclOutputMonitor != null) {
                this.piclOutputMonitor.writeText(output);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeError(String error) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getPICLProcess(this.debugTarget) == null) {
            return;
        }
        this.piclErrorMonitor = this.getPICLErrorStreamMonitor(this.getPICLProcess(this.debugTarget));
        try {
            if (this.piclErrorMonitor != null) {
                this.piclErrorMonitor.writeText(error);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeInput(String input) {
        this.localInput = input;
        Display.getDefault().syncExec((Runnable)new Thread(){

            @Override
            public void run() {
                try {
                    RemotePDTIORedirector.this.remoteCommandShellOperation.sendInput(RemotePDTIORedirector.this.localInput);
                }
                catch (Exception e) {
                    PDTLaunchPlugin.logError((String)"RemotePDTInputProxy.run()", (Throwable)e);
                }
            }
        });
    }

    private IProcess getPICLProcess(IPDTDebugTarget debugTarget) {
        if (this.piclProcess == null) {
            this.piclProcess = debugTarget.getProcess();
        }
        return this.piclProcess;
    }

    private PICLStreamsProxy getPICLStreamsProxy(IProcess process) {
        if (process == null) {
            return null;
        }
        if (this.piclStreamsProxy == null && process.getStreamsProxy() instanceof PICLStreamsProxy) {
            this.piclStreamsProxy = (PICLStreamsProxy)process.getStreamsProxy();
        }
        return this.piclStreamsProxy;
    }

    private PICLStreamMonitor getPICLOutputStreamMonitor(IProcess process) {
        if (this.piclOutputMonitor != null) {
            return this.piclOutputMonitor;
        }
        if (this.getPICLStreamsProxy(process) == null) {
            return null;
        }
        IStreamMonitor streamMonitor = this.getPICLStreamsProxy(process).getOutputStreamMonitor();
        if (streamMonitor instanceof PICLStreamMonitor) {
            return (PICLStreamMonitor)streamMonitor;
        }
        return null;
    }

    private PICLStreamMonitor getPICLErrorStreamMonitor(IProcess process) {
        if (this.piclErrorMonitor != null) {
            return this.piclErrorMonitor;
        }
        if (this.getPICLStreamsProxy(process) == null) {
            return null;
        }
        IStreamMonitor streamMonitor = this.getPICLStreamsProxy(process).getErrorStreamMonitor();
        if (streamMonitor instanceof PICLStreamMonitor) {
            return (PICLStreamMonitor)streamMonitor;
        }
        return null;
    }

    public PICLStreamsProxy getPICLStreamsProxy() {
        if (this.piclStreamsProxy != null) {
            return this.piclStreamsProxy;
        }
        return this.getPICLStreamsProxy(this.getPICLProcess(this.debugTarget));
    }

    public boolean isEnabled() {
        if (this.init()) {
            if (this.enabled == null && this.getPICLStreamsProxy() != null) {
                this.enabled = !this.getPICLStreamsProxy().isSupported();
            }
            return this.enabled != null ? this.enabled : false;
        }
        return false;
    }
}

