/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug.impl;

import com.ibm.cdz.remote.debug.IRemotePDTCommandLauncher;
import com.ibm.cdz.remote.debug.PDTLaunchPlugin;
import com.ibm.cdz.remote.debug.RemotePDTInputProxy;
import com.ibm.cdz.remote.debug.impl.CommandShellDiagnosticListener;
import com.ibm.cdz.remote.debug.impl.RemotePDTIORedirector;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.etools.systems.launch.IRemoteCommandLauncherStateListener;
import com.ibm.etools.systems.launch.IRemoteIORedirector;
import com.ibm.etools.systems.launch.IRemoteOutputProxyEventListener;
import com.ibm.etools.systems.launch.RemoteCommandLauncherStateEvent;
import com.ibm.etools.systems.launch.RemoteCommandShellOperationHelper;
import com.ibm.etools.systems.launch.RemoteOutputProxyEvent;
import com.ibm.etools.systems.launch.RemoteProcess;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.model.RemoteCommandShellOperation;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.swt.widgets.Shell;

public class RemoteDBXCommandLauncherImpl
implements IRemotePDTCommandLauncher,
IRemoteOutputProxyEventListener {
    private Shell shell = null;
    private IHost connection = null;
    private String cmdString = null;
    private String workingPath = null;
    private IRemoteCmdSubSystem cmdSubSystem = null;
    private IRemoteIORedirector remoteIORedirector = null;
    private IPDTDebugTarget debugTarget = null;
    private RemotePDTInputProxy remoteInputProxy = null;
    private static int FAILED = -1;
    private boolean commandCompleted = false;
    private IRemoteCommandShell defaultShell = null;
    private RemoteCommandShellOperationHelper remoteCommandHelper = null;
    private Vector<IRemoteCommandLauncherStateListener> listeners = null;
    private boolean _environmentSet = false;
    private String[] _environmentNames;
    private String[] _environmentValues;

    public RemoteDBXCommandLauncherImpl(Shell shell, IHost connection, String cmdString, String workingPath) {
        this.shell = shell;
        this.connection = connection;
        this.cmdString = cmdString;
        this.workingPath = workingPath;
    }

    public int runCommand(IProgressMonitor arg0) {
        this.cmdSubSystem = RemoteCommandHelpers.getCmdSubSystem((IHost)this.connection);
        try {
            IRemoteFileSubSystem fs = RemoteFileUtility.getFileSubSystem((IHost)this.connection);
            IRemoteFile remoteFile = fs.getRemoteFileObject(this.workingPath, (IProgressMonitor)new NullProgressMonitor());
            this.remoteCommandHelper = new RemoteCommandShellOperationHelper(this.shell, this.cmdSubSystem, remoteFile, null);
            this.remoteIORedirector = new RemotePDTIORedirector(this.debugTarget, (RemoteCommandShellOperation)this.remoteCommandHelper);
            this.remoteCommandHelper.setRemoteIORedirector(this.remoteIORedirector);
            this.remoteCommandHelper.addListener((IRemoteOutputProxyEventListener)this);
            if (this._environmentSet) {
                this.cmdSubSystem.setEnvironmentVariableList(this._environmentNames, this._environmentValues);
            }
            this.defaultShell = this.remoteCommandHelper.run();
            CommandShellDiagnosticListener listener = new CommandShellDiagnosticListener(this.defaultShell, this.debugTarget);
            listener.start();
            this.remoteCommandHelper.sendCommand(this.cmdString + ";exit");
            this.remoteInputProxy = new RemotePDTInputProxy(this.shell, this.remoteIORedirector, this.defaultShell);
            this.remoteInputProxy.start();
        }
        catch (Exception e) {
            PDTLaunchPlugin.logError((String)"Run Remote Command failed", (Throwable)e);
            return FAILED;
        }
        return 0;
    }

    public int exitValue() throws IllegalThreadStateException {
        return 0;
    }

    public boolean isCommandCompleted() {
        return this.commandCompleted;
    }

    public void destory() {
        if (!this.commandCompleted) {
            this.commandCompleted = true;
        }
        this.cleanup();
    }

    protected void cleanup() {
        this.fireEvent(new RemoteCommandLauncherStateEvent(2, this.cmdString, (Object)this));
        if (this.remoteInputProxy != null) {
            this.remoteInputProxy.stopListen();
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setCommandString(String cmdString) {
        this.cmdString = cmdString;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    public void addListener(IRemoteCommandLauncherStateListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IRemoteCommandLauncherStateListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireEvent(RemoteCommandLauncherStateEvent event) {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.get(i) != null) {
                this.listeners.get(i).handleOutputEvent(event);
            }
            ++i;
        }
    }

    public void handleOutputEvent(RemoteOutputProxyEvent event) {
        if (event.getEventSource() instanceof RemoteCommandShellOperationHelper) {
            RemoteCommandShellOperationHelper source = (RemoteCommandShellOperationHelper)event.getEventSource();
            if (source != this.remoteCommandHelper) {
                return;
            }
        } else {
            return;
        }
        if (event.getType() == "COMMAND_COMPLETED") {
            this.cleanup();
            if (this.remoteCommandHelper != null) {
                this.remoteCommandHelper.removeListener((IRemoteOutputProxyEventListener)this);
                try {
                    this.cmdSubSystem.cancelShell((Object)this.defaultShell, (IProgressMonitor)new NullProgressMonitor());
                    this.cmdSubSystem.removeShell((Object)this.defaultShell);
                }
                catch (Exception e) {
                    PDTLaunchPlugin.logError((String)"RemoteCommandLauncherImpl.handleOutputEvent: failed to cancel shell", (Throwable)e);
                }
            }
        }
    }

    public void setEnvironmentVariableList(String[] environmentNames, String[] environmentValues) {
        this._environmentNames = Arrays.copyOf(environmentNames, environmentNames.length);
        this._environmentValues = Arrays.copyOf(environmentValues, environmentValues.length);
        this._environmentSet = true;
    }

    @Override
    public void setDebugTarget(IPDTDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
    }

    public RemoteProcess getProcess() {
        return null;
    }

    public void destory(boolean destoryAssociatedProcess) {
    }
}

