/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug.impl;

import com.ibm.cdz.remote.debug.PDTLaunchPlugin;
import com.ibm.cdz.remote.debug.internal.RemotePDTLaunchMessages;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.ftt.debug.ui.CCLaunchUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.swt.widgets.Display;

public class CommandShellDiagnosticListener
extends Thread {
    private static final String NEWLINE = "\n";
    public static final int DBX_NO_ERROR = 0;
    public static final int DBX_ERROR = 1;
    public static final int DBX_ERROR_FAILED_READING_FROM_SOCKET = 2;
    public static final int DBX_ERROR_DLL_VERSION_MISMATCH = 3;
    public static final int CEE_ERROR = 4;
    public static final int UNEXPECTED_ERROR = 5;
    private IRemoteCommandShell _cmdShell;
    private IPDTDebugTarget _debugTarget;

    public CommandShellDiagnosticListener(IRemoteCommandShell cmdShell, IPDTDebugTarget debugTarget) {
        this._cmdShell = cmdShell;
        this._debugTarget = debugTarget;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (this._cmdShell != null && this._cmdShell.isActive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this._debugTarget != null) {
            boolean isCC = this._debugTarget.getLaunch().getLaunchMode().equals(CCLaunchUtils.getCCInfoProvider().getCoverageMode());
            boolean isTerminated = this._debugTarget.isTerminated();
            boolean isEngineStillAround = isCC ? false : this._debugTarget.getDebugEngine() != null;
            LaunchError errorState = this.checkShellForError();
            if (!isTerminated || isEngineStillAround) {
                try {
                    if (errorState == null) {
                        errorState = new LaunchError(5, this.getOutputAsString());
                    }
                    if (isEngineStillAround) {
                        this._debugTarget.terminate();
                    } else if (this._debugTarget.canTerminate()) {
                        try {
                            this._debugTarget.terminate();
                        }
                        catch (Exception e) {
                            if (this._debugTarget instanceof PDTDebugTarget) {
                                ((PDTDebugTarget)this._debugTarget).doCleanup();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    PDTLaunchPlugin.logError((String)"unexpected error", (Throwable)e);
                }
            }
            if (errorState != null && (isEngineStillAround || isCC)) {
                ReportErrorRunnable report = new ReportErrorRunnable(errorState);
                Display.getDefault().asyncExec((Runnable)report);
            }
        }
        if (this._cmdShell != null && this._cmdShell.getCommandSubSystem() != null) {
            try {
                this._cmdShell.getCommandSubSystem().cancelShell((Object)this._cmdShell, (IProgressMonitor)new NullProgressMonitor());
                this._cmdShell.getCommandSubSystem().removeShell((Object)this._cmdShell);
            }
            catch (Exception e) {
                PDTLaunchPlugin.logError((String)"RemoteCommandLauncherImpl.handleOutputEvent: failed to cancel shell", (Throwable)e);
            }
        }
    }

    protected String getOutputAsString() {
        StringBuffer buf = new StringBuffer();
        Object[] output = this._cmdShell.listOutput();
        int i = 0;
        while (i < output.length) {
            IRemoteOutput line = (IRemoteOutput)output[i];
            if (line != null) {
                String text = line.getText();
                int tagIndex = text.indexOf("BEGIN-END-TAG");
                if (tagIndex > -1) {
                    int semi = text.indexOf(";");
                    if (semi > 0 && semi < tagIndex) {
                        text = text.substring(0, semi);
                        buf.append(text);
                        buf.append(NEWLINE);
                    }
                } else {
                    buf.append(text);
                    buf.append(NEWLINE);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    protected LaunchError checkShellForError() {
        LaunchError error = null;
        Object[] output = this._cmdShell.listOutput();
        int i = 0;
        while (i < output.length) {
            String text;
            IRemoteOutput line = (IRemoteOutput)output[i];
            if (line != null && (error = this.checkLineForError(text = line.getText())) != null) {
                return error;
            }
            ++i;
        }
        return error;
    }

    protected LaunchError checkLineForError(String text) {
        if (text.startsWith("FDBX5017:")) {
            return new LaunchError(2, text);
        }
        if (text.startsWith("FDBX6407:")) {
            return new LaunchError(3, text);
        }
        if (text.startsWith("FDBX")) {
            return new LaunchError(1, text);
        }
        if (text.startsWith("CEE")) {
            return new LaunchError(4, text);
        }
        if (text.indexOf("Permission denied") > -1) {
            return new LaunchError(5, text);
        }
        return null;
    }

    public static class LaunchError {
        private String _hostMessage;

        public LaunchError(int state, String hostMessage) {
            this._hostMessage = hostMessage;
        }

        public String getHostMessage() {
            return this._hostMessage;
        }
    }

    public static class ReportErrorRunnable
    implements Runnable {
        private LaunchError _diagnostic;

        public ReportErrorRunnable(LaunchError diagnostic) {
            this._diagnostic = diagnostic;
        }

        @Override
        public void run() {
            PICLDebugPlugin.showMessageDialog(null, (String)NLS.bind((String)RemotePDTLaunchMessages.CRRDG8300, (Object)this._diagnostic.getHostMessage()), (boolean)true);
        }
    }
}

