/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug;

import com.ibm.cdz.remote.debug.IUniversalPDTLaunchConstants;
import com.ibm.cdz.remote.debug.PDTLaunchPlugin;
import com.ibm.cdz.remote.debug.UniversalPDTLaunchEnginePathPreference;
import com.ibm.cdz.remote.debug.internal.RemotePDTLaunchMessages;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.etools.systems.launch.UniversalLaunchUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class UniversalPDTLaunchShortcut
implements ILaunchShortcut,
IUniversalPDTLaunchConstants {
    private static final String PERIOD = ".";
    private static final String EMPTY = "";
    protected ResourceBundle stringsResourceBundle = PDTLaunchPlugin.getStringsResourceBundle();
    private String mode;
    private boolean promptMode = false;

    public void searchAndLaunch(Object[] selectedElements, String mode) {
        String projectName = EMPTY;
        if (selectedElements != null && selectedElements.length > 0) {
            IProject cproject = null;
            int i = 0;
            while (i < selectedElements.length) {
                IResource resource;
                if (selectedElements[i] instanceof IAdaptable && (resource = (IResource)((IAdaptable)selectedElements[i]).getAdapter(IResource.class)) != null && (cproject = resource.getProject()) != null) {
                    projectName = resource.getFullPath().segment(0);
                    break;
                }
                ++i;
            }
        }
        ILaunchConfiguration config = this.findLaunchConfiguration(projectName, mode);
        this.showLaunchConfigurationsDialog(config, mode);
    }

    protected ILaunchConfiguration findLaunchConfiguration(String projectName, String mode) {
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (projectName.trim() != EMPTY && config.getAttribute("com.ibm.cdz.remote.debug.attr.Project", EMPTY).equals(projectName)) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDTLaunchPlugin.logError((String)this.stringsResourceBundle.getString("launch.shortcut.Launch_failed__unexpected_exception"), (Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(projectName);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration findLaunchConfiguration(String typeName, String workingPath, IHost systemConnection) {
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (typeName.trim() != EMPTY && config.getAttribute("com.ibm.cdz.remote.debug.attr.Main", EMPTY).equals(typeName) && config.getAttribute("com.ibm.cdz.remote.debug.attr.WorkingDirectory", PERIOD).equals(workingPath)) {
                    String connectionProfile = config.getAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionProfileName", EMPTY);
                    String connectionAlias = config.getAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", EMPTY);
                    if (connectionProfile.equals(systemConnection.getSystemProfileName()) && connectionAlias.equals(systemConnection.getAliasName())) {
                        candidateConfigs.add(config);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDTLaunchPlugin.logError((String)this.stringsResourceBundle.getString("launch.shortcut.Launch_failed__unexpected_exception"), (Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return null;
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, this.mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.shortcut.dialog.selectLC.label"));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(String projectName) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getLaunchConfigType();
            ILaunchConfigurationWorkingCopy workingCopy = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(projectName));
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.HasAssociatedProject", true);
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.Project", projectName);
            config = workingCopy.doSave();
            this.setPromptMode(true);
        }
        catch (CoreException ce) {
            PDTLaunchPlugin.logError((String)"failed to create launch configuration", (Throwable)ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("com.ibm.cdz.remote.debug.UniversalPDTLaunch");
    }

    protected void showLaunchConfigurationsDialog(ILaunchConfiguration config, String mode) {
        StructuredSelection selection = new StructuredSelection((Object)config);
        ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PDTLaunchPlugin.getActiveWorkbenchShell(), (IStructuredSelection)selection, (String)group.getIdentifier());
    }

    protected void searchAndLaunchFromRSE(IStructuredSelection selection, ISystemRemoteElementAdapter systemRemoteFileAdapter, String mode) {
        ILaunchConfiguration config;
        Object selectedObject = selection.getFirstElement();
        if (!(selectedObject instanceof IRemoteFile)) {
            PICLDebugPlugin.showMessageDialog(null, (String)RemotePDTLaunchMessages.CRRDG8301, (boolean)true);
            return;
        }
        IRemoteFile result = (IRemoteFile)selectedObject;
        IRSESystemType systemType = result.getHost().getSystemType();
        String systemId = systemType.getId();
        if (systemId.equalsIgnoreCase("org.eclipse.rse.systemtype.windows") || systemId.equalsIgnoreCase("org.eclipse.rse.systemtype.linux") || systemId.equalsIgnoreCase("org.eclipse.rse.systemtype.local") || systemId.equalsIgnoreCase("org.eclipse.rse.systemtype.iseries")) {
            if (mode.equalsIgnoreCase("debug")) {
                PICLDebugPlugin.showMessageDialog(null, (String)RemotePDTLaunchMessages.CRRDG8301, (boolean)true);
            }
            return;
        }
        String typeName = result.getName();
        String defaultWorkingDir = result.getParentPath();
        if (defaultWorkingDir == null) {
            defaultWorkingDir = result.getRoot();
        }
        if ((config = this.findLaunchConfiguration(typeName, defaultWorkingDir, result.getHost())) == null) {
            config = this.createConfiguration(typeName, defaultWorkingDir, result.getHost());
        }
        try {
            if (!this.promptMode) {
                config.launch(mode, null);
            } else {
                this.showLaunchConfigurationsDialog(config, mode);
            }
        }
        catch (CoreException e) {
            PDTLaunchPlugin.logError((String)"failed to launch configuration:", (Throwable)e);
        }
    }

    protected ILaunchConfiguration createConfiguration(String typeName, String path, IHost connection) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getLaunchConfigType();
            ILaunchConfigurationWorkingCopy workingCopy = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(typeName));
            boolean hasAssociatedProject = false;
            this.setDefaultAttributes(workingCopy, hasAssociatedProject);
            workingCopy.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionProfileName", connection.getSystemProfileName());
            workingCopy.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", connection.getAliasName());
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.Main", typeName);
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.WorkingDirectory", path);
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.ProgramArguments", EMPTY);
            IPreferenceStore preferenceStore = PDTLaunchPlugin.getDefault().getPreferenceStore();
            boolean preferenceUseDebugTool = preferenceStore.getBoolean("com.ibm.cdz.remote.debug.preference.useDebugTool");
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.UseDebugTool", preferenceUseDebugTool);
            String preferenceEnginePath = preferenceStore.getString("com.ibm.cdz.remote.debug.preference.engineGroup");
            if (preferenceEnginePath.equals("com.ibm.cdz.remote.debug.preference.engineSpecify")) {
                workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.AutoResolveDebugEnginePath", false);
                String preferencedPath = new UniversalPDTLaunchEnginePathPreference(preferenceStore).getPreferenceEnginePath(connection.getAliasName());
                if (preferencedPath != null) {
                    workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.DebugEnginePath", preferencedPath);
                }
            } else {
                workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.AutoResolveDebugEnginePath", true);
            }
            boolean preferenceStopInMain = preferenceStore.getBoolean("com.ibm.cdz.remote.debug.preference.stopInMain");
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.stopInMain", preferenceStopInMain);
            config = workingCopy.doSave();
        }
        catch (CoreException ce) {
            PDTLaunchPlugin.logError((String)"failed to create launch configuration", (Throwable)ce);
        }
        return config;
    }

    protected void setDefaultAttributes(ILaunchConfigurationWorkingCopy workingCopy, boolean hasAssociatedProject) {
        workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.HasAssociatedProject", hasAssociatedProject);
        if (!hasAssociatedProject) {
            workingCopy.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionProfileName", EMPTY);
            workingCopy.setAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", EMPTY);
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.Project", EMPTY);
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.Main", EMPTY);
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.WorkingDirectory", EMPTY);
            workingCopy.setAttribute("com.ibm.cdz.remote.debug.attr.ENGINE", 0);
        }
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return PDTLaunchPlugin.getActiveWorkbenchShell();
    }

    public void launch(IEditorPart editor, String mode) {
        this.mode = mode;
        IEditorInput input = editor.getEditorInput();
        this.searchAndLaunch(new Object[]{input}, mode);
    }

    public void launch(ISelection selection, String mode) {
        this.mode = mode;
        if (selection instanceof IStructuredSelection) {
            ISystemRemoteElementAdapter systemRemoteFileAdapter = UniversalLaunchUtil.getRSESelection((IStructuredSelection)((IStructuredSelection)selection));
            if (systemRemoteFileAdapter != null) {
                this.searchAndLaunchFromRSE((IStructuredSelection)selection, systemRemoteFileAdapter, mode);
            } else {
                this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
            }
        } else {
            PICLDebugPlugin.showMessageDialog(null, (String)RemotePDTLaunchMessages.CRRDG8301, (boolean)true);
        }
    }

    public void setPromptMode(boolean needPrompt) {
        this.promptMode = needPrompt;
    }

    public boolean getPromptMode() {
        return this.promptMode;
    }
}

