/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug;

import com.ibm.cdz.remote.debug.IUniversalPDTLaunchConstants;
import com.ibm.cdz.remote.debug.ui.EnginePathVariable;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;

public class UniversalPDTLaunchEnginePathPreference
implements IUniversalPDTLaunchConstants {
    public static final String INTERNAL_SEPARATOR = "@_@";
    public static final String ENTRY_SEPARATOR = "!_!";
    private IPreferenceStore preferenceStore = null;
    private String preferenceKey = null;
    private Vector<Object> preferenceEnginePaths = null;

    public UniversalPDTLaunchEnginePathPreference(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
        this.preferenceKey = "com.ibm.cdz.remote.debug.preference.encodedEnginePaths";
    }

    public void init() {
        this.preferenceEnginePaths.removeAllElements();
    }

    public void addEnginePath(String hostName, String enginePath) {
        this.getPreferenceEnginePaths().add(new EnginePathVariable(hostName, enginePath));
    }

    public String getPreferenceEnginePath(String systemConnectionAliasName) {
        this.preferenceEnginePaths = this.getPreferenceEnginePaths();
        if (this.preferenceEnginePaths == null) {
            return null;
        }
        int i = 0;
        while (i < this.preferenceEnginePaths.size()) {
            if (((EnginePathVariable)this.preferenceEnginePaths.get(i)).getHostName().equalsIgnoreCase(systemConnectionAliasName)) {
                return ((EnginePathVariable)this.preferenceEnginePaths.get(i)).getEnginePath();
            }
            ++i;
        }
        return null;
    }

    public void savePreferenceEnginePath() {
        if (this.preferenceEnginePaths == null) {
            return;
        }
        Object encodedEnginePaths = "";
        int i = 0;
        while (i < this.preferenceEnginePaths.size()) {
            if (i > 0) {
                encodedEnginePaths = (String)encodedEnginePaths + ENTRY_SEPARATOR;
            }
            encodedEnginePaths = (String)encodedEnginePaths + ((EnginePathVariable)this.preferenceEnginePaths.get(i)).getHostName() + INTERNAL_SEPARATOR + ((EnginePathVariable)this.preferenceEnginePaths.get(i)).getEnginePath();
            ++i;
        }
        this.preferenceStore.setValue(this.preferenceKey, (String)encodedEnginePaths);
    }

    public Vector<Object> getPreferenceEnginePaths() {
        if (this.preferenceEnginePaths != null) {
            return this.preferenceEnginePaths;
        }
        this.preferenceEnginePaths = new Vector();
        return this.retrievePreferenceEnginePaths();
    }

    protected Vector<Object> retrievePreferenceEnginePaths() {
        String encodedEnginePaths = this.preferenceStore.getString(this.preferenceKey);
        String[] entries = null;
        if (encodedEnginePaths != null && encodedEnginePaths.length() > 0) {
            entries = encodedEnginePaths.split(ENTRY_SEPARATOR);
        }
        if (entries == null) {
            return null;
        }
        String[] singleEntry = null;
        int i = 0;
        while (i < entries.length) {
            singleEntry = entries[i].split(INTERNAL_SEPARATOR);
            this.preferenceEnginePaths.add(new EnginePathVariable(singleEntry[0], singleEntry[1]));
            ++i;
        }
        return this.preferenceEnginePaths;
    }
}

