/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug;

import com.ibm.cdz.remote.debug.IUniversalPDTLaunchConstants;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.framework.BundleContext;

public class PDTLaunchPlugin
extends SystemBasePlugin
implements IUniversalPDTLaunchConstants {
    private static PDTLaunchPlugin plugin;
    private static ResourceBundle stringsResourceBundle;
    public static final String PLUGIN_ID = "com.ibm.cdz.remote.debug";
    public static final String HELPPREFIX = "com.ibm.cdz.remote.debug.";
    private static final String TRACING = "/debug/tracing";
    private static final String ERROR_LOGGING = "/debug/error";
    private static final String STRING_RESOURCES_FILENAME = "RemotePDTLaunchResources";
    private static boolean errorLogging;
    private static boolean tracing;
    public static final int DBG = 0;
    public static final int ERR = 1;

    static {
        stringsResourceBundle = null;
        errorLogging = false;
        tracing = false;
    }

    public PDTLaunchPlugin() {
        if (plugin == null) {
            plugin = this;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.isDebugging()) {
            String id = PLUGIN_ID;
            String test = Platform.getDebugOption((String)(id + TRACING));
            if (test != null) {
                tracing = test.equalsIgnoreCase(Boolean.toString(true));
            }
            if ((test = Platform.getDebugOption((String)(id + ERROR_LOGGING))) != null) {
                errorLogging = test.equalsIgnoreCase(Boolean.toString(true));
            }
        }
        stringsResourceBundle = ResourceBundle.getBundle(STRING_RESOURCES_FILENAME);
        this.getPreferenceStore().setDefault("com.ibm.cdz.remote.debug.preference.stopInMain", true);
        this.getPreferenceStore().setDefault("com.ibm.cdz.remote.debug.preference.ipGroup", "com.ibm.cdz.remote.debug.preference.engineAutoMatic");
        this.getPreferenceStore().setDefault("com.ibm.cdz.remote.debug.preference.useDebugTool", true);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static PDTLaunchPlugin getInstance() {
        return plugin;
    }

    public static PDTLaunchPlugin getDefault() {
        return plugin;
    }

    public static String getPluginID() {
        return PLUGIN_ID;
    }

    public static boolean isErrorLoggingON() {
        return errorLogging;
    }

    public static boolean isTracingON() {
        return tracing;
    }

    public static ResourceBundle getStringsResourceBundle() {
        return stringsResourceBundle;
    }

    public static String getString(String key) {
        return PDTLaunchPlugin.getStringsResourceBundle().getString(key);
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWindow = PDTLaunchPlugin.getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        return activeWindow.getActivePage();
    }

    protected void initializeImageRegistry() {
        String path = PDTLaunchPlugin.getIconPath();
        this.putImageInRegistry("com.ibm.cdz.remote.debug.full/obj16/tab_main.icon", path + "full/obj16/tab_main.png");
        this.putImageInRegistry("com.ibm.cdz.remote.debug.full/obj16/tab_arguments.icon", path + "full/obj16/tab_arguments.png");
        this.putImageInRegistry("com.ibm.cdz.remote.debug.full/obj16/tab_adv.icon", path + "full/obj16/tab_adv.png");
        this.putImageInRegistry("full/obj16/systemfolder.png", path + "full/obj16/systemfolder.png");
    }
}

