/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.help.preferenceharvester;

import com.ibm.ccl.help.preferenceharvester.Activator;
import com.ibm.ccl.help.preferenceharvester.SiteInfoParser;
import com.ibm.ccl.help.preferenceharvester.WARDeployer;
import com.ibm.ut.help.common.connector.PlatformConnector;
import com.ibm.ut.help.common.ic.IC;
import com.ibm.ut.help.common.prefs.ICPreferences;
import com.ibm.ut.help.common.web.URLUtil;
import com.ibm.ut.help.parser.json.IJSONHandler;
import com.ibm.ut.help.parser.json.JSONParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;

public class LocalHelp {
    public static final int WAR_MODE = 1;
    public static final int EMBEDDED_MODE = 2;
    static final String LOCAL_HELP_WAR_LOCATION = "help.war";
    static final String LOCAL_HELP_WAR_TEMPFILES = "work";
    private static int mode = -1;
    private static String helpType = System.getProperty("help.type.default") != null ? System.getProperty("help.type.default") : "remote";
    private static String enterpriseURL = System.getProperty("help.URL.default");

    public static String getHelpType() {
        return helpType;
    }

    public static int getHelpMode() {
        if (mode == -1) {
            int n = mode = LocalHelp.getFile() == null ? 2 : 1;
        }
        if (mode == 2) {
            System.setProperty("eclipse.p2.profile", "profile");
        }
        return mode;
    }

    public static IC getEnterpriseIC() {
        if (enterpriseURL == null) {
            return null;
        }
        try {
            return new IC("Internal Site", enterpriseURL, LocalHelp.getHelpType().equals("custom"));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static IC getDefaultLocalIC() throws MalformedURLException {
        return null;
    }

    public static IC getLocalIC() throws MalformedURLException {
        return null;
    }

    public static void setLocalIC(IC ic) {
        List ics = ICPreferences.getICs();
        int i = 0;
        while (i < ics.size()) {
            if (((IC)ics.get(i)).getHost().equals("localhost") || ((IC)ics.get(i)).getHost().equals("127.0.0.1")) {
                ics.set(i, ic);
                ICPreferences.setICs((List)ics);
                break;
            }
            ++i;
        }
    }

    public static boolean isEnabled() throws MalformedURLException {
        return LocalHelp.getHelpMode() == 2;
    }

    public static boolean isExtracted() {
        return new File(LocalHelp.getWorkFolder(), "webapp").exists();
    }

    public static File getFile() {
        String warLocation = System.getProperty(LOCAL_HELP_WAR_LOCATION);
        if (warLocation == null) {
            Activator.logWarning("help.war property not defined in config.ini");
            File work = new File(String.valueOf(Activator.getDefault().getStateLocation()) + "/help/");
            File war = new File(work, LOCAL_HELP_WAR_LOCATION);
            if (!war.exists()) {
                try {
                    WARDeployer.copyWarTo(work);
                }
                catch (IOException e) {
                    Activator.logWarning("help.war was not extracted from a warcontainer plugin", e);
                    return null;
                }
            }
            if (!war.exists()) {
                Activator.logWarning("help.war was not extracted from a warcontainer plugin");
                return null;
            }
            return war;
        }
        if (warLocation.equals("embedded")) {
            return null;
        }
        return new File(warLocation);
    }

    public static File getWorkFolder() {
        File configDir = new File(Platform.getConfigurationLocation().getURL().getFile(), "com.ibm.ut.ic.server/help");
        return configDir;
    }

    public static InputStream post(String path, Properties props) throws MalformedURLException, IOException {
        return URLUtil.postStream((URL)new URL(PlatformConnector.getWARBaseURL() + path), (Properties)props);
    }

    public static List<?> getInstalledCategories() throws IOException {
        URL url = new URL(LocalHelp.getLocalIC().getHref() + "/updater/config?op=SiteInfo&link=local");
        SiteInfoParser info = new SiteInfoParser();
        JSONParser parser = new JSONParser();
        parser.parse(URLUtil.getStream((URL)url), (IJSONHandler)info);
        return info.getCategories();
    }
}

