/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.ic.server.jobs;

import com.ibm.ut.help.state.State;
import com.ibm.ut.ic.server.Activator;
import com.ibm.ut.ic.server.LocalServer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StateMonitorJob
extends Job {
    private String xid;
    private boolean stop;
    boolean showCancelDialog = true;

    public StateMonitorJob(String xid, String installPhrase) {
        super("Monitoring Local Server");
        this.xid = xid;
        this.stop = false;
    }

    public void stopMonitoring() {
        this.stop = true;
    }

    public IStatus run(IProgressMonitor monitor) {
        int total = 0;
        int worked = 0;
        while (!this.stop) {
            State state = LocalServer.getState(this.xid);
            if (monitor.isCanceled()) {
                if (this.handleCancel()) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                monitor.setCanceled(false);
            }
            if (state != null) {
                int percent = state.getPercent();
                worked = percent - total;
                total += worked;
                monitor.worked(worked);
                if (!state.getMessage().equals("") && !state.getMessage().equalsIgnoreCase("Network failure")) {
                    monitor.subTask(state.getMessage());
                }
            }
            this.sleep(1000);
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public boolean handleCancel() {
        int cancel = 0;
        if (this.showCancelDialog) {
            cancel = Activator.displayCancelWarningDialog();
            this.showCancelDialog = false;
        }
        if (cancel == 0) {
            LocalServer.cancelOperation(this.xid);
            return true;
        }
        return false;
    }

    public void sleep(int mill) {
        try {
            Thread.sleep(mill);
        }
        catch (Exception exception) {}
    }
}

