/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.ic.server.jobs;

import com.ibm.ccl.help.preferenceharvester.ICManager;
import com.ibm.ccl.help.preferenceharvester.LocalHelp;
import com.ibm.ut.help.common.ic.IC;
import com.ibm.ut.help.common.prefs.ICPreferences;
import com.ibm.ut.help.common.reflect.Reflect;
import com.ibm.ut.help.common.site.Site;
import com.ibm.ut.help.common.site.SiteManager;
import com.ibm.ut.help.common.web.HTMLUtil;
import com.ibm.ut.help.common.web.URLUtil;
import com.ibm.ut.help.state.State;
import com.ibm.ut.ic.server.Activator;
import com.ibm.ut.ic.server.LocalServer;
import com.ibm.ut.ic.server.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.internal.webapp.servlet.TocServlet;

public class InitialContentJob
extends Job {
    public InitialContentJob() {
        super(Messages.INSTALL_UPDATES);
    }

    protected IStatus run(IProgressMonitor monitor) {
        List<Site> sites;
        try {
            if (ICManager.remoteICsEnabled()) {
                return Status.OK_STATUS;
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        if (!LocalServer.getInstance().isStarted()) {
            return Status.OK_STATUS;
        }
        if (System.getProperty("help.auto.install") != null && System.getProperty("help.auto.install").equalsIgnoreCase("false")) {
            this.checkMissingContent();
            return Status.OK_STATUS;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((sites = this.findSites()).isEmpty()) {
            return Status.OK_STATUS;
        }
        List suppliers = this.getSuppliers();
        monitor.beginTask("", sites.size());
        int s = 0;
        while (s < sites.size()) {
            try {
                if (!suppliers.contains(sites.get(s).toString())) {
                    Activator.setTask(monitor, Messages.INSTALLING_HELP + " (" + sites.get(s).getName() + ")");
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)sites.size()).split(1);
                    this.installSite(sites.get(s), (IProgressMonitor)subMonitor);
                }
            }
            catch (Exception e) {
                Activator.logWarning("Could not parse " + String.valueOf(sites.get(s)), e);
            }
            ++s;
        }
        this.checkMissingContent();
        monitor.done();
        return Status.OK_STATUS;
    }

    public List<Site> findSites() {
        ArrayList<Site> list = new ArrayList<Site>();
        List ics = ICPreferences.getContributedICs();
        int i = 0;
        while (i < ics.size()) {
            String href = ((IC)ics.get(i)).getHref();
            if (!href.contains("_")) {
                Site site = new Site();
                site.setName(((IC)ics.get(i)).getName());
                site.setURI(href + "/site");
                list.add(site);
            } else {
                if (href.endsWith("/")) {
                    href = href.substring(0, href.length() - 1);
                }
                String id = href.substring(href.lastIndexOf("/") + 1);
                String version = id.substring(id.indexOf("_") + 1);
                id = id.substring(0, id.indexOf("_"));
                List sites = SiteManager.getVersionSitesById((String)id);
                int s = 0;
                while (s < sites.size()) {
                    if (((Site)sites.get(s)).getName().equals(version)) {
                        list.add((Site)sites.get(s));
                        break;
                    }
                    ++s;
                }
            }
            ++i;
        }
        return list;
    }

    public void checkMissingContent() {
        List categories = new ArrayList();
        try {
            categories = LocalHelp.getInstalledCategories();
        }
        catch (IOException e) {
            Activator.logError("Could not get installed categories", e);
        }
        if (categories.size() == 0) {
            Activator.displayHelpWarningDialog();
        }
    }

    public void installSite(Site site, IProgressMonitor monitor) {
        monitor.beginTask("", 100);
        int total = 0;
        String xid = UUID.randomUUID().toString();
        ConnectionThread ct = new ConnectionThread(xid, site);
        ct.start();
        while (!ct.isComplete()) {
            State state = LocalServer.getState(xid);
            if (state == null) {
                Activator.logWarning("Unable to connect to Local Server during InitialContentJob");
                monitor.done();
                return;
            }
            if (Activator.LOG_INFO) {
                Activator.setTask(monitor, state.getJob() + " (" + state.getPercent() + "%)  " + state.getMessage());
            } else {
                Activator.setTask(monitor, state.getJob() + " " + state.getMessage());
            }
            if (state.getPercent() > total) {
                // empty if block
            }
            monitor.worked(state.getPercent() - total);
            total = state.getPercent();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        monitor.done();
    }

    public List getSuppliers() {
        ArrayList<String> suppliers = new ArrayList<String>();
        try {
            String supplier;
            File ini = new File(Platform.getConfigurationLocation().getURL().getFile(), "com.ibm.ut.ic.server/supplier.ini");
            BufferedReader br = new BufferedReader(new FileReader(ini));
            while ((supplier = br.readLine()) != null) {
                suppliers.add(supplier);
            }
            br.close();
        }
        catch (Exception e) {
            Activator.logWarning("Unable to read supplier.ini", e);
        }
        return suppliers;
    }

    public void addSupplier(String s) {
        List suppliers = this.getSuppliers();
        if (!suppliers.contains(s)) {
            suppliers.add(s);
            this.setSuppliers(suppliers);
        }
    }

    public void setSuppliers(List suppliers) {
        try {
            File ini = new File(Platform.getConfigurationLocation().getURL().getFile(), "com.ibm.ut.ic.server/supplier.ini");
            if (!ini.exists()) {
                ini.getParentFile().mkdirs();
                ini.createNewFile();
            }
            PrintWriter pw = new PrintWriter(new FileWriter(ini));
            int s = 0;
            while (s < suppliers.size()) {
                pw.println(suppliers.get(s));
                ++s;
            }
            pw.close();
        }
        catch (Exception e) {
            Activator.logWarning("Unable to save supplier.ini", e);
        }
    }

    class ConnectionThread
    extends Thread {
        private boolean done = false;
        private String xid;
        private Site site;

        public ConnectionThread(String xid, Site site) {
            this.xid = xid;
            this.site = site;
        }

        @Override
        public void run() {
            String repo = this.site.getURI();
            repo = HTMLUtil.encodeURL((String)repo);
            try {
                URL updateURL = new URL(LocalHelp.getLocalIC().getHref() + "/updater/config?op=InstallSite&xid=" + this.xid + "&uid=" + HTMLUtil.encodeURL((String)this.site.getUID()) + "&name=" + HTMLUtil.encodeURL((String)this.site.getName()) + "&uri=" + repo);
                Activator.logDebug("Installing: " + String.valueOf(updateURL));
                URLUtil.getStream((URL)updateURL).close();
                try {
                    Reflect.staticCall(TocServlet.class, (String)"clearCache", (Object[])new Object[0]);
                }
                catch (Exception e) {
                    Activator.logWarning("Could not find TocServlet.clearCache()", e);
                }
                InitialContentJob.this.addSupplier(this.site.getURI());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.done = true;
        }

        public boolean isComplete() {
            return this.done;
        }
    }
}

