/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.ic.server;

import com.ibm.ccl.help.preferenceharvester.LocalHelp;
import com.ibm.ut.help.common.io.FileHandler;
import com.ibm.ut.help.common.reflect.Reflect;
import com.ibm.ut.ic.server.Activator;
import com.ibm.ut.ic.server.Messages;
import com.ibm.ut.ic.server.ZipFileUtility;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class JettyServer {
    private int port = -1;
    private Object server;
    private String pluginID;
    private String srvPkg;
    private String webappPkg;

    public JettyServer(String pluginID) {
        this.pluginID = pluginID;
        if (pluginID.equalsIgnoreCase("org.eclipse.jetty.webapp")) {
            this.srvPkg = "org.eclipse.jetty.server";
            this.webappPkg = "org.eclipse.jetty.webapp";
        } else if (pluginID.equalsIgnoreCase("org.mortbay.jetty.server")) {
            this.srvPkg = "org.mortbay.jetty";
            this.webappPkg = "org.mortbay.jetty.webapp";
        }
    }

    public void deploy(File war, File work, int preferredPort, IProgressMonitor monitor) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ServerStartupTicker ticker;
        new Date().getTime();
        this.port = preferredPort;
        monitor.beginTask(Messages.SERVER_STARTUP, 100);
        Reflect reflect = new Reflect(this.pluginID);
        this.server = reflect.init(this.srvPkg + ".Server", new Object[]{this.port});
        Object handler = reflect.init(this.srvPkg + ".handler.HandlerCollection", new Object[0]);
        Reflect.call((Object)this.server, (String)"setHandler", (Object[])new Object[]{handler});
        if (war == null) {
            return;
        }
        File webDefault = new File(work, "webdefault.xml");
        try {
            FileHandler.extractFromBundle((String)this.pluginID, (String)("/" + this.webappPkg.replaceAll("\\.", "/") + "/webdefault.xml"), (File)webDefault);
        }
        catch (IOException e1) {
            Activator.logError(e1.getMessage(), e1);
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!LocalHelp.isExtracted()) {
            ZipFileUtility.extractZipFile(war.getAbsolutePath(), new File(work, "webapp").getAbsolutePath(), (IProgressMonitor)subMonitor.split(50));
            ticker = new ServerStartupTicker((IProgressMonitor)subMonitor.split(50), 150);
        } else {
            ticker = new ServerStartupTicker((IProgressMonitor)subMonitor.split(50), 10);
        }
        subMonitor.done();
        Object context = reflect.init(this.webappPkg + ".WebAppContext", new Object[0]);
        Reflect.call((Object)context, (String)"setTempDirectory", (Object[])new Object[]{work});
        Reflect.call((Object)context, (String)"setContextPath", (Object[])new Object[]{"/help"});
        Reflect.call((Object)context, (String)"setExtractWAR", (Object[])new Object[]{true});
        Reflect.call((Object)context, (String)"setWar", (Object[])new Object[]{new File(work, "webapp").getAbsolutePath()});
        Reflect.call((Object)context, (String)"setDefaultsDescriptor", (Object[])new Object[]{webDefault.getAbsolutePath()});
        Reflect.call((Object)this.server, (String)"setHandler", (Object[])new Object[]{context});
        try {
            try {
                ticker.start();
                Reflect.call((Object)this.server, (String)"setStopAtShutdown", (Object[])new Object[]{true});
                Reflect.call((Object)this.server, (String)"start", (Object[])new Object[0]);
                ticker.cancel();
            }
            catch (Exception e) {
                Activator.logError("Could not start jetty server.", e);
                monitor.done();
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        try {
            Reflect.call((Object)this.server, (String)"setGracefulShutdown", (Object[])new Object[]{0});
            Reflect.call((Object)this.server, (String)"stop", (Object[])new Object[0]);
            this.port = -1;
        }
        catch (Exception e) {
            Activator.logError("Unable to stop server.", e);
        }
    }

    private class ServerStartupTicker
    extends Thread {
        private IProgressMonitor monitor;
        private int sec;
        private boolean cancel = false;

        public ServerStartupTicker(IProgressMonitor monitor, int sec) {
            this.monitor = monitor;
            this.sec = sec;
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void run() {
            this.monitor.beginTask("", this.sec);
            Activator.setTask(this.monitor, Messages.STARTUP_JOB_SERVER_STARTUP);
            int i = 1;
            while (i <= this.sec) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                if (this.cancel) {
                    return;
                }
                this.monitor.worked(1);
                ++i;
            }
        }
    }
}

