/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.ic.server;

import com.ibm.ccl.help.preferenceharvester.ICManager;
import com.ibm.ccl.help.preferenceharvester.LocalHelp;
import com.ibm.ut.help.common.IContentChangeListener;
import com.ibm.ut.help.common.connector.PlatformConnector;
import com.ibm.ut.help.common.event.ContentChangeEvent;
import com.ibm.ut.help.common.event.ContentChangeEventManager;
import com.ibm.ut.help.common.ic.IC;
import com.ibm.ut.help.common.prefs.ICPreferences;
import com.ibm.ut.help.common.prefs.Preferences;
import com.ibm.ut.ic.server.LocalServer;
import com.ibm.ut.ic.server.dialogs.AbstractMessageDialog;
import com.ibm.ut.ic.server.dialogs.CancelUpdatesDialog;
import com.ibm.ut.ic.server.dialogs.HelpWarningDialog;
import com.ibm.ut.ic.server.dialogs.InstallUpdatesDialog;
import com.ibm.ut.ic.server.dialogs.LHUConnectMessageDialog;
import com.ibm.ut.ic.server.dialogs.NetworkFailureDialog;
import com.ibm.ut.ic.server.jobs.PrefPageReplacerJob;
import com.ibm.ut.ic.server.jobs.ServerJob;
import com.ibm.ut.ic.server.prefs.PreferenceHandler;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "com.ibm.ut.ic.server";
    public static boolean LOG_WARN = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ut.ic.server/debug/warn"));
    public static boolean LOG_INFO = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ut.ic.server/debug/info"));
    private static Activator plugin;

    public static boolean isPrefHarv_202() {
        try {
            Class.forName("com.ibm.ccl.help.preferenceharvester.ServerInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        return false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (!Activator.isPrefHarv_202()) {
            this.disableICServer();
            Activator.logWarning("Using " + Platform.getBundle((String)"com.ibm.ccl.help.preferenceharvester").toString() + " to handle Local Server functions.");
            return;
        }
        Thread initThread = new Thread(){

            @Override
            public void run() {
                while (PlatformUI.getWorkbench().getWorkbenchWindowCount() == 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
                try {
                    ICManager.syncICs();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                Activator.this.initializePreferences();
                Activator.this.replacePrefPage();
            }
        };
        initThread.start();
    }

    public void initializePreferences() {
        Preferences prefs = new Preferences(PLUGIN_ID);
        String p = prefs.get("watchedFolder");
        if (p.equals("")) {
            File updateDir = new File(PlatformConnector.getConfigurationLocation(), "updates");
            if (updateDir != null && !updateDir.exists()) {
                updateDir.mkdirs();
            }
            prefs.set("watchedFolder", updateDir.getAbsolutePath());
            prefs.setDefault("watchedFolder", updateDir.getAbsolutePath());
        }
        ContentChangeEventManager.addContentChangeListener((IContentChangeListener)new IContentChangeListener(){
            private List prev = ICPreferences.getICs();

            public void contentChanged(ContentChangeEvent e) throws MalformedURLException {
                List ics = ICPreferences.getICs();
                if (e.getAction() == 2) {
                    int i = 0;
                    while (i < ics.size()) {
                        ServerJob job;
                        if (((IC)ics.get(i)).getName().equalsIgnoreCase("Local") && (job = ServerJob.get()).getState() != 4) {
                            job.start(false);
                        }
                        ++i;
                    }
                } else if (e.getAction() == -2) {
                    if (!ics.contains(LocalHelp.getLocalIC())) {
                        Activator.this.stopServer();
                    }
                } else if (e.getAction() == 0) {
                    boolean before = false;
                    boolean after = false;
                    int p = 0;
                    while (p < this.prev.size()) {
                        if (((IC)this.prev.get(p)).getName().equalsIgnoreCase("Local")) {
                            before = ((IC)this.prev.get(p)).isEnabled();
                        }
                        ++p;
                    }
                    int i = 0;
                    while (i < ics.size()) {
                        if (((IC)ics.get(i)).getName().equalsIgnoreCase("Local")) {
                            after = ((IC)ics.get(i)).isEnabled();
                        }
                        ++i;
                    }
                    if (before != after) {
                        ServerJob job = ServerJob.get();
                        if (after) {
                            if (job.getState() != 4) {
                                job.start(false);
                            }
                        } else {
                            Activator.this.stopServer();
                        }
                    }
                }
                this.prev = ICPreferences.getICs();
            }
        });
    }

    public void replacePrefPage() {
        PrefPageReplacerJob job = new PrefPageReplacerJob();
        job.schedule();
    }

    public void stopServer() {
        LocalServer.getInstance().stop();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void earlyStartup() {
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, message, ex);
        Activator.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logWarning(String message) {
        Activator.logWarning(message, null);
    }

    public static synchronized void logWarning(String message, Throwable ex) {
        if (Activator.getDefault().isDebugging() && LOG_WARN) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, ex);
            Activator.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public static synchronized void logDebug(String message) {
        if (Activator.getDefault().isDebugging() && LOG_INFO) {
            if (message == null) {
                message = "";
            }
            Status status = new Status(1, PLUGIN_ID, message);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public static synchronized void logStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            Activator.getDefault().getLog().log(status);
        } else if (status.getSeverity() == 2 && Activator.getDefault().isDebugging() && LOG_WARN) {
            Activator.getDefault().getLog().log(status);
        }
    }

    public static void setTask(IProgressMonitor monitor, String task) {
        if (monitor instanceof SubMonitor) {
            ((SubMonitor)monitor).subTask(task);
        } else {
            monitor.subTask(task);
        }
    }

    public static int displayDialog(String cls) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return -1;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        DialogRunnable runnable = new DialogRunnable(cls);
        wb.getDisplay().asyncExec((Runnable)runnable);
        return runnable.getReturnCode();
    }

    public static void displayHelpWarningDialog() {
        Activator.displayDialog(HelpWarningDialog.class.getCanonicalName());
    }

    public static int displayInstallUpdateDialog() {
        return Activator.displayDialog(InstallUpdatesDialog.class.getCanonicalName());
    }

    public static int displayCancelWarningDialog() {
        return Activator.displayDialog(CancelUpdatesDialog.class.getCanonicalName());
    }

    public static void displayNetworkFailureDialog() {
        Activator.displayDialog(NetworkFailureDialog.class.getCanonicalName());
    }

    public static void displayLHUActionErrorDialog() {
        Activator.displayDialog(LHUConnectMessageDialog.class.getCanonicalName());
    }

    public void disableICServer() {
        while (PlatformUI.getWorkbench().getWorkbenchWindowCount() == 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode contentPage = PreferenceHandler.getPageNode("com.ibm.ut.ic.server.prefs.ContentPreferencePage", pm.getRootSubNodes());
        PreferenceHandler.getPageParentNode(contentPage.getId(), pm.getRootSubNodes()).remove(contentPage);
    }

    static class DialogRunnable
    implements Runnable {
        private String clsName;
        private int code = -1;

        public DialogRunnable(String clsName) {
            this.clsName = clsName;
        }

        @Override
        public void run() {
            try {
                IWorkbench wb = PlatformUI.getWorkbench();
                Class<?> cls = Class.forName(this.clsName);
                Constructor<?> constructor = cls.getConstructor(Shell.class);
                AbstractMessageDialog dialog = (AbstractMessageDialog)((Object)constructor.newInstance(wb.getActiveWorkbenchWindow().getShell()));
                if (dialog != null) {
                    dialog.setBlockOnOpen(true);
                    this.code = dialog.open();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public int getReturnCode() {
            return this.code;
        }
    }
}

