/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.state.customization;

import com.ibm.ut.help.state.Activator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;

public class ProductCustomizer {
    public static final String ROOT = "/";
    public static final String PLUGIN_CUSTOMIZATION_INI = "plugin_customization.ini";

    public static String serializePluginCustomizations() throws IOException {
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<customizations>\n");
        Bundle[] bundles = Activator.getContext().getBundles();
        int b = 0;
        while (b < bundles.length) {
            Enumeration e = bundles[b].findEntries(ROOT, PLUGIN_CUSTOMIZATION_INI, false);
            while (e != null && e.hasMoreElements()) {
                result.append(ProductCustomizer.serialize(bundles[b].getSymbolicName(), (URL)e.nextElement()));
            }
            ++b;
        }
        result.append("</customizations>\n");
        return result.toString();
    }

    private static String serialize(String bundleID, URL pluginCustomization) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t<bundle name=\"" + bundleID + "\">\n");
        buffer.append("\t\t<customization");
        BufferedReader br = new BufferedReader(new InputStreamReader(pluginCustomization.openStream()));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#") || !line.contains("=")) continue;
            String[] prop = line.split("=");
            if (prop.length == 1) {
                prop = new String[]{prop[0], ""};
            }
            buffer.append("\n\t\t\t" + prop[0] + "=\"" + prop[1] + "\"");
        }
        buffer.append("/>\n");
        buffer.append("\t</bundle>\n");
        br.close();
        return buffer.toString();
    }
}

