/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.parser.json;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;

public class JSONElement
extends Properties {
    private static final String OFFSET = "  ";

    public JSONElement() {
    }

    public JSONElement(Properties properties) {
        this.setProperties(properties);
    }

    public void setProperties(Properties properties) {
        properties.setProperty("uid", UUID.randomUUID().toString());
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object val = properties.get(key);
            this.put(key, val);
        }
    }

    @Override
    public String getProperty(String name) {
        if (this.get(name) != null) {
            return String.valueOf(this.get(name));
        }
        return super.getProperty(name);
    }

    public int getInt(String name) {
        try {
            return (Integer)this.get(name);
        }
        catch (Exception exception) {
            try {
                return Integer.parseInt((String)this.get(name));
            }
            catch (Exception exception2) {
                return 0;
            }
        }
    }

    @Override
    public String toString() {
        return this.toJSON(0);
    }

    public String toQuickString() {
        return this.toJSON(0, true);
    }

    public String toJSON(int indentSize) {
        return this.toJSON(indentSize, false);
    }

    public String toJSON(int indentSize, boolean boost) {
        Object json = "";
        String indent = this.indent(indentSize);
        json = (String)json + indent + "{";
        Enumeration<Object> keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object val = this.get(key);
            if (val instanceof String) {
                try {
                    int x = Integer.parseInt((String)val);
                    val = "" + x;
                }
                catch (Exception exception) {
                    if (!boost) {
                        val = JSONElement.replaceAll((String)val, "\"", "\\\"");
                        val = JSONElement.replaceAll((String)val, "\n", "");
                        val = JSONElement.replaceAll((String)val, "\r", "");
                        val = JSONElement.replaceAll((String)val, ":", "\\:");
                    }
                    val = "\"" + String.valueOf(val) + "\"";
                }
            } else if (val instanceof ArrayList) {
                val = this.printList(indentSize, (ArrayList)val, boost);
            }
            json = (String)json + "\n" + indent + "  \"" + key + "\":" + String.valueOf(val) + ",";
        }
        json = ((String)json).substring(0, ((String)json).length() - 1);
        json = (String)json + "\n" + indent + "}\n";
        return json;
    }

    private String printList(int indentSize, ArrayList list, boolean boost) {
        String indent = this.indent(indentSize);
        Object json = "\n" + indent + "  [\n";
        int i = 0;
        while (i < list.size()) {
            try {
                int x = Integer.parseInt((String)list.get(i));
                json = (String)json + x + ",";
            }
            catch (Exception exception) {
                try {
                    String x = (String)list.get(i);
                    json = (String)json + "'" + x + "',";
                }
                catch (Exception exception2) {
                    JSONElement elem = list.get(i) instanceof JSONElement ? (JSONElement)list.get(i) : new JSONElement((Properties)list.get(i));
                    json = (String)json + "\n" + elem.toJSON(indentSize + 1, boost) + ",";
                }
            }
            ++i;
        }
        json = ((String)json).substring(0, ((String)json).length() - 1);
        json = (String)json + indent + "  ]\n";
        return json;
    }

    public String indent(int size) {
        Object indent = "";
        int i = 0;
        while (i < size) {
            indent = (String)indent + OFFSET;
            ++i;
        }
        return indent;
    }

    public static String wrapJSON(ArrayList elements) {
        Object json = "";
        json = (String)json + "{\n";
        json = (String)json + "  label: 'title',\n";
        json = (String)json + "  identifier: 'uid',\n";
        json = (String)json + "  items: [";
        int i = 0;
        while (elements != null && i < elements.size()) {
            JSONElement elem = (JSONElement)elements.get(i);
            json = (String)json + "\n" + elem.toJSON(1) + ",";
            ++i;
        }
        if (elements != null && elements.size() > 0) {
            json = ((String)json).substring(0, ((String)json).length() - 1);
        }
        json = (String)json + "  ]\n";
        json = (String)json + "}";
        return json;
    }

    public static String wrapJSON(String label, String id, ArrayList elements) {
        Object json = "";
        json = (String)json + "{\n";
        json = (String)json + "  label: '" + label + "',\n";
        json = (String)json + "  identifier: '" + id + "',\n";
        json = (String)json + "  items: [";
        int i = 0;
        while (elements != null && i < elements.size()) {
            JSONElement elem = (JSONElement)elements.get(i);
            json = (String)json + "\n" + elem.toJSON(1) + ",";
            ++i;
        }
        if (elements != null && elements.size() > 0) {
            json = ((String)json).substring(0, ((String)json).length() - 1);
        }
        json = (String)json + "  ]\n";
        json = (String)json + "}";
        return json;
    }

    public static String replaceAll(String str, String find, String replace) {
        String[] split = ("START" + str + "END").split(find);
        StringBuffer buffer = new StringBuffer();
        int s = 0;
        while (s < split.length) {
            buffer.append(split[s]);
            buffer.append(replace);
            ++s;
        }
        return buffer.substring(5, buffer.length() - ("END" + replace).length());
    }
}

