/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.parser;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class TagInputStreamReader
extends Reader {
    private InputStreamReader inReader;
    private String current = "";

    public TagInputStreamReader(InputStream in) {
        this.inReader = new InputStreamReader(in);
    }

    public TagInputStreamReader(InputStream in, String charset) {
        this.inReader = new InputStreamReader(in, Charset.forName(charset));
    }

    @Override
    public void close() throws IOException {
        this.inReader.close();
    }

    @Override
    public int read(char[] arg0, int arg1, int arg2) throws IOException {
        return this.inReader.read(arg0, arg1, arg2);
    }

    private void extendBuffer() throws IOException {
        char[] buffer = new char[1024];
        int read = this.read(buffer, 0, 1024);
        if (read == -1) {
            throw new EOFException();
        }
        String tmp = new String(buffer, 0, read);
        this.current = String.valueOf(this.current) + tmp;
    }

    public String readNextChunk() throws IOException {
        int g;
        int l;
        Object chunk = "";
        do {
            l = this.current.indexOf("<");
            g = this.current.indexOf(">");
            if (l != -1 && l != 0 || g != -1) continue;
            try {
                this.extendBuffer();
            }
            catch (EOFException eOFException) {
                return null;
            }
        } while ((l == -1 || l == 0) && g == -1);
        if (l != -1 && g != -1) {
            if (this.current.substring(l).startsWith("<![CDATA[")) {
                while ((g = this.current.indexOf("]]>", l)) == -1) {
                    try {
                        this.extendBuffer();
                    }
                    catch (EOFException eOFException) {
                        return null;
                    }
                }
                g += 2;
            }
            if (this.current.substring(l).startsWith("<!--")) {
                while ((g = this.current.indexOf("-->", l)) == -1) {
                    try {
                        this.extendBuffer();
                    }
                    catch (EOFException eOFException) {
                        return null;
                    }
                }
                g += 2;
            }
            if (l == 0) {
                chunk = (String)chunk + this.current.substring(l, g + 1);
                this.current = this.current.substring(g + 1);
                return chunk;
            }
            if (l < g) {
                chunk = (String)chunk + this.current.substring(0, l);
                this.current = this.current.substring(l);
                return chunk;
            }
            chunk = (String)chunk + this.current.substring(0, g + 1);
            this.current = this.current.substring(g + 1);
            return chunk;
        }
        if (l != -1) {
            chunk = (String)chunk + this.current.substring(0, l);
            this.current = this.current.substring(l);
            return chunk;
        }
        if (g != -1) {
            chunk = (String)chunk + this.current.substring(0, g + 1);
            this.current = this.current.substring(g + 1);
            return chunk;
        }
        return null;
    }
}

